/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.server;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.op.AddToIndexOperation;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.jboss.ide.eclipse.as.core.modules.ResourceModuleResourceUtil;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.IModulePathFilter;
import org.jboss.ide.eclipse.as.core.server.IModulePathFilterProvider;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.wtp.core.server.publish.LocalZippedModulePublishRunner;
import org.jboss.tools.as.core.internal.modules.ModuleDeploymentPrefsUtil;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.express.core.OpenshiftCoreUIIntegration;
import org.jboss.tools.openshift.express.internal.core.OpenShiftCoreActivator;
import org.jboss.tools.openshift.express.internal.core.server.OpenShiftServerMessages;
import org.jboss.tools.openshift.express.internal.core.server.OpenShiftServerUtils;

public class OpenShiftServerPublishMethod {
    public void publishStart(IServer server, IProgressMonitor monitor) throws CoreException {
        IProject magicProject;
        String destProjName = OpenShiftServerUtils.getDeployProjectName((IServerAttributes)server);
        IProject iProject = magicProject = destProjName == null ? null : ResourcesPlugin.getWorkspace().getRoot().getProject(destProjName);
        if (magicProject == null || !magicProject.isAccessible()) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.openshift.express.core", NLS.bind((String)OpenShiftServerMessages.publishFailMissingProject, (Object)server.getName(), (Object)destProjName)));
        }
    }

    public int publishFinish(IServer server, IProgressMonitor monitor) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(OpenShiftServerUtils.getDeployProjectName((IServerAttributes)server));
        boolean allSubModulesPublished = this.areAllPublished(server);
        if (project != null && project.exists()) {
            String deployFolder = OpenShiftServerUtils.getDeployFolder((IServerAttributes)server);
            IContainer container = OpenShiftServerUtils.getDeployFolderResource(deployFolder, project);
            if (allSubModulesPublished || container != null && container.isAccessible()) {
                this.refreshProject(project, OpenShiftServerPublishMethod.submon(monitor, 100));
                this.publish(project, server, OpenShiftServerPublishMethod.submon(monitor, 100));
            }
        }
        return allSubModulesPublished ? 1 : 2;
    }

    protected boolean areAllPublished(IServer server) {
        IModule[] modules = server.getModules();
        boolean allpublished = true;
        int i = 0;
        while (i < modules.length) {
            if (server.getModulePublishState(new IModule[]{modules[i]}) != 1) {
                allpublished = false;
            }
            ++i;
        }
        return allpublished;
    }

    public int publishModule(IServer server, int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        if (module.length > 1) {
            return 0;
        }
        String destProjName = OpenShiftServerUtils.getDeployProjectName((IServerAttributes)server);
        if (this.isInDestProjectTree(destProjName, module)) {
            return 1;
        }
        IProject destProj = ResourcesPlugin.getWorkspace().getRoot().getProject(destProjName);
        if (destProj.equals((Object)module[module.length - 1].getProject())) {
            return 1;
        }
        IContainer destFolder = this.getDestination(server, destProj);
        IPath destPath = destFolder.getLocation();
        if (module.length == 0) {
            return 1;
        }
        int modulePublishState = server.getModulePublishState(module);
        this.getPublishType(kind, deltaKind, modulePublishState);
        IModuleResourceDelta[] cfr_ignored_0 = new IModuleResourceDelta[0];
        if (deltaKind != 3) {
            ((Server)server).getPublishedResourceDelta(module);
        }
        try {
            IPath outputFileFullPath = OpenShiftServerPublishMethod.getModuleNestedDeployPath(module, destPath.toOSString(), server);
            String outputFileName = outputFileFullPath.lastSegment();
            IFile changedResource = destFolder.getFile((IPath)new Path(outputFileName));
            IResource[] resource = new IResource[]{changedResource};
            if (deltaKind == 3) {
                changedResource.delete(false, monitor);
            } else {
                LocalZippedModulePublishRunner runner = this.createZippedRunner(server, module[0], outputFileFullPath);
                monitor.beginTask("Moving module to " + destFolder.getName(), 100);
                runner.fullPublishModule((IProgressMonitor)new SubProgressMonitor(monitor, 20));
                destFolder.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                AddToIndexOperation operation = new AddToIndexOperation(resource);
                try {
                    operation.execute((IProgressMonitor)new SubProgressMonitor(monitor, 60));
                }
                catch (CoreException e) {
                    OpenShiftCoreActivator.pluginLog().logStatus(e.getStatus());
                }
            }
        }
        catch (Exception e) {
            OpenShiftCoreActivator.pluginLog().logError(e.getMessage(), (Throwable)e);
        }
        return 1;
    }

    public static IPath getModuleNestedDeployPath(IModule[] moduleTree, String rootFolder, IServer server) {
        return new ModuleDeploymentPrefsUtil().getModuleNestedDeployPath(moduleTree, rootFolder, (IServerAttributes)server);
    }

    private LocalZippedModulePublishRunner createZippedRunner(IServer server, IModule m, IPath p) {
        return new LocalZippedModulePublishRunner(server, m, p, this.getModulePathFilterProvider());
    }

    private IModulePathFilterProvider getModulePathFilterProvider() {
        return new IModulePathFilterProvider(){

            public IModulePathFilter getFilter(IServer server, IModule[] module) {
                return ResourceModuleResourceUtil.findDefaultModuleFilter((IModule)module[module.length - 1]);
            }
        };
    }

    protected IContainer getDestination(IServer server, IProject destProj) throws CoreException {
        String destinationFolder = OpenShiftServerUtils.getDeployFolder((IServerAttributes)server);
        IContainer destFolder = OpenShiftServerUtils.getDeployFolderResource(destinationFolder, destProj);
        if (destFolder == null || !destFolder.isAccessible()) {
            throw new CoreException(OpenShiftCoreActivator.statusFactory().errorStatus(NLS.bind((String)OpenShiftServerMessages.publishFailMissingFolder, (Object)server.getName(), (Object)this.createMissingPath(destProj, destinationFolder, destFolder))));
        }
        return destFolder;
    }

    protected StringBuilder createMissingPath(IProject destProj, String destinationFolder, IContainer destFolder) {
        StringBuilder missingPath = new StringBuilder();
        if (destFolder != null) {
            missingPath.append(destFolder.getName());
        } else {
            missingPath.append(destProj.getName());
            missingPath.append(File.separatorChar);
            missingPath.append(destinationFolder);
        }
        return missingPath;
    }

    protected boolean isInDestProjectTree(String magicProject, IModule[] module) {
        IProject moduleProject;
        IProject magic;
        IProject iProject = magic = magicProject == null ? null : ResourcesPlugin.getWorkspace().getRoot().getProject(magicProject);
        IProject iProject2 = module == null ? null : (moduleProject = module.length == 0 ? null : module[module.length - 1].getProject());
        if (magic == null || moduleProject == null) {
            return false;
        }
        IPath moduleProjectRoot = moduleProject.getLocation();
        IPath magicProjectRoot = magic.getLocation();
        return magicProjectRoot.isPrefixOf(moduleProjectRoot);
    }

    protected PushOperationResult publish(final IProject project, final IServer server, final IProgressMonitor monitor) throws CoreException {
        int uncommittedChanges = OpenShiftServerUtils.countCommitableChanges(project, server, monitor);
        try {
            if (uncommittedChanges > 0) {
                OpenshiftCoreUIIntegration.openCommitDialog(project, (IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        if (event.getResult().isOK()) {
                            try {
                                try {
                                    OpenShiftServerPublishMethod.this.push(project, server, monitor);
                                }
                                catch (CoreException e) {
                                    OpenShiftCoreActivator.getDefault().getLog().log(e.getStatus());
                                    monitor.done();
                                }
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    }
                });
            } else if (OpenshiftCoreUIIntegration.requestApproval(this.getPushQuestion(project, server, monitor), NLS.bind((String)OpenShiftServerMessages.publishTitle, (Object)project.getName()))) {
                return this.push(project, server, monitor);
            }
        }
        catch (Exception e) {
            OpenShiftCoreActivator.pluginLog().logError((Throwable)e);
        }
        return null;
    }

    private String getPushQuestion(IProject project, IServer server, IProgressMonitor monitor) throws IOException, InvocationTargetException, URISyntaxException {
        String openShiftRemoteName = OpenShiftServerUtils.getRemoteName((IServerAttributes)server);
        if (!EGitUtils.isAhead((IProject)project, (String)openShiftRemoteName, (IProgressMonitor)monitor)) {
            return NLS.bind((String)OpenShiftServerMessages.noChangesPushAnywayMsg, (Object)project.getName());
        }
        return NLS.bind((String)OpenShiftServerMessages.committedChangesNotPushedYet, (Object)project.getName());
    }

    private PushOperationResult push(IProject project, IServer server, IProgressMonitor monitor) throws CoreException {
        Repository repository = EGitUtils.getRepository((IProject)project);
        OpenshiftCoreUIIntegration.displayConsoleView(server);
        String remoteName = OpenShiftServerUtils.getRemoteName((IServerAttributes)server.createWorkingCopy());
        try {
            monitor.beginTask("Publishing " + project.getName(), 200);
            PushOperationResult pushOperationResult = EGitUtils.push((String)remoteName, (Repository)repository, (IProgressMonitor)new SubProgressMonitor(monitor, 100), (OutputStream)OpenshiftCoreUIIntegration.getConsoleOutputStream(server));
            return pushOperationResult;
        }
        catch (CoreException ce) {
            if (this.isUpToDateError(ce)) {
                OpenshiftCoreUIIntegration.appendToConsole(server, "\n\nRepository already uptodate.");
                return null;
            }
            if (OpenshiftCoreUIIntegration.requestApproval("Error: '" + ce.getMessage() + "' occurred while pushing.\n\nIf the commit history is not correct on the remote repository, " + "a forced push (git push -f) might be the right thing to do. This will though overwrite the remote repository!" + "\n\n Do you want to do a forced push and overwrite any remote changes ? ", "Attempt push force ?", false)) {
                PushOperationResult pushOperationResult = EGitUtils.pushForce((String)remoteName, (Repository)repository, (IProgressMonitor)new SubProgressMonitor(monitor, 100), (OutputStream)OpenshiftCoreUIIntegration.getConsoleOutputStream(server));
                return pushOperationResult;
            }
            OpenshiftCoreUIIntegration.appendToConsole(server, "\n\nERROR: " + ce.getLocalizedMessage() + "\n\n" + "To prevent you from losing history, non-fast-forward updates were rejected" + "\nMerge the remote changes (e.g. 'Team > Fetch from Upstream' in Eclipse or 'git pull' on command line ) before pushing again. " + "\nSee the 'Note about fast-forwards' section of 'git push --help' for details.");
            monitor.done();
            return null;
        }
        finally {
            monitor.done();
        }
    }

    private boolean isUpToDateError(CoreException ce) {
        return ce.getMessage() != null && ce.getMessage().contains("UP_TO_DATE");
    }

    protected String getModuleProjectName(IModule[] module) {
        return module[module.length - 1].getProject().getName();
    }

    public String getPublishDefaultRootFolder(IServer server) {
        IDeployableServer s = ServerConverter.getDeployableServer((IServerAttributes)server);
        return s.getDeployFolder();
    }

    public String getPublishDefaultRootTempFolder(IServer server) {
        IDeployableServer s = ServerConverter.getDeployableServer((IServerAttributes)server);
        return s.getTempDeployFolder();
    }

    protected void refreshProject(IProject project, IProgressMonitor monitor) throws CoreException {
        project.refreshLocal(2, monitor);
    }

    public static IProgressMonitor submon(IProgressMonitor parent, int ticks) {
        return OpenShiftServerPublishMethod.submon(parent, ticks, 4);
    }

    public static IProgressMonitor submon(IProgressMonitor parent, int ticks, int style) {
        return parent == null ? new NullProgressMonitor() : new SubProgressMonitor(parent, ticks, style);
    }

    public int getPublishType(int kind, int deltaKind, int modulePublishState) {
        if (deltaKind == 1) {
            return 2;
        }
        if (deltaKind == 3) {
            return 3;
        }
        if (kind == 2 || modulePublishState == 3 || kind == 4) {
            return 2;
        }
        if ((kind == 1 || modulePublishState == 2 || kind == 3) && 2 == deltaKind) {
            return 1;
        }
        return 0;
    }
}

