/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.preferences;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jboss.tools.openshift.express.internal.core.preferences.AbstractPreferenceValue;

public class StringsPreferenceValue
extends AbstractPreferenceValue<String[]> {
    private String delimiter;
    private String escapedDelimiter;

    public StringsPreferenceValue(char delimiter, String prefsKey, String pluginId) {
        super(prefsKey, pluginId);
        this.delimiter = String.valueOf(delimiter);
        try {
            this.escapedDelimiter = URLEncoder.encode(String.valueOf(delimiter), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    @Override
    public String[] get() {
        return this.get(null);
    }

    @Override
    public String[] get(String[] currentValues) {
        String string = this.doGet(null);
        String[] prefValues = this.split(string);
        return this.overrideValues(currentValues, prefValues);
    }

    private String[] split(String string) {
        ArrayList<String> values = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(string, this.delimiter);
        while (tokenizer.hasMoreTokens()) {
            String value = tokenizer.nextToken();
            String unescapedValue = this.unescapeDelimiterCharacter(value);
            values.add(unescapedValue);
        }
        return values.toArray(new String[values.size()]);
    }

    private String[] overrideValues(String[] newValues, String[] prefValues) {
        if (prefValues == null) {
            return newValues;
        }
        int i = 0;
        while (i < prefValues.length) {
            if (newValues == null || newValues.length < i) break;
            prefValues[i] = newValues[i];
            ++i;
        }
        return prefValues;
    }

    public void add(String value) {
        String currentValues = this.doGet();
        StringBuilder builder = new StringBuilder(currentValues);
        if (!this.contains(value = this.escapeDelimiterCharacter(value), currentValues)) {
            if (this.hasValues(currentValues)) {
                builder.append(this.delimiter);
            }
            builder.append(value);
            this.doStore(builder.toString());
        }
    }

    private String escapeDelimiterCharacter(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        int index = value.indexOf(this.delimiter);
        if (index < 0) {
            return value;
        }
        StringBuilder builder = new StringBuilder(value.substring(0, index));
        builder.append(this.escapedDelimiter);
        builder.append(value.substring(index + 1));
        return builder.toString();
    }

    private String unescapeDelimiterCharacter(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        int index = value.indexOf(this.escapedDelimiter);
        if (index < 0) {
            return value;
        }
        StringBuilder builder = new StringBuilder(value.substring(0, index));
        builder.append(this.delimiter);
        builder.append(value.substring(index + 1));
        return builder.toString();
    }

    private boolean contains(String value, String currentValues) {
        return currentValues != null && currentValues.length() > 0 && currentValues.indexOf(value) >= 0;
    }

    private boolean hasValues(String currentValues) {
        return currentValues != null && currentValues.length() > 0;
    }

    public void remove(String ... valuesToRemove) {
        boolean removed = false;
        String[] currentValues = this.get();
        if (valuesToRemove != null) {
            int i = 0;
            while (i < currentValues.length) {
                String[] stringArray = valuesToRemove;
                int n = valuesToRemove.length;
                int n2 = 0;
                while (n2 < n) {
                    String valueToRemove = stringArray[n2];
                    if (valueToRemove.equals(currentValues[i])) {
                        currentValues[i] = null;
                        removed = true;
                    }
                    ++n2;
                }
                ++i;
            }
        }
        if (removed) {
            this.store(currentValues);
        }
    }

    @Override
    public void store(String[] newValues) {
        this.doStore(this.concatenate(newValues));
    }

    public void store() {
        this.store(null);
    }

    protected String concatenate(String[] values) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < values.length) {
            if (values[i] != null) {
                if (builder.length() > 0) {
                    builder.append(this.delimiter);
                }
                builder.append(values[i]);
            }
            ++i;
        }
        return builder.toString();
    }
}

