/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.preferences;

import com.openshift.client.IApplication;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.jboss.tools.openshift.express.internal.core.preferences.IOpenShiftPreferenceConstants;
import org.jboss.tools.openshift.express.internal.core.preferences.StringsPreferenceValue;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;

public class OpenShiftPreferences
implements IOpenShiftPreferenceConstants {
    private static final String UI_PLUGIN_ID = "org.jboss.tools.openshift.express.ui";
    private static final String DEFAULT_TAIL_FILE_OPTIONS = "-f -n 100 */logs/*";
    public static final OpenShiftPreferences INSTANCE = new OpenShiftPreferences();
    private StringsPreferenceValue connectionsPreferenceValue;
    private StringsPreferenceValue legacyConnections;
    private StringsPreferenceValue UI_connectionsPreferenceValue;
    private StringsPreferenceValue UI_legacyConnections;
    private StringsPreferenceValue tailFileOptionsPreferenceValues;
    private Map<String, String> tailOptionsByUUID = new HashMap<String, String>();
    private StringsPreferenceValue snapshotFilesPreferenceValues;
    private Map<String, Snapshots> snapshotsByUUID = new HashMap<String, Snapshots>();

    private OpenShiftPreferences() {
        this.connectionsPreferenceValue = new StringsPreferenceValue('|', "org.jboss.tools.openshift.express.CONNECTION_NAMES", "org.jboss.tools.openshift.express.core");
        this.legacyConnections = new StringsPreferenceValue('|', "org.jboss.tools.openshift.express.internal.ui.wizard.CredentialsWizardModel_RHLOGIN_LIST", "org.jboss.tools.openshift.express.core");
        this.UI_connectionsPreferenceValue = new StringsPreferenceValue('|', "org.jboss.tools.openshift.express.CONNECTION_NAMES", UI_PLUGIN_ID);
        this.UI_legacyConnections = new StringsPreferenceValue('|', "org.jboss.tools.openshift.express.internal.ui.wizard.CredentialsWizardModel_RHLOGIN_LIST", UI_PLUGIN_ID);
        this.tailFileOptionsPreferenceValues = new StringsPreferenceValue('|', "org.jboss.tools.openshift.express.TAILFILEOPTIONS", "org.jboss.tools.openshift.express.core");
        this.initTailFileOptions(this.tailFileOptionsPreferenceValues.get());
        this.snapshotFilesPreferenceValues = new StringsPreferenceValue('|', "org.jboss.tools.openshift.express.SNAPSHOT_FILES", "org.jboss.tools.openshift.express.core");
        this.initSnapshotFiles(this.snapshotFilesPreferenceValues.get());
    }

    private void initTailFileOptions(String[] options) {
        if (options == null || options.length == 0) {
            return;
        }
        int i = 0;
        while (i < options.length - 1) {
            String uuid = options[i];
            String tailOptions = options[i + 1];
            this.tailOptionsByUUID.put(uuid, tailOptions);
            i += 2;
        }
    }

    private void initSnapshotFiles(String[] snapshotFiles) {
        if (snapshotFiles == null || snapshotFiles.length == 0) {
            return;
        }
        int i = 0;
        while (i < snapshotFiles.length - 1) {
            String uuid = snapshotFiles[i];
            String fullSnapshotFile = snapshotFiles[i + 1];
            String deploymentSnapshotFile = snapshotFiles[i + 2];
            this.snapshotsByUUID.put(uuid, new Snapshots(fullSnapshotFile, deploymentSnapshotFile));
            i += 3;
        }
    }

    private IEclipsePreferences getPrefs(String id) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(id);
        return prefs;
    }

    public String getDefaultHost() {
        String ret = this.getPrefs("org.jboss.tools.openshift.express.core").get("org.jboss.tools.openshift.express.SERVER", null);
        return ret == null ? this.getPrefs(UI_PLUGIN_ID).get("org.jboss.tools.openshift.express.SERVER", null) : ret;
    }

    public void setDefaultHost(String host) {
        this.getPrefs("org.jboss.tools.openshift.express.core").put("org.jboss.tools.openshift.express.SERVER", host);
    }

    public String getLastUsername() {
        String ret = this.getPrefs("org.jboss.tools.openshift.express.core").get("org.jboss.tools.openshift.express.LAST_USERNAME", null);
        return ret == null ? this.getPrefs(UI_PLUGIN_ID).get("org.jboss.tools.openshift.express.LAST_USERNAME", null) : ret;
    }

    public void saveLastUsername(String username) {
        this.getPrefs("org.jboss.tools.openshift.express.core").put("org.jboss.tools.openshift.express.LAST_USERNAME", username);
    }

    public String getTailFileOptions(IApplication application) {
        String tailFileOptions = null;
        if (application != null) {
            tailFileOptions = this.tailOptionsByUUID.get(application.getUUID());
        }
        if (tailFileOptions == null || tailFileOptions.isEmpty()) {
            tailFileOptions = DEFAULT_TAIL_FILE_OPTIONS;
        }
        return tailFileOptions;
    }

    public void saveTailFileOptions(IApplication application, String tailFileOptions) {
        if (application != null) {
            this.tailOptionsByUUID.put(application.getUUID(), tailFileOptions);
        }
        this.saveAllTailOptions();
    }

    private void saveAllTailOptions() {
        ArrayList<String> uuidsAndOptions = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.tailOptionsByUUID.entrySet()) {
            String uuid = entry.getKey();
            String options = entry.getValue();
            uuidsAndOptions.add(uuid);
            uuidsAndOptions.add(options);
        }
        this.tailFileOptionsPreferenceValues.store(uuidsAndOptions.toArray(new String[uuidsAndOptions.size()]));
    }

    public String getFullSnapshot(IApplication application) {
        String fullSnapshot = null;
        Snapshots snapshots = this.getSnapshots(application);
        if (snapshots != null) {
            fullSnapshot = snapshots.getFullSnapshotFile();
        }
        return fullSnapshot;
    }

    public String getDeploymentSnapshot(IApplication application) {
        String deploymentSnapshot = null;
        Snapshots snapshots = this.getSnapshots(application);
        if (snapshots != null) {
            deploymentSnapshot = snapshots.getDeploymentSnapshotFile();
        }
        return deploymentSnapshot;
    }

    public Snapshots getSnapshots(IApplication application) {
        if (application == null) {
            return null;
        }
        return this.snapshotsByUUID.get(application.getUUID());
    }

    public void saveSnapshots(IApplication application, String fullSnapshotFile, String deploymentSnapshotFile) {
        if (application != null) {
            this.snapshotsByUUID.put(application.getUUID(), new Snapshots(fullSnapshotFile, deploymentSnapshotFile));
        }
        this.saveAllSnapshots();
    }

    public void saveFullSnapshot(IApplication application, String filepath) {
        if (application == null) {
            return;
        }
        Snapshots snapshots = this.getSnapshots(application);
        if (snapshots == null) {
            snapshots = new Snapshots(filepath, null);
        }
        this.snapshotsByUUID.put(application.getUUID(), snapshots);
        this.saveAllSnapshots();
    }

    public void saveDeploymentSnapshot(IApplication application, String filepath) {
        if (application == null) {
            return;
        }
        Snapshots snapshots = this.getSnapshots(application);
        if (snapshots == null) {
            snapshots = new Snapshots(null, filepath);
        }
        this.snapshotsByUUID.put(application.getUUID(), snapshots);
        this.saveAllSnapshots();
    }

    private void saveAllSnapshots() {
        ArrayList<String> uuidsAndSnapshots = new ArrayList<String>();
        for (Map.Entry<String, Snapshots> entry : this.snapshotsByUUID.entrySet()) {
            String uuid = entry.getKey();
            Snapshots snapshots = entry.getValue();
            uuidsAndSnapshots.add(uuid);
            uuidsAndSnapshots.add(snapshots.getFullSnapshotFile());
            uuidsAndSnapshots.add(snapshots.getDeploymentSnapshotFile());
        }
        this.tailFileOptionsPreferenceValues.store(uuidsAndSnapshots.toArray(new String[uuidsAndSnapshots.size()]));
    }

    public String[] getConnections() {
        String[] ret = this.connectionsPreferenceValue.get();
        return ret == null ? this.UI_connectionsPreferenceValue.get() : ret;
    }

    public void saveConnections(String[] connections) {
        this.connectionsPreferenceValue.store(connections);
    }

    public String[] getLegacyConnections() {
        String[] ret = this.legacyConnections.get();
        return ret == null ? this.UI_legacyConnections.get() : ret;
    }

    public void saveLegacyConnections(String[] connections) {
        this.legacyConnections.store(connections);
    }

    public void setClientReadTimeout(int timeout) {
        this.getPrefs("org.jboss.tools.openshift.express.core").put("com.openshift.httpclient.read.timeout", String.valueOf(timeout));
    }

    public int getClientReadTimeout(int defaultTimeout) {
        String timeout = this.getPrefs("org.jboss.tools.openshift.express.core").get("com.openshift.httpclient.read.timeout", String.valueOf(defaultTimeout));
        return this.toInteger(timeout);
    }

    public void flush() {
    }

    private int toInteger(String value) {
        if (StringUtils.isEmptyOrNull(value)) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public class Snapshots {
        private String fullSnapshotFile;
        private String deploymentSnapshotFile;

        private Snapshots(String fullSnapshotFile, String deploymentSnapshotFile) {
            this.fullSnapshotFile = fullSnapshotFile;
            this.deploymentSnapshotFile = deploymentSnapshotFile;
        }

        public String getFullSnapshotFile() {
            return this.fullSnapshotFile;
        }

        public String getDeploymentSnapshotFile() {
            return this.deploymentSnapshotFile;
        }
    }
}

