/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.preferences;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public abstract class AbstractPreferenceValue<TYPE> {
    private String pluginId;
    private String prefsKey;

    public AbstractPreferenceValue(String prefsKey, String pluginId) {
        this.pluginId = pluginId;
        this.prefsKey = prefsKey;
    }

    public abstract TYPE get();

    protected String doGet() {
        return this.doGet(null);
    }

    public abstract TYPE get(TYPE var1);

    protected String doGet(String currentValue) {
        if (currentValue == null || currentValue.equals("")) {
            Preferences prefs = this.getPreferences(this.pluginId);
            return prefs.get(this.prefsKey, "");
        }
        return currentValue;
    }

    public void remove() {
        String prefsValue = this.doGet();
        if (prefsValue == null || prefsValue == null) {
            return;
        }
        this.store(null);
    }

    public abstract void store(TYPE var1);

    protected void doStore(String value) {
        Preferences prefs = this.getPreferences(this.pluginId);
        String prefsValue = prefs.get(this.prefsKey, "");
        if (prefsValue == null || prefsValue.equals("") || !prefsValue.equals(value)) {
            prefs.put(this.prefsKey, value);
            try {
                prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    protected Preferences getPreferences(String pluginId) {
        return InstanceScope.INSTANCE.getNode(pluginId);
    }
}

