/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.marker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.jboss.tools.openshift.express.internal.core.marker.BaseOpenShiftMarker;
import org.jboss.tools.openshift.express.internal.core.marker.IOpenShiftMarker;
import org.jboss.tools.openshift.express.internal.core.util.OpenShiftProjectUtils;

public class OpenShiftMarkers {
    private IProject project;
    private Collection<IOpenShiftMarker> allKnownMarkers;

    public OpenShiftMarkers(IProject project) {
        this.project = project;
        this.allKnownMarkers = new ArrayList<IOpenShiftMarker>();
        this.allKnownMarkers.add(IOpenShiftMarker.DISABLE_AUTO_SCALING);
        this.allKnownMarkers.add(IOpenShiftMarker.ENABLE_JPA);
        this.allKnownMarkers.add(IOpenShiftMarker.FORCE_CLEAN_BUILD);
        this.allKnownMarkers.add(IOpenShiftMarker.HOT_DEPLOY);
        this.allKnownMarkers.add(IOpenShiftMarker.JAVA_7);
        this.allKnownMarkers.add(IOpenShiftMarker.SKIP_MAVEN_BUILD);
    }

    public List<IOpenShiftMarker> getAll() throws CoreException {
        final ArrayList<IOpenShiftMarker> allMarkers = new ArrayList<IOpenShiftMarker>();
        allMarkers.addAll(this.getAllKnownMarkers());
        final IFolder folder = OpenShiftProjectUtils.getMarkersFolder(this.project);
        if (folder != null && folder.isAccessible()) {
            folder.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource == folder) {
                        return true;
                    }
                    if (resource.getType() != 1) {
                        return false;
                    }
                    if (OpenShiftMarkers.this.startsWithDot(resource)) {
                        return false;
                    }
                    if (!OpenShiftMarkers.this.isKnownMarker(resource.getName())) {
                        allMarkers.add(OpenShiftMarkers.this.createUnknownMarker(resource));
                    }
                    return false;
                }
            }, 1, false);
        }
        return allMarkers;
    }

    public List<IOpenShiftMarker> getPresent() throws CoreException {
        final ArrayList<IOpenShiftMarker> allMarkers = new ArrayList<IOpenShiftMarker>();
        final IFolder folder = OpenShiftProjectUtils.getMarkersFolder(this.project);
        if (folder != null && folder.isAccessible()) {
            folder.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource == folder) {
                        return true;
                    }
                    if (resource.getType() != 1) {
                        return false;
                    }
                    if (OpenShiftMarkers.this.startsWithDot(resource)) {
                        return false;
                    }
                    allMarkers.add(OpenShiftMarkers.this.getMarker(resource));
                    return false;
                }
            }, 1, false);
        }
        return allMarkers;
    }

    private boolean startsWithDot(IResource resource) {
        if (resource == null || !resource.isAccessible()) {
            return false;
        }
        return resource.getName().startsWith(".");
    }

    private IOpenShiftMarker getMarker(IResource resource) {
        IOpenShiftMarker marker = this.getKnownMarker(resource.getName());
        if (marker == null) {
            marker = this.createUnknownMarker(resource);
        }
        return marker;
    }

    private IOpenShiftMarker createUnknownMarker(IResource resource) {
        return new BaseOpenShiftMarker(resource.getName(), resource.getName(), null);
    }

    private boolean isKnownMarker(String fileName) {
        return this.getKnownMarker(fileName) != null;
    }

    private IOpenShiftMarker getKnownMarker(String fileName) {
        for (IOpenShiftMarker marker : this.getAllKnownMarkers()) {
            if (!marker.getFileName().equals(fileName)) continue;
            return marker;
        }
        return null;
    }

    private Collection<IOpenShiftMarker> getAllKnownMarkers() {
        return this.allKnownMarkers;
    }
}

