/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.connection;

import com.openshift.client.IApplication;
import com.openshift.client.IHttpClient;
import com.openshift.client.IUser;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.express.core.IConnectionsModelListener;
import org.jboss.tools.openshift.express.core.ICredentialsPrompter;
import org.jboss.tools.openshift.express.core.OpenShiftCoreException;
import org.jboss.tools.openshift.express.core.OpenshiftCoreUIIntegration;
import org.jboss.tools.openshift.express.internal.core.OpenShiftCoreActivator;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.core.connection.ConnectionURL;
import org.jboss.tools.openshift.express.internal.core.connection.ConnectionUtils;
import org.jboss.tools.openshift.express.internal.core.preferences.OpenShiftPreferences;

public class ConnectionsModel {
    private static final int ADDED = 0;
    private static final int REMOVED = 1;
    private static final int CHANGED = 2;
    private Connection recentConnection = null;
    private HashMap<ConnectionURL, Connection> connectionsByUrl = new HashMap();
    private List<IConnectionsModelListener> listeners = new ArrayList<IConnectionsModelListener>();

    protected ConnectionsModel() {
        this.load();
    }

    public void addListener(IConnectionsModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IConnectionsModelListener listener) {
        this.listeners.remove(listener);
    }

    public void clear() {
        Connection[] connections;
        Connection[] connectionArray = connections = this.connectionsByUrl.values().toArray(new Connection[this.connectionsByUrl.size()]);
        int n = connections.length;
        int n2 = 0;
        while (n2 < n) {
            Connection connection = connectionArray[n2];
            this.removeConnection(connection);
            ++n2;
        }
    }

    public boolean addConnection(Connection connection) {
        try {
            ConnectionURL connectionUrl = ConnectionURL.forConnection(connection);
            return this.addConnection(connectionUrl, connection);
        }
        catch (UnsupportedEncodingException e) {
            throw new OpenShiftCoreException(e, "Could not add connection {0}/{1}", connection.getUsername(), connection.getHost());
        }
        catch (MalformedURLException e) {
            throw new OpenShiftCoreException(e, "Could not add connection {0}/{1}", connection.getUsername(), connection.getHost());
        }
    }

    protected boolean addConnection(ConnectionURL connectionUrl, Connection connection) {
        if (this.connectionsByUrl.containsKey(connectionUrl)) {
            return false;
        }
        this.connectionsByUrl.put(connectionUrl, connection);
        this.recentConnection = connection;
        this.fireModelChange(connection, 0);
        return true;
    }

    protected boolean addConnection(ConnectionURL connectionUrl) {
        ICredentialsPrompter credentialsPrompter = OpenshiftCoreUIIntegration.getDefault().getCredentialPrompter();
        IHttpClient.ISSLCertificateCallback sslAuthorization = OpenshiftCoreUIIntegration.getDefault().getSSLCertificateCallback();
        Connection connection = new Connection(connectionUrl.getUsername(), connectionUrl.getScheme(), connectionUrl.getHost(), credentialsPrompter, sslAuthorization);
        return this.addConnection(connectionUrl, connection);
    }

    public boolean hasConnection(Connection connection) {
        try {
            ConnectionURL connectionUrl = ConnectionURL.forConnection(connection);
            return this.getConnectionByUrl(connectionUrl) != null;
        }
        catch (UnsupportedEncodingException e) {
            throw new OpenShiftCoreException(e, NLS.bind((String)"Could not get url for connection {0} - {1}", (Object)connection.getUsername(), (Object)connection.getHost()), new Object[0]);
        }
        catch (MalformedURLException e) {
            throw new OpenShiftCoreException(e, NLS.bind((String)"Could not get url for connection {0} - {1}", (Object)connection.getUsername(), (Object)connection.getHost()), new Object[0]);
        }
    }

    public void fireConnectionChanged(Connection connection) {
        if (connection == null) {
            return;
        }
        this.fireModelChange(connection, 2);
    }

    public void fireConnectionChanged(IUser user) {
        if (user == null) {
            return;
        }
        Connection connection = this.getConnectionByResource(user);
        this.fireConnectionChanged(connection);
    }

    public boolean removeConnection(Connection connection) {
        ConnectionURL connectionUrl;
        block5: {
            connectionUrl = ConnectionURL.forConnection(connection);
            if (this.connectionsByUrl.containsKey(connectionUrl)) break block5;
            return false;
        }
        try {
            this.connectionsByUrl.remove(connectionUrl);
            if (this.recentConnection == connection) {
                this.recentConnection = null;
            }
            this.fireModelChange(connection, 1);
            return true;
        }
        catch (UnsupportedEncodingException e) {
            throw new OpenShiftCoreException(e, NLS.bind((String)"Could not remove connection {0} - {1}", (Object)connection.getUsername(), (Object)connection.getHost()), new Object[0]);
        }
        catch (MalformedURLException e) {
            throw new OpenShiftCoreException(e, NLS.bind((String)"Could not remove connection {0} - {1}", (Object)connection.getUsername(), (Object)connection.getHost()), new Object[0]);
        }
    }

    private void fireModelChange(Connection connection, int type) {
        if (connection == null) {
            return;
        }
        for (IConnectionsModelListener l : this.listeners) {
            switch (type) {
                case 0: {
                    l.connectionAdded(connection);
                    break;
                }
                case 1: {
                    l.connectionRemoved(connection);
                    break;
                }
                case 2: {
                    l.connectionChanged(connection);
                    break;
                }
            }
        }
    }

    public Connection getRecentConnection() {
        return this.recentConnection;
    }

    public Connection getConnectionByResource(IApplication application) {
        if (application == null) {
            return null;
        }
        return this.getConnectionByResource(application.getDomain().getUser());
    }

    public Connection getConnectionByResource(IUser user) throws OpenShiftCoreException {
        if (user == null) {
            return null;
        }
        try {
            ConnectionURL connectionUrl = ConnectionURL.forUsernameAndServer(user.getRhlogin(), user.getServer());
            Connection c = this.connectionsByUrl.get(connectionUrl);
            String defHost = ConnectionUtils.getDefaultHostUrl();
            if (c == null && defHost.equals(user.getServer())) {
                connectionUrl = ConnectionURL.forUsername(user.getRhlogin());
                c = this.connectionsByUrl.get(connectionUrl);
            }
            return c;
        }
        catch (UnsupportedEncodingException e) {
            throw new OpenShiftCoreException(e, NLS.bind((String)"Could not get connection for user resource {0} - {1}", (Object)user.getRhlogin(), (Object)user.getServer()), new Object[0]);
        }
        catch (MalformedURLException e) {
            throw new OpenShiftCoreException(e, NLS.bind((String)"Could not get connection for user resource {0} - {1}", (Object)user.getRhlogin(), (Object)user.getServer()), new Object[0]);
        }
    }

    public Connection getConnectionByUrl(ConnectionURL connectionUrl) {
        if (connectionUrl == null) {
            return null;
        }
        return this.connectionsByUrl.get(connectionUrl);
    }

    public Connection getConnectionByUsername(String username) {
        try {
            return this.getConnectionByUrl(ConnectionURL.forUsername(username));
        }
        catch (UnsupportedEncodingException e) {
            throw new OpenShiftCoreException(NLS.bind((String)"Could not get url for connection {0}", (Object)username), e);
        }
        catch (MalformedURLException e) {
            throw new OpenShiftCoreException(NLS.bind((String)"Could not get url for connection {0}", (Object)username), e);
        }
    }

    public Connection[] getConnections() {
        Collection<Connection> c = this.connectionsByUrl.values();
        Connection[] rets = c.toArray(new Connection[c.size()]);
        return rets;
    }

    protected void load() {
        this.addDefaultHostConnections(this.loadPersistedDefaultHosts());
        this.addCustomHostConnections(this.loadPersistedCustomHosts());
    }

    private void addDefaultHostConnections(String[] usernames) {
        String[] stringArray = usernames;
        int n = usernames.length;
        int n2 = 0;
        while (n2 < n) {
            String username = stringArray[n2];
            try {
                ConnectionURL connectionUrl = ConnectionURL.forUsername(username);
                this.addConnection(connectionUrl);
            }
            catch (MalformedURLException e) {
                OpenShiftCoreActivator.pluginLog().logError(NLS.bind((String)"Could not add connection for {0}.", (Object)username), (Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                OpenShiftCoreActivator.pluginLog().logError(NLS.bind((String)"Could not add connection for {0}.", (Object)username), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                OpenShiftCoreActivator.pluginLog().logError(NLS.bind((String)"Could not add connection for {0}.", (Object)username), (Throwable)e);
            }
            ++n2;
        }
    }

    protected String[] loadPersistedDefaultHosts() {
        return OpenShiftPreferences.INSTANCE.getLegacyConnections();
    }

    private void addCustomHostConnections(String[] connectionUrls) {
        String[] stringArray = connectionUrls;
        int n = connectionUrls.length;
        int n2 = 0;
        while (n2 < n) {
            String connectionUrlString = stringArray[n2];
            try {
                ConnectionURL connectionUrl = ConnectionURL.forURL(connectionUrlString);
                this.addConnection(connectionUrl);
            }
            catch (MalformedURLException e) {
                OpenShiftCoreActivator.pluginLog().logError(NLS.bind((String)"Could not add connection for {0}.", (Object)connectionUrlString), (Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                OpenShiftCoreActivator.pluginLog().logError(NLS.bind((String)"Could not add connection for {0}.", (Object)connectionUrlString), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                OpenShiftCoreActivator.pluginLog().logError(NLS.bind((String)"Could not add connection for {0}.", (Object)connectionUrlString), (Throwable)e);
            }
            ++n2;
        }
    }

    protected String[] loadPersistedCustomHosts() {
        return OpenShiftPreferences.INSTANCE.getConnections();
    }

    public int size() {
        return this.connectionsByUrl.size();
    }

    public Connection setRecent(Connection connection) {
        this.recentConnection = connection;
        return this.recentConnection;
    }

    public void save() {
        ArrayList<String> customHostConnections = new ArrayList<String>();
        ArrayList<String> defaultHostConnections = new ArrayList<String>();
        for (Map.Entry<ConnectionURL, Connection> entry : this.connectionsByUrl.entrySet()) {
            Connection connection = entry.getValue();
            connection.save();
            ConnectionURL connectionUrl = entry.getKey();
            if (connection.isDefaultHost()) {
                defaultHostConnections.add(connection.getUsername());
                continue;
            }
            customHostConnections.add(connectionUrl.toString());
        }
        this.saveCustomHostConnections(customHostConnections);
        this.saveDefaultHostConnections(defaultHostConnections);
    }

    protected void saveDefaultHostConnections(List<String> usernames) {
        OpenShiftPreferences.INSTANCE.saveLegacyConnections(usernames.toArray(new String[usernames.size()]));
    }

    protected void saveCustomHostConnections(List<String> connectionUrls) {
        OpenShiftPreferences.INSTANCE.saveConnections(connectionUrls.toArray(new String[connectionUrls.size()]));
    }
}

