/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.connection;

import com.openshift.client.configuration.OpenShiftConfiguration;
import java.io.IOException;
import org.jboss.tools.openshift.express.internal.core.OpenShiftCoreActivator;
import org.jboss.tools.openshift.express.internal.core.preferences.OpenShiftPreferences;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;
import org.jboss.tools.openshift.express.internal.core.util.UrlUtils;

public class ConnectionUtils {
    private ConnectionUtils() {
    }

    public static String getDefaultHostUrl() {
        try {
            String defaultHost = OpenShiftPreferences.INSTANCE.getDefaultHost();
            if (!StringUtils.isEmpty(defaultHost)) {
                return defaultHost;
            }
            return new OpenShiftConfiguration().getLibraServer();
        }
        catch (IOException e) {
            OpenShiftCoreActivator.pluginLog().logError("Could not load default server from OpenShift configuration.", (Throwable)e);
            return null;
        }
    }

    public static boolean isDefaultHost(String host) {
        return UrlUtils.isEmptyHost(host) || ConnectionUtils.getDefaultHostUrl().equals(UrlUtils.ensureStartsWithScheme(host, "https://"));
    }
}

