/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.connection;

import com.openshift.client.ApplicationScale;
import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.IGearProfile;
import com.openshift.client.IHttpClient;
import com.openshift.client.IOpenShiftSSHKey;
import com.openshift.client.IQuickstart;
import com.openshift.client.ISSHPublicKey;
import com.openshift.client.IUser;
import com.openshift.client.OpenShiftConnectionFactory;
import com.openshift.client.OpenShiftException;
import com.openshift.client.OpenShiftUnknonwSSHKeyTypeException;
import com.openshift.client.cartridge.ICartridge;
import com.openshift.client.cartridge.IEmbeddableCartridge;
import com.openshift.client.cartridge.IStandaloneCartridge;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.express.client.ClientSystemProperties;
import org.jboss.tools.openshift.express.core.ICredentialsPrompter;
import org.jboss.tools.openshift.express.internal.core.OpenShiftCoreActivator;
import org.jboss.tools.openshift.express.internal.core.connection.ConnectionUtils;
import org.jboss.tools.openshift.express.internal.core.preferences.OpenShiftPreferences;
import org.jboss.tools.openshift.express.internal.core.security.OpenShiftPasswordStorageKey;
import org.jboss.tools.openshift.express.internal.core.security.SecurePasswordStore;
import org.jboss.tools.openshift.express.internal.core.security.SecurePasswordStoreException;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;
import org.jboss.tools.openshift.express.internal.core.util.UrlUtils;

public class Connection {
    private static final String USER_ID = "org.jboss.tools.openshift.express.core " + OpenShiftCoreActivator.getDefault().getBundle().getVersion();
    private String username;
    private String password;
    private String host;
    private IUser user;
    private boolean isDomainLoaded;
    private boolean rememberPassword;
    private boolean didPromptForPassword;
    private boolean passwordLoaded;
    private ICredentialsPrompter passwordPrompter;
    private IHttpClient.ISSLCertificateCallback sslCallback;

    public Connection() {
        this(null, null, null, null, false, null, null);
    }

    protected Connection(String username) {
        this.username = username;
    }

    public Connection(String username, String scheme, String host, ICredentialsPrompter prompter, IHttpClient.ISSLCertificateCallback sslCallback) {
        this(username, null, scheme, host, false, null, sslCallback);
        this.passwordPrompter = prompter;
    }

    public Connection(String username, String host) {
        this(username, null, host, false, null);
    }

    public Connection(String username, String password, boolean rememberPassword, IHttpClient.ISSLCertificateCallback sslCallback) {
        this(username, password, null, rememberPassword, sslCallback);
    }

    public Connection(String username, String password, String host, boolean rememberPassword, IHttpClient.ISSLCertificateCallback sslCallback) {
        this(username, password, host, rememberPassword, null, sslCallback);
    }

    protected Connection(String username, String password, String host, boolean rememberPassword, IUser user, IHttpClient.ISSLCertificateCallback sslCallback) {
        this(username, password, UrlUtils.getScheme(host), UrlUtils.cutScheme(host), rememberPassword, user, sslCallback);
    }

    protected Connection(String username, String password, String scheme, String host, boolean rememberPassword, IUser user, IHttpClient.ISSLCertificateCallback sslCallback) {
        this.username = username;
        this.password = password;
        this.host = this.getHost(scheme, host);
        this.rememberPassword = rememberPassword;
        this.sslCallback = sslCallback;
        this.setUser(user);
    }

    private String getHost(String scheme, String host) {
        if (StringUtils.isEmpty(host)) {
            return host;
        }
        if (StringUtils.isEmpty(scheme)) {
            scheme = "https://";
        }
        return UrlUtils.ensureStartsWithScheme(host, scheme);
    }

    protected void setUser(IUser user) {
        this.user = user;
    }

    private IUser getUser() {
        return this.user;
    }

    public String getUsername() {
        return this.username;
    }

    public String setUsername(String username) {
        this.username = username;
        this.clearUser();
        return username;
    }

    public String getPassword() {
        this.loadPassword();
        return this.password;
    }

    public String setPassword(String password) {
        this.password = password;
        this.passwordLoaded = true;
        this.clearUser();
        return password;
    }

    public String getHost() {
        if (this.isDefaultHost()) {
            return ConnectionUtils.getDefaultHostUrl();
        }
        return this.host;
    }

    public String getScheme() {
        if (this.isDefaultHost()) {
            return UrlUtils.getScheme(ConnectionUtils.getDefaultHostUrl());
        }
        return UrlUtils.getScheme(this.host);
    }

    public String setHost(String host) {
        this.host = UrlUtils.ensureStartsWithScheme(host, "https://");
        this.clearUser();
        return host;
    }

    public boolean isDefaultHost() {
        return this.isDefaultHost(this.host);
    }

    private boolean isDefaultHost(String host) {
        return host == null || UrlUtils.cutScheme(host).isEmpty();
    }

    public boolean isRememberPassword() {
        return this.rememberPassword;
    }

    public final boolean setRememberPassword(boolean rememberPassword) {
        this.rememberPassword = rememberPassword;
        return this.rememberPassword;
    }

    public boolean canPromptForPassword() {
        return !this.didPromptForPassword;
    }

    public boolean connect() throws OpenShiftException {
        if (this.isConnected()) {
            this.save();
            return true;
        }
        if (this.createUser()) {
            this.updateUsername(this.user);
            this.save();
            return true;
        }
        return false;
    }

    protected boolean createUser() {
        this.loadPassword();
        if (this.password == null) {
            return this.promptForCredentials();
        }
        this.setClientTimeout();
        IUser user = new OpenShiftConnectionFactory().getConnection(USER_ID, this.username, this.password, this.getHost(), this.sslCallback).getUser();
        this.setUser(user);
        return true;
    }

    private void setClientTimeout() {
        int timeout = OpenShiftPreferences.INSTANCE.getClientReadTimeout(ClientSystemProperties.getReadTimeoutSeconds());
        ClientSystemProperties.setReadTimeoutSeconds((int)timeout);
    }

    private void loadPassword() {
        if (StringUtils.isEmpty(this.password) && !this.passwordLoaded) {
            this.password = this.getPassword(this.getSecureStore(this.getHost(), this.getUsername()));
            this.passwordLoaded = true;
            this.rememberPassword = this.password != null;
        }
    }

    private boolean hasUser() {
        return this.user != null;
    }

    protected void clearUser() {
        this.user = null;
    }

    public void update(Connection connection) {
        if (connection == null) {
            return;
        }
        this.setUsername(connection.getUsername());
        this.setPassword(connection.getPassword());
        this.setRememberPassword(connection.isRememberPassword());
        if (connection.isDefaultHost()) {
            this.setHost(null);
        } else {
            this.setHost(connection.getHost());
        }
        this.setUser(connection.getUser());
    }

    private String updateUsername(IUser user) {
        if (!user.getRhlogin().equals(this.username)) {
            OpenShiftCoreActivator.getDefault().getLog().log((IStatus)new Status(2, "org.jboss.tools.openshift.express.core", NLS.bind((String)"User {0} was logged in as {1}", (Object)this.username, (Object)user.getRhlogin())));
        }
        this.username = user.getRhlogin();
        return this.username;
    }

    private boolean promptForCredentials() {
        if (this.passwordPrompter == null) {
            return false;
        }
        try {
            this.passwordPrompter.promptAndAuthenticate(this);
            this.didPromptForPassword = true;
        }
        catch (Exception e) {
            OpenShiftCoreActivator.pluginLog().logError("Failed to retrieve User's password", (Throwable)e);
        }
        return this.hasUser();
    }

    public IApplication createApplication(String applicationName, IStandaloneCartridge standaloneCartridge, ApplicationScale scale, IGearProfile gearProfile, IDomain domain) throws OpenShiftException {
        if (this.connect()) {
            return domain.createApplication(applicationName, standaloneCartridge, scale, gearProfile);
        }
        return null;
    }

    public IDomain createDomain(String id) throws OpenShiftException {
        if (this.connect()) {
            return this.user.createDomain(id);
        }
        return null;
    }

    public List<IStandaloneCartridge> getStandaloneCartridges() throws OpenShiftException {
        if (this.connect()) {
            return this.user.getConnection().getStandaloneCartridges();
        }
        return null;
    }

    public List<IEmbeddableCartridge> getEmbeddableCartridges() throws OpenShiftException {
        if (this.connect()) {
            return this.user.getConnection().getEmbeddableCartridges();
        }
        return null;
    }

    public List<ICartridge> getCartridges() throws OpenShiftException {
        if (this.connect()) {
            return this.user.getConnection().getCartridges();
        }
        return null;
    }

    public List<IQuickstart> getQuickstarts() throws OpenShiftException {
        if (this.connect()) {
            return this.user.getConnection().getQuickstarts();
        }
        return null;
    }

    public void load() {
        this.getDomains();
    }

    public IApplication getApplication(String name, IDomain domain) throws OpenShiftException {
        if (domain == null) {
            return null;
        }
        return domain.getApplicationByName(name);
    }

    public boolean hasApplication(String name, IDomain domain) throws OpenShiftException {
        return this.getApplication(name, domain) != null;
    }

    public IDomain getDefaultDomain() throws OpenShiftException {
        if (this.connect()) {
            return this.user.getDefaultDomain();
        }
        return null;
    }

    public IDomain getDomain(String id) throws OpenShiftException {
        if (StringUtils.isEmpty(id)) {
            return null;
        }
        this.getDomains();
        return this.user.getDomain(id);
    }

    public IDomain getFirstDomain() throws OpenShiftException {
        if (!this.connect()) {
            return null;
        }
        List<IDomain> domains = this.getDomains();
        if (domains == null || domains.isEmpty()) {
            return null;
        }
        return domains.get(0);
    }

    public List<IDomain> getDomains() throws OpenShiftException {
        if (!this.connect()) {
            return Collections.emptyList();
        }
        List domains = this.user.getDomains();
        this.isDomainLoaded = true;
        return domains;
    }

    public void destroy(IDomain domain, boolean force) {
        if (this.connect()) {
            domain.destroy(force);
        }
    }

    public boolean isLoaded() throws OpenShiftException {
        return this.isDomainLoaded;
    }

    public boolean hasApplicationOfType(IStandaloneCartridge type) throws OpenShiftException {
        if (this.hasDomain()) {
            return this.user.getDefaultDomain().hasApplicationByCartridge(type);
        }
        return false;
    }

    public boolean hasDomain() throws OpenShiftException {
        if (this.connect()) {
            return this.user.hasDomain();
        }
        return false;
    }

    public boolean hasSSHKeys() throws OpenShiftException {
        if (this.connect()) {
            return !this.user.getSSHKeys().isEmpty();
        }
        return false;
    }

    public void refresh() throws OpenShiftException {
        this.isDomainLoaded = false;
        if (this.connect()) {
            this.user.refresh();
        }
    }

    public boolean isConnected() {
        return this.hasUser();
    }

    public List<IOpenShiftSSHKey> getSSHKeys() throws OpenShiftException {
        if (this.connect()) {
            return this.user.getSSHKeys();
        }
        return Collections.emptyList();
    }

    public IOpenShiftSSHKey getSSHKeyByPublicKey(String publicKey) throws OpenShiftUnknonwSSHKeyTypeException, OpenShiftException {
        if (this.connect()) {
            return this.user.getSSHKeyByPublicKey(publicKey);
        }
        return null;
    }

    public IOpenShiftSSHKey putSSHKey(String name, ISSHPublicKey key) throws OpenShiftException {
        if (this.connect()) {
            return this.user.putSSHKey(name, key);
        }
        return null;
    }

    public boolean hasSSHKeyName(String name) throws OpenShiftException {
        if (this.connect()) {
            return this.user.hasSSHKeyName(name);
        }
        return false;
    }

    public boolean hasSSHPublicKey(String publicKey) {
        if (this.connect()) {
            return this.user.hasSSHPublicKey(publicKey);
        }
        return false;
    }

    public void save() {
        String username = this.getUsername();
        if (!StringUtils.isEmpty(username)) {
            OpenShiftPreferences.INSTANCE.saveLastUsername(username);
            this.saveOrClearPassword(username, this.getHost(), this.getPassword());
        }
    }

    private void saveOrClearPassword(String username, String host, String password) {
        SecurePasswordStore store = this.getSecureStore(host, username);
        if (store != null && !StringUtils.isEmpty(username)) {
            try {
                if (this.isRememberPassword() && !StringUtils.isEmpty(password)) {
                    store.setPassword(password);
                } else {
                    store.remove();
                }
            }
            catch (SecurePasswordStoreException securePasswordStoreException) {}
        }
    }

    private String getPassword(SecurePasswordStore store) {
        String password = null;
        if (store != null && !StringUtils.isEmpty(this.getUsername())) {
            try {
                password = store.getPassword();
            }
            catch (SecurePasswordStoreException e) {
                OpenShiftCoreActivator.pluginLog().logError(e.getMessage(), (Throwable)e);
            }
        }
        return password;
    }

    private SecurePasswordStore getSecureStore(String platform, String username) {
        if (platform == null) {
            return null;
        }
        OpenShiftPasswordStorageKey key = new OpenShiftPasswordStorageKey(platform, username);
        SecurePasswordStore store = new SecurePasswordStore(key);
        return store;
    }

    public String getId() {
        StringBuilder builder = new StringBuilder(this.username);
        builder.append(" at ").append(this.getHost());
        if (this.isDefaultHost()) {
            builder.append(" (default)");
        }
        return builder.toString();
    }

    public String toString() {
        return "Connection [username=" + this.username + ", password=" + this.password + ", host=" + this.host + ", user=" + this.user + ", isDomainLoaded=" + this.isDomainLoaded + ", rememberPassword=" + this.rememberPassword + ", didPromptForPassword=" + this.didPromptForPassword + ", passwordLoaded=" + this.passwordLoaded + "]";
    }
}

