/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core;

import com.openshift.client.OpenShiftException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.openshift.express.internal.core.OpenShiftCoreActivator;
import org.jboss.tools.openshift.express.internal.core.OpenShiftExpressCoreMessages;

public abstract class AbstractThreadedOperation {
    private static final int THREAD_SLEEP = 1000;
    private ExecutorService executor = Executors.newFixedThreadPool(1);

    protected AbstractThreadedOperation() {
    }

    protected <E> E submit(Callable<E> callable, IProgressMonitor monitor) throws OpenShiftException {
        try {
            Future<E> future = this.executor.submit(callable);
            while (!future.isDone()) {
                if (monitor.isCanceled()) {
                    throw new OpenShiftException(OpenShiftExpressCoreMessages.OPERATION_CANCELLED, new Object[0]);
                }
                Thread.sleep(1000L);
            }
            E e = future.get();
            return e;
        }
        catch (Exception e) {
            Throwable cause = e.getCause() != null ? e.getCause() : e;
            OpenShiftCoreActivator.pluginLog().logError("Failed to create application", cause);
            throw new OpenShiftException("Failed to create application: {0}", new Object[]{cause.getMessage()});
        }
        finally {
            this.executor.shutdown();
        }
    }
}

