/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.chart.model.attribute.MenuStylesKeyType;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class MenuStylesDialog
extends TrayDialog
implements Listener {
    private EMap<String, String> fPropertiesMap;
    private Combo fComboStyle;
    private Table fTable;
    private Button fBtnAdd;
    private Button fBtnRemove;
    private TableViewer fTableViewer;
    private ArrayList<String[]> fCurrentAttrList;
    private MenuStylesKeyType fCurrentStyleKeyType;
    private static final String[] COLUMNS = new String[]{"Properties", "Value"};

    public MenuStylesDialog(Shell shell, EMap<String, String> propertiesMap) {
        super(shell);
        this.setShellStyle(2160);
        this.fPropertiesMap = propertiesMap;
    }

    protected Control createDialogArea(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.Hyperlink_Options_ID");
        this.getShell().setText(Messages.getString("MenuStylesDialog.title"));
        Composite c = (Composite)super.createDialogArea(parent);
        this.placeComponents(c);
        this.initTableContents();
        this.populateUIValues();
        this.initListeners(c);
        this.updateButtonStatus();
        return c;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    private void placeComponents(Composite c) {
        GridLayout gl = (GridLayout)c.getLayout();
        gl.numColumns = 4;
        Label labelStyle = new Label(c, 0);
        labelStyle.setText(Messages.getString("MenuStylesDialog.Label.Style"));
        this.fComboStyle = new Combo(c, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fComboStyle.setLayoutData((Object)gd);
        new Label(c, 0);
        this.fTable = new Table(c, 68096);
        this.fTable.setLinesVisible(true);
        this.fTable.setHeaderVisible(true);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.verticalSpan = 16;
        this.fTable.setLayoutData((Object)gd);
        this.fTableViewer = new TableViewer(this.fTable);
        this.fTableViewer.setUseHashlookup(true);
        this.fBtnAdd = new Button(c, 0);
        this.fBtnAdd.setText(Messages.getString("MenuStylesDialog.Btn.Add"));
        this.fBtnRemove = new Button(c, 0);
        this.fBtnRemove.setText(Messages.getString("MenuStylesDialog.Btn.Remove"));
    }

    private void initTableContents() {
        TableColumn column = new TableColumn(this.fTable, 16384);
        column.setText(this.getI18NMessage("Column." + COLUMNS[0]));
        column.setWidth(80);
        column = new TableColumn(this.fTable, 16384);
        column.setText(this.getI18NMessage("Column." + COLUMNS[1]));
        column.setWidth(120);
        this.fTableViewer.setColumnProperties(COLUMNS);
        this.fTableViewer.setContentProvider((IContentProvider)new PropertiesContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new PropertiesLabelProvider());
        this.fTableViewer.setCellEditors(this.getCellEditors(this.fTable));
        this.fTableViewer.setCellModifier((ICellModifier)new PropertyCellModifier(this.fTableViewer));
    }

    private void populateUIValues() {
        ArrayList<String> displayKeys = new ArrayList<String>(MenuStylesKeyType.VALUES.size());
        for (MenuStylesKeyType key : MenuStylesKeyType.VALUES) {
            displayKeys.add(this.getI18NMessage("Style." + key.getName()));
        }
        this.fComboStyle.setItems(displayKeys.toArray(new String[0]));
        this.fComboStyle.select(0);
        this.switchProperties(MenuStylesKeyType.MENU);
    }

    private void updateButtonStatus() {
        int index = this.fTable.getSelectionIndex();
        this.fBtnRemove.setEnabled(index >= 0);
    }

    private void initListeners(Composite c) {
        c.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MenuStylesDialog.this.updateProperties(MenuStylesKeyType.get((int)MenuStylesDialog.this.fComboStyle.getSelectionIndex()));
            }
        });
        this.fComboStyle.addListener(13, (Listener)this);
        this.fBtnAdd.addListener(13, (Listener)this);
        this.fBtnRemove.addListener(13, (Listener)this);
        this.fTable.addListener(11, (Listener)this);
        this.fTable.addListener(13, (Listener)this);
        this.fTable.addListener(1, (Listener)this);
    }

    private void updateProperties(MenuStylesKeyType menuStylesKeyType) {
        this.fPropertiesMap.put((Object)menuStylesKeyType.getName(), (Object)this.serializeProperties(this.fCurrentAttrList));
    }

    private String getI18NMessage(String key) {
        return Messages.getString("MenuStyleDialog." + key);
    }

    protected void setTableVeiwerInput(Object input) {
        this.fTableViewer.setInput(input);
        this.fTableViewer.refresh();
        this.updateButtonStatus();
    }

    private List<String[]> deserializeProperties(String properties) {
        String[] attributes = properties.split(";");
        this.fCurrentAttrList = new ArrayList();
        String[] stringArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            int index = v.indexOf(58);
            if (index >= 0) {
                String[] element = new String[]{v.substring(0, index), v.substring(index + 1)};
                this.fCurrentAttrList.add(element);
            }
            ++n2;
        }
        return this.fCurrentAttrList;
    }

    private String serializeProperties(List<String[]> attrMap) {
        if (attrMap == null || attrMap.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String[] v : attrMap) {
            if (v[0] == null || "".equals(v[0])) continue;
            if (i != 0) {
                sb.append(";");
            }
            sb.append(v[0]);
            sb.append(":");
            sb.append(v[1]);
            ++i;
        }
        return sb.toString();
    }

    private CellEditor[] getCellEditors(Table table) {
        CellEditor[] editors = new CellEditor[COLUMNS.length];
        editors[0] = new TextCellEditor((Composite)table){

            protected void keyReleaseOccured(KeyEvent keyEvent) {
                super.keyReleaseOccured(keyEvent);
                if (keyEvent.character == '\r') {
                    MenuStylesDialog.this.fTableViewer.editElement(MenuStylesDialog.this.fTableViewer.getElementAt(MenuStylesDialog.this.fTable.getSelectionIndex()), 1);
                }
            }
        };
        editors[1] = new TextCellEditor((Composite)table);
        return editors;
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source == this.fComboStyle) {
            this.updateProperties(this.fCurrentStyleKeyType);
            this.switchProperties(MenuStylesKeyType.get((int)this.fComboStyle.getSelectionIndex()));
        } else if (source == this.fBtnAdd) {
            this.doAdd();
        } else if (source == this.fBtnRemove) {
            this.doRemove();
        } else if (source == this.fTable) {
            if (event.type == 11) {
                int totalWidth = 0;
                int valuewidth = 0;
                int i = 0;
                TableColumn[] tableColumnArray = this.fTable.getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn tc = tableColumnArray[n2];
                    totalWidth += tc.getWidth();
                    if (i == 1) {
                        valuewidth = tc.getWidth();
                    }
                    ++i;
                    ++n2;
                }
                this.fTable.getColumn(1).setWidth(valuewidth += this.fTable.getClientArea().width - totalWidth);
            } else if (event.type == 13) {
                this.updateButtonStatus();
            } else if (event.type == 1 && event.character == ' ') {
                this.fTableViewer.editElement(this.fTableViewer.getElementAt(this.fTable.getSelectionIndex()), 0);
            }
        }
    }

    private void doAdd() {
        final String[] ele = new String[]{"", ""};
        this.fCurrentAttrList.add(ele);
        this.fTableViewer.refresh();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MenuStylesDialog.this.fTableViewer.editElement((Object)ele, 0);
            }
        });
    }

    private void doRemove() {
        int index = this.fTable.getSelectionIndex();
        if (index < 0) {
            return;
        }
        this.fCurrentAttrList.remove(index);
        this.fTableViewer.refresh();
    }

    private void switchProperties(MenuStylesKeyType menuStylesKeyType) {
        this.fCurrentStyleKeyType = menuStylesKeyType;
        this.setTableVeiwerInput(this.deserializeProperties((String)this.fPropertiesMap.get((Object)menuStylesKeyType.getName())));
    }

    static class PropertiesContentProvider
    implements IStructuredContentProvider {
        PropertiesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    static class PropertiesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        PropertiesLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof String[] && columnIndex < ((String[])element).length) {
                return ((String[])element)[columnIndex];
            }
            return null;
        }
    }

    static class PropertyCellModifier
    implements ICellModifier {
        private TableViewer fTableViewer;

        public PropertyCellModifier(TableViewer tableViewer) {
            this.fTableViewer = tableViewer;
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            String[] ele = (String[])element;
            int index = Arrays.asList(COLUMNS).indexOf(property);
            return ele[index];
        }

        public void modify(Object element, String property, Object value) {
            int index = Arrays.asList(COLUMNS).indexOf(property);
            String[] data = (String[])((TableItem)element).getData();
            data[index] = (String)value;
            this.fTableViewer.update(element, null);
            this.fTableViewer.refresh();
        }
    }
}

