/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.birt.oda.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.osgi.util.NLS;
import org.hibernate.Session;
import org.jboss.tools.birt.oda.IOdaFactory;
import org.jboss.tools.birt.oda.Messages;
import org.jboss.tools.birt.oda.impl.HibernateConnection;
import org.jboss.tools.birt.oda.impl.HibernateOdaQuery;
import org.jboss.tools.birt.oda.impl.HibernateResult;

public class HibernateResultSet
implements IResultSet {
    private int _maxRows;
    private HibernateOdaQuery query;
    private int rowNumber = -1;
    private boolean wasNull;
    private HibernateResult hibernateResult;
    private static DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");

    public HibernateResultSet(HibernateOdaQuery query) throws OdaException {
        this.query = query;
        HibernateConnection connection = query.getConnection();
        IOdaFactory odaSessionFactory = connection.getOdaSessionFactory();
        Session session = connection.getSession();
        this.hibernateResult = odaSessionFactory.executeQuery(query, session);
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        return this.query.getMetaData();
    }

    public void setMaxRows(int max) throws OdaException {
        this._maxRows = max;
    }

    protected int getMaxRows() {
        return this._maxRows;
    }

    public boolean next() throws OdaException {
        if (this.getIterator().hasNext()) {
            this.hibernateResult.next();
            ++this.rowNumber;
            return true;
        }
        return false;
    }

    private Iterator getIterator() {
        return this.hibernateResult.getIterator();
    }

    public void close() throws OdaException {
        this.hibernateResult.close();
    }

    private List getResult() {
        return this.hibernateResult.getResult();
    }

    public int getRow() throws OdaException {
        this.testFetchStarted();
        return this.rowNumber + 1;
    }

    private Object getResult(int rstcol) throws OdaException {
        return this.hibernateResult.getResult(rstcol);
    }

    public String getString(int index) throws OdaException {
        this.testFetchStarted();
        Object rObj = this.getResult(index);
        String result = rObj == null ? null : rObj.toString();
        this.wasNull = result == null;
        return result;
    }

    public String getString(String columnName) throws OdaException {
        return this.getString(this.findColumn(columnName));
    }

    public int getInt(int index) throws OdaException {
        int result;
        this.testFetchStarted();
        Object rObj = this.getResult(index);
        if (rObj == null) {
            result = 0;
            this.wasNull = true;
        } else {
            this.wasNull = false;
            if (rObj instanceof Integer) {
                result = (Integer)rObj;
            } else if (rObj instanceof Long) {
                result = ((Long)rObj).intValue();
            } else if (rObj instanceof Short) {
                result = ((Short)rObj).intValue();
            } else {
                throw new RuntimeException(NLS.bind((String)Messages.HibernateResultSet_The_data_type_is_not_valid, rObj.getClass()));
            }
        }
        return result;
    }

    public int getInt(String columnName) throws OdaException {
        return this.getInt(this.findColumn(columnName));
    }

    public double getDouble(int index) throws OdaException {
        double result;
        this.testFetchStarted();
        Object rObj = this.getResult(index);
        if (rObj == null) {
            result = 0.0;
            this.wasNull = true;
        } else {
            this.wasNull = false;
            result = (Double)rObj;
        }
        return result;
    }

    public double getDouble(String columnName) throws OdaException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int index) throws OdaException {
        BigDecimal result;
        this.testFetchStarted();
        Object rObj = this.getResult(index);
        if (rObj == null) {
            result = new BigDecimal(0);
            this.wasNull = true;
        } else {
            this.wasNull = false;
            result = (BigDecimal)rObj;
        }
        return result;
    }

    public BigDecimal getBigDecimal(String columnName) throws OdaException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public Date getDate(int index) throws OdaException {
        Date result = null;
        this.testFetchStarted();
        Object rObj = this.getResult(index);
        if (rObj == null) {
            this.wasNull = true;
        } else {
            this.wasNull = false;
            if (rObj instanceof String) {
                try {
                    result = new Date(dateFormat.parse((String)rObj).getTime());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            } else {
                result = (Date)rObj;
            }
        }
        return result;
    }

    public Date getDate(String columnName) throws OdaException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(int index) throws OdaException {
        Time result = null;
        this.testFetchStarted();
        Object rObj = this.getResult(index);
        if (rObj == null) {
            this.wasNull = true;
        } else {
            this.wasNull = false;
            result = (Time)rObj;
        }
        return result;
    }

    public Time getTime(String columnName) throws OdaException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(int index) throws OdaException {
        Timestamp result = null;
        this.testFetchStarted();
        Object rObj = this.getResult(index);
        if (rObj == null) {
            this.wasNull = true;
        } else {
            this.wasNull = false;
            result = (Timestamp)rObj;
        }
        return result;
    }

    public Timestamp getTimestamp(String columnName) throws OdaException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public IBlob getBlob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IBlob getBlob(String columnName) throws OdaException {
        return this.getBlob(this.findColumn(columnName));
    }

    public IClob getClob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IClob getClob(String columnName) throws OdaException {
        return this.getClob(this.findColumn(columnName));
    }

    public boolean getBoolean(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(String columnName) throws OdaException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public boolean wasNull() throws OdaException {
        return this.wasNull;
    }

    public int findColumn(String columnName) throws OdaException {
        int columnId = 1;
        if (columnName == null || columnName.length() == 0) {
            return columnId;
        }
        String lastChar = columnName.substring(columnName.length() - 1, 1);
        try {
            columnId = Integer.parseInt(lastChar);
        }
        catch (NumberFormatException numberFormatException) {}
        return columnId;
    }

    private void testFetchStarted() throws OdaException {
        if (this.rowNumber < 0) {
            throw new OdaException(Messages.HibernateResultSet_Cursor_has_not_been_initialized);
        }
    }

    public Object getObject(int index) throws OdaException {
        return this.getResult(index);
    }

    public Object getObject(String columnName) throws OdaException {
        return this.getObject(this.findColumn(columnName));
    }
}

