/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.views;

import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.zest.core.viewers.EntityConnectionData;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.viewers.IConnectionStyleProvider;
import org.eclipse.zest.core.viewers.IEntityStyleProvider;
import org.fusesource.fon.util.messages.INodeStatistics;
import org.fusesource.fon.util.messages.NodeStatisticsContainer;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.editor.utils.DiagramUtils;
import org.fusesource.ide.camel.editor.views.DiagramView;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.Flow;
import org.fusesource.ide.commons.tree.HasName;
import org.fusesource.ide.commons.util.Strings;
import org.fusesource.ide.graph.GraphLabelProviderSupport;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class DiagramGraphLabelProvider
extends GraphLabelProviderSupport
implements ILabelProvider,
IEntityStyleProvider,
IConnectionStyleProvider,
ISelectionChangedListener {
    private final DiagramView view;
    private Set<AbstractNode> selectedConnections;
    private NumberFormat numberFormat = NumberFormat.getInstance();
    private boolean useNodeIdForLabel;

    public DiagramGraphLabelProvider(DiagramView view) {
        super(view.getViewer());
        this.view = view;
        this.numberFormat.setMaximumFractionDigits(1);
        this.numberFormat.setMinimumFractionDigits(0);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection;
        GraphViewer viewer = this.getViewer();
        if (this.selectedConnections != null) {
            for (AbstractNode node : this.selectedConnections) {
                viewer.unReveal((Object)node);
            }
            this.selectedConnections = null;
        }
        if (!(selection = event.getSelection()).isEmpty() && selection instanceof IStructuredSelection) {
            this.selectedConnections = new HashSet<AbstractNode>();
            for (Object o : ((IStructuredSelection)selection).toList()) {
                if (!(o instanceof AbstractNode)) continue;
                AbstractNode node = (AbstractNode)o;
                viewer.reveal((Object)node);
                this.selectedConnections.add(node);
            }
        }
        Object[] connections = viewer.getConnectionElements();
        int i = 0;
        while (i < connections.length) {
            viewer.update(connections[i], null);
            ++i;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getImage(Object element) {
        if (this.isShowIcon()) {
            if (this.isRouteNode(element)) {
                AbstractNode node = (AbstractNode)element;
                return node.getSmallImage();
            }
            if (element instanceof ImageProvider) {
                ImageProvider node = (ImageProvider)element;
                return node.getImage();
            }
        }
        return null;
    }

    protected boolean isRouteNode(Object element) {
        return element instanceof AbstractNode && !(element instanceof Flow);
    }

    public String getText(Object element) {
        block7: {
            try {
                if (this.isRouteNode(element)) {
                    AbstractNode node = (AbstractNode)element;
                    String label = DiagramUtils.filterFigureLabel(node.getDisplayText(this.useNodeIdForLabel));
                    return label;
                }
                if (element instanceof HasName) {
                    HasName h = (HasName)element;
                    return h.getName();
                }
                if (!(element instanceof Flow)) break block7;
                Flow flow = (Flow)element;
                INodeStatistics stats = this.getStatsFor(flow);
                if (stats != null) {
                    return this.statsLabel(stats);
                }
                return null;
            }
            catch (Exception e) {
                Activator.getLogger().warning("Caught exception trying to get label: " + e, (Throwable)e);
                return null;
            }
        }
        if (element instanceof Node) {
            return Strings.getOrElse((Object)element, null);
        }
        return null;
    }

    public IFigure getTooltip(Object entity) {
        if (this.isRouteNode(entity)) {
            AbstractNode node = (AbstractNode)entity;
            String label = node.getDisplayToolTip();
            String id = node.getId();
            if (id != null) {
                label = "[" + id + "] " + label;
            }
            return new Label(label);
        }
        if (entity instanceof Flow) {
            Flow flow = (Flow)entity;
            INodeStatistics stats = this.getStatsFor(flow);
            if (stats != null) {
                return this.statsToolTip(stats);
            }
            return null;
        }
        boolean cfr_ignored_0 = entity instanceof Node;
        return null;
    }

    protected INodeStatistics getStatsFor(Flow flow) {
        NodeStatisticsContainer traceExchangeList = this.view.getNodeStatisticsContainer();
        INodeStatistics stats = null;
        AbstractNode node = flow.getTarget();
        if (traceExchangeList != null && node != null) {
            stats = traceExchangeList.getNodeStats(node.getId());
        }
        return stats;
    }

    protected String statsLabel(INodeStatistics stats) {
        long counter = stats.getCounter();
        if (counter > 0L) {
            return "Total: " + counter;
        }
        return "";
    }

    protected IFigure statsToolTip(INodeStatistics stats) {
        long counter = stats.getCounter();
        if (counter > 0L) {
            return new Label("Exchanges total: " + counter + " / mean time: " + this.numberFormat.format(stats.getMeanElapsedTime()) + " / max time: " + this.numberFormat.format(stats.getMaxElapsedTime()) + " / min time: " + this.numberFormat.format(stats.getMinElapsedTime()));
        }
        return null;
    }

    public boolean fisheyeNode(Object entity) {
        return false;
    }

    public int getBorderWidth(Object entity) {
        return 1;
    }

    public Color getBorderColor(Object entity) {
        return Display.getDefault().getSystemColor(16);
    }

    public Color getBorderHighlightColor(Object entity) {
        return Display.getDefault().getSystemColor(16);
    }

    public Color getForegroundColour(Object entity) {
        return Display.getDefault().getSystemColor(2);
    }

    public Color getBackgroundColour(Object entity) {
        this.isRouteNode(entity);
        return null;
    }

    public Color getNodeHighlightColor(Object entity) {
        this.isRouteNode(entity);
        return null;
    }

    public int getLineWidth(Object rel) {
        int lineWidth = 1;
        if (this.isRouteNode(rel) ? this.selectedConnections != null && this.selectedConnections.contains(rel) : rel instanceof EntityConnectionData && this.selectedConnections != null && this.selectedConnections.contains(rel)) {
            return lineWidth;
        }
        return 0;
    }

    public Color getHighlightColor(Object rel) {
        return null;
    }

    public Color getColor(Object rel) {
        return Display.getDefault().getSystemColor(2);
    }

    public int getConnectionStyle(Object rel) {
        this.isRouteNode(rel);
        return 18;
    }
}

