/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.validation;

import java.util.HashMap;
import java.util.Map;
import org.fusesource.ide.camel.editor.validation.BasicNodeValidator;
import org.fusesource.ide.camel.editor.validation.ValidationResult;
import org.fusesource.ide.camel.model.AbstractNode;

public final class ValidationFactory {
    private static Map<Class<? extends AbstractNode>, BasicNodeValidator> registeredValidators = new HashMap<Class<? extends AbstractNode>, BasicNodeValidator>();
    private static ValidationFactory instance;

    static {
        registeredValidators.put(AbstractNode.class, new BasicNodeValidator());
    }

    private ValidationFactory() {
    }

    public static synchronized ValidationFactory getInstance() {
        if (instance == null) {
            instance = new ValidationFactory();
        }
        return instance;
    }

    public ValidationResult validate(AbstractNode node) {
        ValidationResult result = null;
        BasicNodeValidator validator = registeredValidators.get(node.getClass());
        if (validator == null) {
            validator = registeredValidators.get(AbstractNode.class);
        }
        result = validator.validate(node);
        return result;
    }
}

