/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.validation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.editor.editor.RiderDesignEditor;
import org.fusesource.ide.camel.editor.utils.NodeUtils;
import org.fusesource.ide.camel.editor.validation.ValidationResult;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.commons.util.Strings;

public class BasicNodeValidator {
    protected ValidationResult validate(AbstractNode node) {
        ValidationResult result = new ValidationResult();
        IPropertyDescriptor[] iPropertyDescriptorArray = node.getPropertyDescriptors();
        int n = iPropertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            RiderDesignEditor editor;
            Object val;
            IPropertyDescriptor pd = iPropertyDescriptorArray[n2];
            String property = NodeUtils.getPropertyName(pd.getId());
            if (NodeUtils.isMandatory(node, property) && ((val = node.getPropertyValue(pd.getId())) == null || val.toString().trim().length() < 1)) {
                result.addError("There are mandatory fields which are not filled. Please check the properties view for more details.");
            }
            if (property.equalsIgnoreCase("id") && (editor = Activator.getDiagramEditor()) != null && !this.checkAllUniqueIDs(node, editor.getModel().getChildren(), new ArrayList<String>())) {
                result.addError("The id property is not unique!");
            }
            ++n2;
        }
        return result;
    }

    protected boolean checkAllUniqueIDs(AbstractNode nodeUnderValidation, List<AbstractNode> nodes, ArrayList<String> processedNodeIDs) {
        boolean noDoubledIDs = true;
        for (AbstractNode node : nodes) {
            if (node.getChildren() != null && !(noDoubledIDs = this.checkAllUniqueIDs(nodeUnderValidation, node.getChildren(), processedNodeIDs))) {
                return false;
            }
            if (!noDoubledIDs || Strings.isBlank((String)node.getId())) continue;
            if (processedNodeIDs.contains(node.getId()) && node.equals((Object)nodeUnderValidation)) {
                return false;
            }
            processedNodeIDs.add(node.getId());
        }
        return noDoubledIDs;
    }
}

