/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.utils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Required;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.generated.Aggregate;
import org.fusesource.ide.camel.model.generated.ConvertBody;
import org.fusesource.ide.camel.model.generated.Log;
import org.fusesource.ide.camel.model.generated.Process;
import org.fusesource.ide.camel.model.generated.RemoveHeader;
import org.fusesource.ide.camel.model.generated.RemoveProperty;
import org.fusesource.ide.camel.model.generated.Resequence;
import org.fusesource.ide.camel.model.generated.SetHeader;
import org.fusesource.ide.camel.model.generated.SetOutHeader;
import org.fusesource.ide.camel.model.generated.SetProperty;

public class NodeUtils {
    public static String getPropertyName(Object id) {
        String propertyName = id.toString();
        int idx = propertyName.indexOf(46);
        if (idx > 0) {
            propertyName = propertyName.substring(idx + 1);
        }
        propertyName = String.valueOf(propertyName.substring(0, 1).toLowerCase()) + propertyName.substring(1);
        return propertyName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isMandatory(Object bean, String propertyName) {
        AbstractNode node;
        Class camelClass;
        if (bean instanceof AbstractNode && (camelClass = (node = (AbstractNode)bean).getCamelDefinitionClass()) != null) {
            XmlAccessorType accessorType = camelClass.getAnnotation(XmlAccessorType.class);
            boolean useMethods = true;
            if (accessorType != null && accessorType.value().equals((Object)XmlAccessType.FIELD)) {
                useMethods = false;
            }
            try {
                XmlAttribute attribute;
                XmlElement element;
                Required annotation;
                int n;
                BeanInfo beanInfo = Introspector.getBeanInfo(camelClass);
                PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
                if (propertyDescriptors != null) {
                    PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors;
                    n = propertyDescriptors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
                        if (propertyName.equals(propertyDescriptor.getName())) {
                            Method writeMethod = propertyDescriptor.getWriteMethod();
                            if (writeMethod == null) break;
                            annotation = writeMethod.getAnnotation(Required.class);
                            if (annotation != null) {
                                return true;
                            }
                            if (!useMethods) break;
                            element = writeMethod.getAnnotation(XmlElement.class);
                            if (element != null && element.required()) {
                                return true;
                            }
                            attribute = writeMethod.getAnnotation(XmlAttribute.class);
                            if (attribute == null || !attribute.required()) break;
                            return true;
                        }
                        ++n2;
                    }
                }
                if (!useMethods) {
                    Field[] fields;
                    Field[] fieldArray = fields = camelClass.getDeclaredFields();
                    int n3 = fields.length;
                    n = 0;
                    while (n < n3) {
                        Field field = fieldArray[n];
                        if (propertyName.equals(field.getName())) {
                            annotation = field.getAnnotation(Required.class);
                            if (annotation != null) {
                                return true;
                            }
                            element = field.getAnnotation(XmlElement.class);
                            if (element != null && element.required()) {
                                return true;
                            }
                            attribute = field.getAnnotation(XmlAttribute.class);
                            if (attribute != null && attribute.required()) {
                                return true;
                            }
                        }
                        ++n;
                    }
                }
            }
            catch (IntrospectionException introspectionException) {}
        }
        if (bean instanceof Resequence && "expression".equals(propertyName)) {
            return true;
        }
        if ("uri".equals(propertyName)) return true;
        if (propertyName.endsWith("Uri")) return true;
        if (bean instanceof Aggregate) {
            if ("strategyRef".equals(propertyName)) return true;
        }
        if (bean instanceof ConvertBody) {
            if ("type".equals(propertyName)) return true;
        }
        if (bean instanceof ExpressionDefinition) {
            if (NodeUtils.isMandatoryExpression((AbstractNode)bean)) return true;
        }
        if (bean instanceof Log) {
            if ("message".equals(propertyName)) return true;
        }
        if (bean instanceof Process) {
            if ("ref".equals(propertyName)) return true;
        }
        if (bean instanceof RemoveHeader) {
            if ("headerName".equals(propertyName)) return true;
        }
        if (bean instanceof RemoveProperty) {
            if ("propertyName".equals(propertyName)) return true;
        }
        if (bean instanceof SetHeader) {
            if ("headerName".equals(propertyName)) return true;
        }
        if (bean instanceof SetOutHeader) {
            if ("headerName".equals(propertyName)) return true;
        }
        if (!(bean instanceof SetProperty)) return false;
        if ("propertyName".equals(propertyName)) return true;
        return false;
    }

    public static boolean isMandatoryExpression(AbstractNode node) {
        Class camelClass = node.getCamelDefinitionClass();
        return ExpressionNode.class.isAssignableFrom(camelClass);
    }
}

