/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.provider;

import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.palette.IPaletteCompartmentEntry;
import org.eclipse.graphiti.palette.IToolEntry;
import org.eclipse.graphiti.palette.impl.ObjectCreationToolEntry;
import org.eclipse.graphiti.palette.impl.PaletteCompartmentEntry;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.tb.ContextButtonEntry;
import org.eclipse.graphiti.tb.ContextMenuEntry;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IContextMenuEntry;
import org.eclipse.graphiti.tb.IDecorator;
import org.eclipse.graphiti.tb.ImageDecorator;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.editor.EditorMessages;
import org.fusesource.ide.camel.editor.Messages;
import org.fusesource.ide.camel.editor.editor.RiderDesignEditor;
import org.fusesource.ide.camel.editor.features.custom.AddRouteFeature;
import org.fusesource.ide.camel.editor.features.custom.DeleteAllEndpointBreakpointsFeature;
import org.fusesource.ide.camel.editor.features.custom.SetEndpointBreakpointFeature;
import org.fusesource.ide.camel.editor.provider.PaletteCategoryItemProvider;
import org.fusesource.ide.camel.editor.provider.generated.AddNodeMenuFactory;
import org.fusesource.ide.camel.editor.validation.ValidationFactory;
import org.fusesource.ide.camel.editor.validation.ValidationResult;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.Flow;
import org.fusesource.ide.commons.util.Objects;
import org.fusesource.ide.launcher.debug.model.CamelConditionalBreakpoint;
import org.fusesource.ide.launcher.debug.model.CamelEndpointBreakpoint;
import org.fusesource.ide.launcher.debug.util.CamelDebugUtils;

public class ToolBehaviourProvider
extends DefaultToolBehaviorProvider {
    public ToolBehaviourProvider(IDiagramTypeProvider dtp) {
        super(dtp);
    }

    public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
        ICustomFeature[] cf;
        ICreateConnectionFeature[] features;
        IFeatureProvider featureProvider = this.getFeatureProvider();
        IContextButtonPadData data = super.getContextButtonPad(context);
        PictogramElement pe = context.getPictogramElement();
        this.setGenericContextButtons(data, pe, CONTEXT_BUTTON_DELETE);
        CreateConnectionContext ccc = new CreateConnectionContext();
        ccc.setSourcePictogramElement(pe);
        Anchor anchor = null;
        if (pe instanceof Anchor) {
            anchor = (Anchor)pe;
        } else if (pe instanceof AnchorContainer) {
            anchor = Graphiti.getPeService().getChopboxAnchor((AnchorContainer)pe);
        }
        ccc.setSourceAnchor(anchor);
        ContextButtonEntry button = new ContextButtonEntry(null, (IContext)context);
        button.setText("Create connection");
        button.setIconId("org.fusesource.demo.icons.flow");
        ICreateConnectionFeature[] iCreateConnectionFeatureArray = features = featureProvider.getCreateConnectionFeatures();
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            ICreateConnectionFeature feature = iCreateConnectionFeatureArray[n2];
            if (feature.isAvailable((IContext)ccc) && feature.canStartConnection((ICreateConnectionContext)ccc)) {
                button.addDragAndDropFeature((IFeature)feature);
            }
            ++n2;
        }
        if (button.getDragAndDropFeatures().size() > 0) {
            data.getDomainSpecificContextButtons().add(button);
        }
        CustomContext cc = new CustomContext(new PictogramElement[]{pe});
        ICustomFeature[] iCustomFeatureArray = cf = this.getFeatureProvider().getCustomFeatures((ICustomContext)cc);
        int n3 = cf.length;
        int n4 = 0;
        while (n4 < n3) {
            ICustomFeature f = iCustomFeatureArray[n4];
            if (!(f instanceof DeleteAllEndpointBreakpointsFeature) && f instanceof SetEndpointBreakpointFeature && f.isAvailable((IContext)cc)) {
                ContextButtonEntry button2 = new ContextButtonEntry((IFeature)f, (IContext)cc);
                data.getDomainSpecificContextButtons().add(button2);
            }
            ++n4;
        }
        return data;
    }

    public IContextMenuEntry[] getContextMenu(ICustomContext context) {
        LinkedList<ContextMenuEntry> entries = new LinkedList<ContextMenuEntry>();
        IFeatureProvider fp = this.getFeatureProvider();
        ICustomFeature[] customFeatures = fp.getCustomFeatures(context);
        int i = 0;
        while (i < customFeatures.length) {
            ICustomFeature customFeature = customFeatures[i];
            if (customFeature.isAvailable((IContext)context)) {
                ContextMenuEntry menuEntry = new ContextMenuEntry((IFeature)customFeature, (IContext)context);
                entries.add(menuEntry);
            }
            ++i;
        }
        ContextMenuEntry addNodesMenu = new ContextMenuEntry(null, null);
        addNodesMenu.setText(EditorMessages.camelMenuAddLabel);
        addNodesMenu.setDescription("Add and connect new nodes");
        addNodesMenu.setSubmenu(true);
        AddNodeMenuFactory f = new AddNodeMenuFactory();
        f.setupMenuStructure(addNodesMenu, context, fp);
        entries.add(addNodesMenu);
        addNodesMenu.add((IContextMenuEntry)new ContextMenuEntry((IFeature)new AddRouteFeature(fp), (IContext)context));
        return entries.toArray(new IContextMenuEntry[entries.size()]);
    }

    public IPaletteCompartmentEntry[] getPalette() {
        ArrayList<PaletteCompartmentEntry> ret = new ArrayList<PaletteCompartmentEntry>();
        PaletteCompartmentEntry compartmentEntryEndpoints = new PaletteCompartmentEntry(Messages.endpointsDrawerTitle, null);
        ret.add(compartmentEntryEndpoints);
        PaletteCompartmentEntry compartmentEntryRouting = new PaletteCompartmentEntry(Messages.routingDrawerTitle, null);
        ret.add(compartmentEntryRouting);
        PaletteCompartmentEntry compartmentEntryControlFlow = new PaletteCompartmentEntry(Messages.controlFlowDrawerTitle, null);
        ret.add(compartmentEntryControlFlow);
        PaletteCompartmentEntry compartmentEntryTransformation = new PaletteCompartmentEntry(Messages.transformationDrawerTitle, null);
        ret.add(compartmentEntryTransformation);
        PaletteCompartmentEntry compartmentEntryMisc = new PaletteCompartmentEntry(Messages.miscellaneousDrawerTitle, null);
        ret.add(compartmentEntryMisc);
        IPaletteCompartmentEntry[] superCompartments = super.getPalette();
        int i = 1;
        while (i < superCompartments.length) {
            IPaletteCompartmentEntry entry = superCompartments[i];
            for (IToolEntry toolEntry : entry.getToolEntries()) {
                ObjectCreationToolEntry octe;
                if (!(toolEntry instanceof ObjectCreationToolEntry) || !((octe = (ObjectCreationToolEntry)toolEntry).getCreateFeature() instanceof PaletteCategoryItemProvider)) continue;
                PaletteCategoryItemProvider pcit = (PaletteCategoryItemProvider)octe.getCreateFeature();
                switch (pcit.getCategoryType()) {
                    case ENDPOINTS: {
                        compartmentEntryEndpoints.addToolEntry(toolEntry);
                        break;
                    }
                    case ROUTING: {
                        compartmentEntryRouting.addToolEntry(toolEntry);
                        break;
                    }
                    case CONTROL_FLOW: {
                        compartmentEntryControlFlow.addToolEntry(toolEntry);
                        break;
                    }
                    case TRANSFORMATION: {
                        compartmentEntryTransformation.addToolEntry(toolEntry);
                        break;
                    }
                    case MISCELLANEOUS: {
                        compartmentEntryMisc.addToolEntry(toolEntry);
                        break;
                    }
                }
            }
            ++i;
        }
        return ret.toArray(new IPaletteCompartmentEntry[ret.size()]);
    }

    public IDecorator[] getDecorators(PictogramElement pe) {
        IDecorator[] superDecorators;
        LinkedList<Object> decorators = new LinkedList<Object>();
        IDecorator[] iDecoratorArray = superDecorators = super.getDecorators(pe);
        int n = superDecorators.length;
        int n2 = 0;
        while (n2 < n) {
            IDecorator d = iDecoratorArray[n2];
            decorators.add(d);
            ++n2;
        }
        IFeatureProvider featureProvider = this.getFeatureProvider();
        Object bo = featureProvider.getBusinessObjectForPictogramElement(pe);
        if (bo instanceof AbstractNode) {
            ImageDecorator imageRenderingDecorator;
            AbstractNode node = (AbstractNode)bo;
            ValidationResult res = ValidationFactory.getInstance().validate(node);
            if (res.getInformationCount() > 0) {
                for (String message : res.getInformations()) {
                    imageRenderingDecorator = new ImageDecorator("org.eclipse.graphiti.eclipse.information.tsk");
                    imageRenderingDecorator.setMessage(message);
                    decorators.add(imageRenderingDecorator);
                }
            }
            if (res.getWarningCount() > 0) {
                for (String message : res.getWarnings()) {
                    imageRenderingDecorator = new ImageDecorator("org.eclipse.graphiti.eclipse.warning.tsk");
                    imageRenderingDecorator.setMessage(message);
                    decorators.add(imageRenderingDecorator);
                }
            }
            if (res.getErrorCount() > 0) {
                for (String message : res.getErrors()) {
                    imageRenderingDecorator = new ImageDecorator("org.eclipse.graphiti.eclipse.error.tsk");
                    imageRenderingDecorator.setMessage(message);
                    decorators.add(imageRenderingDecorator);
                }
            }
            if (this.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer() != null && this.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer() instanceof RiderDesignEditor) {
                CamelEndpointBreakpoint cep;
                RiderDesignEditor editor = (RiderDesignEditor)this.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer();
                IFile activeFile = editor.getCamelContextFile();
                String projectName = activeFile.getProject().getName();
                IBreakpoint bp = CamelDebugUtils.getBreakpointForSelection((String)node.getId(), (String)activeFile.getName(), (String)projectName);
                if (bp != null && bp instanceof CamelEndpointBreakpoint && (cep = (CamelEndpointBreakpoint)bp).getProjectName().equals(activeFile.getProject().getName())) {
                    try {
                        if (cep.isEnabled() && bp instanceof CamelConditionalBreakpoint) {
                            ImageDecorator imageRenderingDecorator2 = new ImageDecorator("org.fusesource.demo.icons.yellowdot");
                            imageRenderingDecorator2.setMessage("");
                            decorators.add(imageRenderingDecorator2);
                        } else if (cep.isEnabled() && bp instanceof CamelEndpointBreakpoint) {
                            ImageDecorator imageRenderingDecorator3 = new ImageDecorator("org.fusesource.demo.icons.reddot");
                            imageRenderingDecorator3.setMessage("");
                            decorators.add(imageRenderingDecorator3);
                        } else {
                            ImageDecorator imageRenderingDecorator4 = new ImageDecorator("org.fusesource.demo.icons.graydot");
                            imageRenderingDecorator4.setMessage("");
                            decorators.add(imageRenderingDecorator4);
                        }
                    }
                    catch (CoreException e) {
                        Activator.getLogger().error((Throwable)e);
                    }
                }
            }
            return decorators.toArray(new IDecorator[decorators.size()]);
        }
        return super.getDecorators(pe);
    }

    public GraphicsAlgorithm[] getClickArea(PictogramElement pe) {
        IFeatureProvider featureProvider = this.getFeatureProvider();
        Object bo = featureProvider.getBusinessObjectForPictogramElement(pe);
        if (bo instanceof AbstractNode && !(bo instanceof Flow)) {
            GraphicsAlgorithm invisible;
            GraphicsAlgorithm rectangle = invisible = pe.getGraphicsAlgorithm();
            if (invisible.getGraphicsAlgorithmChildren().size() > 0) {
                rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
                if (invisible.getGraphicsAlgorithmChildren().size() > 1) {
                    rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(1);
                }
            }
            return new GraphicsAlgorithm[]{rectangle};
        }
        return super.getClickArea(pe);
    }

    public GraphicsAlgorithm getSelectionBorder(PictogramElement pe) {
        IFeatureProvider featureProvider = this.getFeatureProvider();
        Object bo = featureProvider.getBusinessObjectForPictogramElement(pe);
        if (bo instanceof AbstractNode) {
            GraphicsAlgorithm invisible;
            GraphicsAlgorithm rectangle = invisible = pe.getGraphicsAlgorithm();
            if (invisible.getGraphicsAlgorithmChildren().size() > 0) {
                rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
                if (invisible.getGraphicsAlgorithmChildren().size() > 1) {
                    rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(1);
                }
            }
            return rectangle;
        }
        return super.getSelectionBorder(pe);
    }

    public String getToolTip(GraphicsAlgorithm ga) {
        String name;
        PictogramElement pe = ga.getPictogramElement();
        Object bo = this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
        if (bo instanceof AbstractNode && (name = ((AbstractNode)bo).getDisplayToolTip()) != null && !name.isEmpty()) {
            return name;
        }
        return (String)super.getToolTip(ga);
    }

    public boolean equalsBusinessObjects(Object o1, Object o2) {
        if (o1 instanceof AbstractNode || o2 instanceof AbstractNode) {
            return Objects.equal((Object)o1, (Object)o2);
        }
        return super.equalsBusinessObjects(o1, o2);
    }

    public boolean isMultiSelectionEnabled() {
        return true;
    }
}

