/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.propertysheet;

import java.util.List;
import org.apache.camel.model.SetHeaderDefinition;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.fusesource.ide.camel.editor.propertysheet.DetailsSection;
import org.fusesource.ide.camel.model.LanguageExpressionBean;
import org.fusesource.ide.commons.ui.views.TableViewSupport;
import org.fusesource.ide.commons.util.Function1;

public class SetHeaderTableView
extends TableViewSupport {
    public static final String ID = SetHeaderTableView.class.getName();
    private final List<SetHeaderDefinition> tableData;
    private final WritableList input;

    public SetHeaderTableView(List<SetHeaderDefinition> tableData) {
        this.tableData = tableData;
        this.input = new WritableList(tableData, SetHeaderDefinition.class);
        this.setShowSearchBox(false);
    }

    protected String getHelpID() {
        return ID;
    }

    public String getColumnConfigurationId() {
        return ID;
    }

    public WritableList getInput() {
        return this.input;
    }

    protected void warnNoSite() {
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.makeActions();
        this.aboutToBeShown();
    }

    protected void createColumns() {
        int bounds = 100;
        int column = 0;
        this.clearColumns();
        Object function = new Function1(){

            public Object apply(Object element) {
                SetHeaderDefinition sh = DetailsSection.toSetHeaderDefinition(element);
                if (sh != null) {
                    return sh.getHeaderName();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Header");
        function = new Function1(){

            public Object apply(Object element) {
                LanguageExpressionBean expression;
                SetHeaderDefinition sh = DetailsSection.toSetHeaderDefinition(element);
                if (sh != null && (expression = LanguageExpressionBean.toLanguageExpressionBean((Object)sh.getExpression())) != null) {
                    return expression.getExpression();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Expression");
        function = new Function1(){

            public Object apply(Object element) {
                LanguageExpressionBean expression;
                SetHeaderDefinition sh = DetailsSection.toSetHeaderDefinition(element);
                if (sh != null && (expression = LanguageExpressionBean.toLanguageExpressionBean((Object)sh.getExpression())) != null) {
                    return expression.getLanguage();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Language");
    }

    protected void configureViewer() {
        this.viewer.setInput((Object)this.input);
    }

    protected IStructuredContentProvider createContentProvider() {
        return new ObservableListContentProvider();
    }
}

