/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.propertysheet;

import java.net.URL;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelpResource;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.editor.EditorMessages;
import org.fusesource.ide.camel.editor.propertysheet.NodeSectionSupport;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.Endpoint;

public class DocumentationSection
extends NodeSectionSupport {
    private FormToolkit toolkit;
    private Form form;
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent arg0) {
        }
    };
    private Composite parent;
    private Browser browser;

    @Override
    protected void onNodeChanged(AbstractNode node) {
        this.node = node;
        this.showDocumentationPage();
    }

    @Override
    public void aboutToBeShown() {
        this.showDocumentationPage();
        super.aboutToBeShown();
    }

    protected void showDocumentationPage() {
        if (this.node != null) {
            int idx;
            Endpoint endpoint;
            String uri;
            boolean loadedPage = false;
            if (this.node instanceof Endpoint && (uri = (endpoint = (Endpoint)this.node).getUri()) != null && (idx = uri.indexOf(58)) > 0) {
                String scheme = uri.substring(0, idx);
                String contextId = "org.fusesource.ide.camel.editor." + scheme;
                loadedPage = this.resolvePage(contextId, true);
                Activator.getLogger().debug("Loaded page " + contextId + " " + loadedPage);
            }
            if (!loadedPage) {
                String text = this.node.getDocumentationFileName();
                uri = "org.fusesource.ide.camel.editor.allEIPs";
                if (text != null) {
                    uri = "org.fusesource.ide.camel.editor." + text;
                }
                this.resolvePage(uri, false);
            }
        }
    }

    protected boolean resolvePage(String contextId, boolean endpoint) {
        IHelpResource resource;
        String contextName = contextId;
        IContext context = HelpSystem.getContext((String)contextName);
        if (context == null) {
            if (endpoint) {
                contextName = "org.fusesource.ide.camel.editor.endpoint";
            } else {
                contextName = "org.fusesource.ide.camel.editor.allEIPs";
                context = HelpSystem.getContext((String)"");
            }
            context = HelpSystem.getContext((String)contextName);
        }
        if (context == null) {
            Activator.getLogger().warning("Could not find context: " + contextName);
            return false;
        }
        IHelpResource[] relatedTopics = context.getRelatedTopics();
        if (relatedTopics != null && relatedTopics.length > 0 && (resource = relatedTopics[0]) != null) {
            String helpUrl = resource.getHref();
            IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
            URL url = helpSystem.resolve(helpUrl, true);
            return this.browser.setUrl(url.toExternalForm());
        }
        Activator.getLogger().warning("Could not find resource in context: " + contextName);
        return false;
    }

    public void refresh() {
    }

    public void createControls(final Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        this.parent = parent;
        this.toolkit = new FormToolkit(parent.getDisplay());
        super.createControls(parent, aTabbedPropertySheetPage);
        if (this.form != null && !this.form.isDisposed()) {
            try {
                this.form.dispose();
            }
            catch (Exception exception) {}
        }
        this.form = null;
        if (parent.isDisposed()) {
            return;
        }
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(1808));
        this.form = this.toolkit.createForm(parent);
        this.form.setLayoutData((Object)new GridData(1808));
        this.form.setText(EditorMessages.propertiesDocumentationTitle);
        this.toolkit.decorateFormHeading(this.form);
        this.form.getBody().setLayout((Layout)new GridLayout(1, false));
        Composite sbody = this.form.getBody();
        ToolBar navBar = new ToolBar(sbody, 0);
        this.toolkit.adapt((Composite)navBar);
        navBar.setLayoutData((Object)new GridData(800));
        final ToolItem back = new ToolItem(navBar, 8);
        back.setText("<");
        back.setEnabled(false);
        final ToolItem forward = new ToolItem(navBar, 8);
        forward.setText(">");
        forward.setEnabled(false);
        back.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DocumentationSection.this.browser.back();
            }
        });
        forward.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DocumentationSection.this.browser.forward();
            }
        });
        LocationListener locationListener = new LocationListener(){

            public void changed(LocationEvent event) {
                Browser browser = (Browser)event.widget;
                back.setEnabled(browser.isBackEnabled());
                forward.setEnabled(browser.isForwardEnabled());
            }

            public void changing(LocationEvent event) {
            }
        };
        this.browser = new Browser(sbody, 0);
        GridData data = new GridData(1808);
        this.browser.setLayoutData((Object)data);
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        URL url = helpSystem.resolve("org.fusesource.ide.help/index.html", true);
        this.browser.setUrl(url.toExternalForm());
        this.browser.addLocationListener(locationListener);
        this.form.layout(true, true);
        parent.layout(true, true);
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DocumentationSection.this.form != null && !DocumentationSection.this.form.isDisposed()) {
                    DocumentationSection.this.form.layout(true, true);
                }
                if (parent != null && !parent.isDisposed()) {
                    parent.layout(true, true);
                }
            }
        });
    }
}

