/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.propertysheet;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.SetHeaderDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Required;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fusesource.camel.tooling.util.Languages;
import org.fusesource.camel.tooling.util.Strings;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.editor.EditorMessages;
import org.fusesource.ide.camel.editor.propertysheet.NodeSectionSupport;
import org.fusesource.ide.camel.editor.propertysheet.SetHeaderDialog;
import org.fusesource.ide.camel.editor.propertysheet.SetHeaderTableView;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.CamelModelHelper;
import org.fusesource.ide.camel.model.ExpressionPropertyDescriptor;
import org.fusesource.ide.camel.model.LanguageExpressionBean;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.generated.Aggregate;
import org.fusesource.ide.camel.model.generated.ConvertBody;
import org.fusesource.ide.camel.model.generated.Log;
import org.fusesource.ide.camel.model.generated.Process;
import org.fusesource.ide.camel.model.generated.RemoveHeader;
import org.fusesource.ide.camel.model.generated.RemoveProperty;
import org.fusesource.ide.camel.model.generated.Resequence;
import org.fusesource.ide.camel.model.generated.SetHeader;
import org.fusesource.ide.camel.model.generated.SetOutHeader;
import org.fusesource.ide.camel.model.generated.SetProperty;
import org.fusesource.ide.camel.model.generated.Tooltips;
import org.fusesource.ide.camel.model.util.JaxbHelper;
import org.fusesource.ide.commons.Viewers;
import org.fusesource.ide.commons.properties.BooleanPropertyDescriptor;
import org.fusesource.ide.commons.properties.ComplexPropertyDescriptor;
import org.fusesource.ide.commons.properties.ComplexUnionPropertyDescriptor;
import org.fusesource.ide.commons.properties.EnumPropertyDescriptor;
import org.fusesource.ide.commons.properties.ListPropertyDescriptor;
import org.fusesource.ide.commons.properties.UnionTypeValue;
import org.fusesource.ide.commons.tree.Refreshable;
import org.fusesource.ide.commons.ui.actions.RunnableAction;
import org.fusesource.ide.commons.ui.form.Forms;
import org.fusesource.ide.commons.util.Sorts;

public class DetailsSection
extends NodeSectionSupport {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String NODE_DESCRIPTION = "AbstractNode.Description";
    private Composite parent;
    private FormToolkit toolkit;
    private Form form;
    private DataBindingContext bindingContext = new DataBindingContext();

    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        super.dispose();
    }

    @Override
    protected synchronized void onNodeChanged(AbstractNode node) {
        if (this.form != null && !this.form.isDisposed()) {
            try {
                this.form.dispose();
            }
            catch (Exception exception) {}
        }
        this.form = null;
        if (this.parent.isDisposed()) {
            return;
        }
        this.parent.setLayout((Layout)new GridLayout());
        this.parent.setLayoutData((Object)new GridData(1808));
        this.form = this.toolkit.createForm(this.parent);
        this.form.setLayoutData((Object)new GridData(1808));
        this.form.setText(EditorMessages.propertiesDetailsTitle);
        this.toolkit.decorateFormHeading(this.form);
        this.form.getBody().setLayout((Layout)new GridLayout(2, false));
        Composite sbody = this.form.getBody();
        if (node != null) {
            IMessageManager mmng = this.form.getMessageManager();
            this.form.setText(node.getPatternName());
            IPropertyDescriptor idDescriptor = null;
            IPropertyDescriptor descriptionDescriptor = null;
            IPropertyDescriptor[] propertyDescriptors = node.getPropertyDescriptors();
            int i = 0;
            while (i < 2) {
                IPropertyDescriptor[] iPropertyDescriptorArray = propertyDescriptors;
                int n = propertyDescriptors.length;
                int n2 = 0;
                while (n2 < n) {
                    IPropertyDescriptor descriptor = iPropertyDescriptorArray[n2];
                    Object id = descriptor.getId();
                    if ("AbstractNode.Id".equals(id)) {
                        idDescriptor = descriptor;
                    } else if (NODE_DESCRIPTION.equals(id)) {
                        descriptionDescriptor = descriptor;
                    } else {
                        boolean mandatory;
                        String propertyName = this.getPropertyName(id);
                        boolean bl = mandatory = descriptor instanceof ExpressionPropertyDescriptor || this.isMandatory(node, propertyName);
                        if (mandatory && i == 0 || !mandatory && i == 1) {
                            this.createDecoratedTextField(descriptor, this.toolkit, sbody, mmng);
                        }
                    }
                    ++n2;
                }
                ++i;
            }
            if (idDescriptor != null || descriptionDescriptor != null) {
                if (idDescriptor != null) {
                    this.createDecoratedTextField(idDescriptor, this.toolkit, sbody, mmng);
                }
                if (descriptionDescriptor != null) {
                    this.createDecoratedTextField(descriptionDescriptor, this.toolkit, sbody, mmng);
                }
            }
        } else {
            this.form.setText(EditorMessages.propertiesDetailsTitle);
        }
        this.layoutForm();
    }

    protected void layoutForm() {
        if (this.form != null && !this.form.isDisposed()) {
            this.form.layout(true, true);
        }
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.layout(true, true);
        }
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DetailsSection.this.form != null && !DetailsSection.this.form.isDisposed()) {
                    DetailsSection.this.form.layout(true, true);
                }
                if (DetailsSection.this.parent != null && !DetailsSection.this.parent.isDisposed()) {
                    DetailsSection.this.parent.layout(true, true);
                }
            }
        });
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        this.parent = parent;
        this.toolkit = new FormToolkit(parent.getDisplay());
        super.createControls(parent, aTabbedPropertySheetPage);
    }

    private void createDecoratedTextField(IPropertyDescriptor descriptor, FormToolkit toolkit, Composite parent, IMessageManager mmng) {
        boolean isComplexOrUnion;
        Section widget;
        final Object id = descriptor.getId();
        String labelText = descriptor.getDisplayName();
        String tooltip = Tooltips.tooltip((String)id.toString());
        GridData gd = new GridData(2);
        boolean isDescription = NODE_DESCRIPTION.equals(id);
        boolean isComplexProperty = descriptor instanceof ComplexPropertyDescriptor;
        boolean isUnionProperty = descriptor instanceof ComplexUnionPropertyDescriptor;
        if (isComplexProperty) {
            widget = this.bindNestedComplexProperties(toolkit, parent, mmng, (ComplexPropertyDescriptor)descriptor, id, labelText, tooltip);
        } else {
            Label label = toolkit.createLabel(parent, labelText);
            label.setToolTipText(tooltip);
            if (isDescription) {
                label.setLayoutData((Object)gd);
            }
            if (isUnionProperty) {
                widget = this.bindNestedComplexUnionProperties(toolkit, parent, mmng, id, labelText, tooltip, (ComplexUnionPropertyDescriptor)descriptor);
            } else if (descriptor instanceof ExpressionPropertyDescriptor) {
                Composite composite = toolkit.createComposite(parent);
                GridLayout layout = new GridLayout(3, false);
                this.zeroMargins(layout);
                composite.setLayout((Layout)layout);
                widget = composite;
                Text text = toolkit.createText(composite, "", 2048);
                text.setToolTipText(tooltip);
                gd = new GridData(768);
                text.setLayoutData((Object)gd);
                ISWTObservableValue textValue = Forms.observe((Text)text);
                final LanguageExpressionBean expression = LanguageExpressionBean.bindToNodeProperty((AbstractNode)this.node, (Object)id);
                Forms.bindBeanProperty((DataBindingContext)this.bindingContext, (IMessageManager)mmng, (Object)expression, (String)"expression", (boolean)this.isMandatory(expression, "expression"), (String)"expression", (IObservableValue)textValue, (Control)text);
                String languageLabel = EditorMessages.propertiesLanguageTitle;
                toolkit.createLabel(composite, languageLabel);
                Combo combo = new Combo(composite, 2048);
                combo.setItems(new Languages().languageArray());
                toolkit.adapt((Control)combo, true, true);
                ISWTObservableValue comboValue = WidgetProperties.selection().observe((Widget)combo);
                Forms.bindBeanProperty((DataBindingContext)this.bindingContext, (IMessageManager)mmng, (Object)expression, (String)"language", (boolean)this.isMandatory(expression, "language"), (String)languageLabel, (IObservableValue)comboValue, (Control)combo);
                String language = expression.getLanguage();
                if (language == null) {
                    language = CamelModelHelper.getDefaultLanguageName();
                    expression.setLanguage(language);
                }
                expression.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent event) {
                        DetailsSection.this.node.firePropertyChange(id.toString(), null, (Object)expression);
                    }
                });
            } else {
                String propertyName = this.getPropertyName(id);
                Class refType = this.isBeanRef(this.node, propertyName);
                if (refType != null) {
                    Combo combo = new Combo(parent, 2048);
                    String[] beanRefs = this.getBeanRefs(refType);
                    combo.setItems(beanRefs);
                    toolkit.adapt((Control)combo, true, true);
                    widget = combo;
                    ISWTObservableValue comboValue = WidgetProperties.selection().observe((Widget)combo);
                    Forms.bindBeanProperty((DataBindingContext)this.bindingContext, (IMessageManager)mmng, (Object)this.node, (String)propertyName, (boolean)this.isMandatory(this.node, propertyName), (String)labelText, (IObservableValue)comboValue, (Control)combo);
                } else if (this.isEndpointUri(this.node, propertyName)) {
                    Combo combo = new Combo(parent, 2048);
                    combo.setItems(this.getEndpointUris());
                    toolkit.adapt((Control)combo, true, true);
                    widget = combo;
                    ISWTObservableValue comboValue = WidgetProperties.selection().observe((Widget)combo);
                    Forms.bindBeanProperty((DataBindingContext)this.bindingContext, (IMessageManager)mmng, (Object)this.node, (String)propertyName, (boolean)this.isMandatory(this.node, propertyName), (String)labelText, (IObservableValue)comboValue, (Control)combo);
                } else if (descriptor instanceof BooleanPropertyDescriptor) {
                    Button checkbox = new Button(parent, 32);
                    widget = checkbox;
                    ISWTObservableValue textValue = Forms.observe((Button)checkbox);
                    Forms.bindBeanProperty((DataBindingContext)this.bindingContext, (IMessageManager)mmng, (Object)this.node, (String)propertyName, (boolean)this.isMandatory(this.node, propertyName), (String)labelText, (IObservableValue)textValue, (Control)checkbox);
                } else if (descriptor instanceof ListPropertyDescriptor) {
                    if (CamelModelHelper.isPropertyListOFSetHeaders((Object)id)) {
                        Control control = this.bindSetHeaderTable(toolkit, parent, id);
                        widget = control;
                    } else {
                        Control control = this.bindListOfValues(toolkit, parent, id);
                        widget = control;
                    }
                } else if (descriptor instanceof EnumPropertyDescriptor) {
                    EnumPropertyDescriptor enumProperty = (EnumPropertyDescriptor)descriptor;
                    ComboViewer combo = new ComboViewer(parent, 2056);
                    combo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
                    combo.setInput((Object)this.getEnumValues(enumProperty.getEnumType()));
                    IViewerObservableValue comboValue = ViewersObservables.observeSingleSelection((Viewer)combo);
                    Control control = combo.getControl();
                    Forms.bindBeanProperty((DataBindingContext)this.bindingContext, (IMessageManager)mmng, (Object)this.node, (String)propertyName, (boolean)this.isMandatory(this.node, propertyName), (String)labelText, (IObservableValue)comboValue, (Control)control);
                    toolkit.adapt(control, true, true);
                    widget = control;
                } else {
                    Text text = isDescription ? toolkit.createText(parent, "", 2882) : toolkit.createText(parent, "", 2048);
                    text.setToolTipText(tooltip);
                    widget = text;
                    ISWTObservableValue textValue = Forms.observe((Text)text);
                    Forms.bindBeanProperty((DataBindingContext)this.bindingContext, (IMessageManager)mmng, (Object)this.node, (String)propertyName, (boolean)this.isMandatory(this.node, propertyName), (String)labelText, (IObservableValue)textValue, (Control)text);
                }
            }
        }
        boolean bl = isComplexOrUnion = isComplexProperty || isUnionProperty;
        if (isDescription || isComplexOrUnion) {
            gd = new GridData(1808);
            gd.heightHint = 90;
            gd.grabExcessVerticalSpace = true;
            gd.grabExcessHorizontalSpace = true;
            if (isComplexOrUnion) {
                gd.heightHint = -1;
            }
            if (isComplexProperty) {
                gd.horizontalSpan = 2;
            }
        } else {
            gd = new GridData(768);
        }
        gd.widthHint = 250;
        widget.setLayoutData((Object)gd);
    }

    protected Section bindNestedComplexProperties(FormToolkit toolkit, Composite parent, IMessageManager mmng, ComplexPropertyDescriptor complexProperty, Object id, String labelText, String tooltip) {
        Class complexType = complexProperty.getPropertyType();
        Section section = toolkit.createSection(parent, 450);
        section.setText(labelText);
        section.setToolTipText(tooltip);
        Composite sectionClient = toolkit.createComposite((Composite)section);
        sectionClient.setLayout((Layout)new GridLayout(2, false));
        section.setClient((Control)sectionClient);
        Object value = this.node.getPropertyValue(id);
        if (value == null) {
            value = ObjectHelper.newInstance((Class)complexType);
            this.node.setPropertyValue(id, value);
        }
        this.bindNestedComplexProperties(toolkit, mmng, (IPropertyDescriptor)complexProperty, complexType, sectionClient, value);
        sectionClient.layout(true, true);
        return section;
    }

    protected CTabFolder bindNestedComplexUnionProperties(FormToolkit toolkit, Composite parent, IMessageManager mmng, final Object id, String labelText, String tooltip, ComplexUnionPropertyDescriptor complexProperty) {
        complexProperty.getPropertyType();
        final CTabFolder bar = new CTabFolder(parent, 2048);
        bar.setToolTipText(tooltip);
        final UnionTypeValue[] valueTypes = complexProperty.getValueTypes();
        final Object[] values = new Object[valueTypes.length];
        bar.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int idx = bar.getSelectionIndex();
                if (idx >= 0 && idx < valueTypes.length) {
                    DetailsSection.this.node.setPropertyValue(id, values[idx]);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Object value = this.node.getPropertyValue(id);
        int selectIdx = -1;
        int idx = 0;
        UnionTypeValue[] unionTypeValueArray = valueTypes;
        int n = valueTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Object tabValue;
            UnionTypeValue valueType = unionTypeValueArray[n2];
            Composite composite = new Composite((Composite)bar, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            CTabItem item = new CTabItem(bar, 2048);
            item.setText(valueType.getId());
            item.setControl((Control)composite);
            Class complexType = valueType.getValueType();
            if (complexType.isInstance(value)) {
                selectIdx = idx;
                tabValue = value;
            } else {
                tabValue = ObjectHelper.newInstance((Class)complexType);
            }
            values[idx++] = tabValue;
            this.bindNestedComplexProperties(toolkit, mmng, (IPropertyDescriptor)complexProperty, complexType, composite, tabValue);
            composite.layout(true, true);
            ++n2;
        }
        if (selectIdx >= 0) {
            bar.setSelection(selectIdx);
        }
        bar.layout(true, true);
        return bar;
    }

    public void bindNestedComplexProperties(FormToolkit toolkit, IMessageManager mmng, IPropertyDescriptor complexProperty, Class<?> complexType, Composite sectionClient, Object value) {
        try {
            PropertyDescriptor[] properties;
            boolean useMethods = JaxbHelper.useMethodReflection(complexType);
            BeanInfo beanInfo = Introspector.getBeanInfo(complexType);
            PropertyDescriptor[] propertyDescriptorArray = properties = beanInfo.getPropertyDescriptors();
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    PropertyDescriptor property;
                    block6: {
                        String propertyName;
                        block8: {
                            property = propertyDescriptorArray[n2];
                            Method getter = property.getReadMethod();
                            Method setter = property.getWriteMethod();
                            if (getter == null || setter == null) break block7;
                            propertyName = property.getName();
                            if (!useMethods) break block8;
                            if (JaxbHelper.hasXmlAnnotation((AnnotatedElement)getter) || JaxbHelper.hasXmlAnnotation((AnnotatedElement)setter)) break block6;
                            break block7;
                        }
                        try {
                            Field field = complexType.getDeclaredField(propertyName);
                            if (!JaxbHelper.hasXmlAnnotation((AnnotatedElement)field)) {
                            }
                            break block6;
                        }
                        catch (Exception exception) {
                            Activator.getLogger().debug("Failed to find field: " + propertyName + " on " + complexType.getName());
                        }
                        break block7;
                    }
                    this.bindNestedPojoProperty(toolkit, mmng, complexProperty, sectionClient, value, property, complexType);
                }
                ++n2;
            }
        }
        catch (IntrospectionException e) {
            Activator.getLogger().warning("Failed to introspect " + complexType.getName() + ". Reason: " + e, (Throwable)e);
        }
    }

    protected void bindNestedPojoProperty(FormToolkit toolkit, IMessageManager mmng, final IPropertyDescriptor complexProperty, Composite parent, Object value, PropertyDescriptor property, Class<?> complexType) {
        ISWTObservableValue observable;
        Button widget;
        String propertyName = property.getName();
        Class<?> propertyType = property.getPropertyType();
        String labelText = org.fusesource.ide.commons.util.Strings.capitalize((String)Strings.splitCamelCase((String)propertyName));
        if (complexProperty instanceof ComplexUnionPropertyDescriptor) {
            Label label = new Label(parent, 0);
            label.setText(labelText);
        } else {
            toolkit.createLabel(parent, labelText);
        }
        Class refType = this.isBeanRef(value, propertyName);
        if (Boolean.TYPE.isAssignableFrom(propertyType) || Boolean.class.isAssignableFrom(propertyType)) {
            ISWTObservableValue textValue;
            Button checkbox;
            widget = checkbox = new Button(parent, 2080);
            observable = textValue = Forms.observe((Button)checkbox);
            Forms.bindPojoProperty((DataBindingContext)this.bindingContext, (IMessageManager)mmng, (Object)value, (String)propertyName, (boolean)this.isMandatory(value, propertyName), (String)labelText, (IObservableValue)textValue, (Control)checkbox);
        } else if (refType != null) {
            ISWTObservableValue comboValue;
            Combo combo = new Combo(parent, 2048);
            String[] beanRefs = this.getBeanRefs(refType);
            combo.setItems(beanRefs);
            toolkit.adapt((Control)combo, true, true);
            widget = combo;
            observable = comboValue = WidgetProperties.selection().observe((Widget)combo);
            Forms.bindPojoProperty((DataBindingContext)this.bindingContext, (IMessageManager)mmng, (Object)value, (String)propertyName, (boolean)this.isMandatory(value, propertyName), (String)labelText, (IObservableValue)comboValue, (Control)combo);
        } else if (this.isEndpointUri(value, propertyName)) {
            ISWTObservableValue comboValue;
            Combo combo = new Combo(parent, 2048);
            combo.setItems(this.getEndpointUris());
            toolkit.adapt((Control)combo, true, true);
            widget = combo;
            observable = comboValue = WidgetProperties.selection().observe((Widget)combo);
            Forms.bindPojoProperty((DataBindingContext)this.bindingContext, (IMessageManager)mmng, (Object)value, (String)propertyName, (boolean)this.isMandatory(value, propertyName), (String)labelText, (IObservableValue)comboValue, (Control)combo);
        } else if (Enum.class.isAssignableFrom(propertyType)) {
            ComboViewer combo = new ComboViewer(parent, 2056);
            combo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            combo.setInput((Object)this.getEnumValues(propertyType));
            IViewerObservableValue comboValue = ViewersObservables.observeSingleSelection((Viewer)combo);
            observable = comboValue;
            Control control = combo.getControl();
            Forms.bindPojoProperty((DataBindingContext)this.bindingContext, (IMessageManager)mmng, (Object)value, (String)propertyName, (boolean)this.isMandatory(value, propertyName), (String)labelText, (IObservableValue)comboValue, (Control)control);
            toolkit.adapt(control, true, true);
            widget = control;
        } else {
            ISWTObservableValue textValue;
            Text text = toolkit.createText(parent, "");
            widget = text;
            observable = textValue = Forms.observe((Text)text);
            Forms.bindPojoProperty((DataBindingContext)this.bindingContext, (IMessageManager)mmng, (Object)value, (String)propertyName, (boolean)this.isMandatory(value, propertyName), (String)labelText, (IObservableValue)textValue, (Control)text);
        }
        widget.setLayoutData((Object)new GridData(768));
        if (observable != null && this.node != null) {
            observable.addChangeListener(new IChangeListener(){

                public void handleChange(ChangeEvent event) {
                    String id = complexProperty.getId().toString();
                    DetailsSection.this.fireNodePropertyChangedEvent(id);
                }
            });
        }
    }

    protected Control bindListOfValues(FormToolkit toolkit, Composite parent, final Object id) {
        Object value;
        final Composite panel = toolkit.createComposite(parent);
        panel.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(3, false);
        this.zeroMargins(layout);
        panel.setLayout((Layout)layout);
        final Text name = toolkit.createText(panel, "");
        name.setLayoutData((Object)new GridData(768));
        final Button add = new Button(panel, 2056);
        add.setText("Add");
        add.setLayoutData((Object)new GridData(64));
        final Button delete = new Button(panel, 2056);
        delete.setText("Delete");
        final ListViewer viewer = new ListViewer(panel, 2048);
        viewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        final Control control = viewer.getControl();
        control.setLayoutData((Object)new GridData(1808));
        if (control instanceof org.eclipse.swt.widgets.List) {
            org.eclipse.swt.widgets.List list = (org.eclipse.swt.widgets.List)control;
            list.setSize(400, 300);
        }
        ArrayList listData = (value = this.node.getPropertyValue(id)) instanceof List ? (ArrayList)value : new ArrayList();
        final WritableList input = new WritableList(listData, String.class);
        this.node.setPropertyValue(id, (Object)input);
        viewer.setInput((Object)input);
        final Runnable addAction = new Runnable(){

            @Override
            public void run() {
                String p = name.getText();
                name.setText("");
                if (!input.contains((Object)p)) {
                    input.add((Object)p);
                    DetailsSection.this.fireNodePropertyChangedEvent(id);
                    if (control instanceof org.eclipse.swt.widgets.List) {
                        org.eclipse.swt.widgets.List list = (org.eclipse.swt.widgets.List)control;
                        list.pack(true);
                    }
                    panel.layout(true, true);
                    DetailsSection.this.layoutForm();
                }
            }
        };
        final Runnable deleteAction = new Runnable(){

            @Override
            public void run() {
                if (!viewer.getSelection().isEmpty()) {
                    IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                    for (String p : selection) {
                        input.remove((Object)p);
                    }
                    DetailsSection.this.fireNodePropertyChangedEvent(id);
                }
            }
        };
        name.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.stateMask == 0 && e.keyCode == 13) {
                    addAction.run();
                }
            }
        });
        control.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.stateMask == 0 && e.keyCode == 8 || e.stateMask == 0 && e.keyCode == 127) {
                    deleteAction.run();
                }
            }
        });
        add.setEnabled(false);
        delete.setEnabled(false);
        name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                add.setEnabled(name.getText().length() > 0);
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                delete.setEnabled(!event.getSelection().isEmpty());
            }
        });
        delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                deleteAction.run();
            }
        });
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                addAction.run();
            }
        });
        toolkit.adapt(control, true, true);
        return control;
    }

    private TableViewerColumn createTableViewerColumn(TableViewer viewer, final ICellModifier modifier, final String property, String title, String tooltip) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 4);
        viewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object value = modifier.getValue(cell.getElement(), property);
                cell.setText(org.fusesource.ide.commons.util.Strings.getOrElse((Object)value));
            }
        });
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(100);
        column.setResizable(true);
        column.setMoveable(false);
        column.setToolTipText(tooltip);
        return viewerColumn;
    }

    protected Control bindSetHeaderTable(FormToolkit toolkit, Composite parent, final Object id) {
        final Composite panel = toolkit.createComposite(parent);
        panel.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        this.zeroMargins(layout);
        panel.setLayout((Layout)layout);
        Object value = this.node.getPropertyValue(id);
        ArrayList<SetHeaderDefinition> listData = value instanceof List ? (ArrayList<SetHeaderDefinition>)value : new ArrayList<SetHeaderDefinition>();
        final SetHeaderTableView tableView = new SetHeaderTableView(listData);
        final WritableList input = tableView.getInput();
        final Runnable addAction = new Runnable(){

            @Override
            public void run() {
                final SetHeaderDefinition sh = new SetHeaderDefinition("myHeaderName", (ExpressionDefinition)new LanguageExpressionBean(CamelModelHelper.getDefaultLanguageName(), ""));
                final TableViewer viewer = tableView.getViewer();
                Refreshable refreshable = new Refreshable(){

                    public void refresh() {
                        input.add((Object)sh);
                        viewer.setSelection((ISelection)new StructuredSelection((Object)sh));
                        Viewers.refresh((Viewer)viewer);
                        DetailsSection.this.layoutForm();
                        panel.layout(true, true);
                        DetailsSection.this.fireNodePropertyChangedEvent(id);
                    }
                };
                SetHeaderDialog.showDialog(sh, refreshable);
            }
        };
        final Runnable editAction = new Runnable(){

            @Override
            public void run() {
                Activator.getLogger().debug("Starting the edit...");
                final TableViewer viewer = tableView.getViewer();
                if (!viewer.getSelection().isEmpty()) {
                    IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                    Iterator iter = selection.iterator();
                    while (iter.hasNext()) {
                        SetHeaderDefinition sh = DetailsSection.toSetHeaderDefinition(iter.next());
                        if (sh == null) continue;
                        Refreshable refreshable = new Refreshable(){

                            public void refresh() {
                                Viewers.refresh((Viewer)viewer);
                                DetailsSection.this.fireNodePropertyChangedEvent(id);
                            }
                        };
                        SetHeaderDialog.showDialog(sh, refreshable);
                        break;
                    }
                }
            }
        };
        final Runnable deleteAction = new Runnable(){

            @Override
            public void run() {
                TableViewer viewer = tableView.getViewer();
                if (!viewer.getSelection().isEmpty()) {
                    IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                    Iterator iter = selection.iterator();
                    while (iter.hasNext()) {
                        SetHeaderDefinition sh = DetailsSection.toSetHeaderDefinition(iter.next());
                        if (sh == null) continue;
                        input.remove((Object)sh);
                    }
                    DetailsSection.this.fireNodePropertyChangedEvent(id);
                }
            }
        };
        tableView.setDoubleClickAction((Action)new RunnableAction(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".editSetHeaderDef", "Edit", editAction));
        tableView.createPartControl(panel);
        TableViewer viewer = tableView.getViewer();
        Control control = tableView.getControl();
        control.setLayoutData((Object)new GridData(1808));
        Composite buttonPanel = toolkit.createComposite(panel);
        buttonPanel.setLayoutData((Object)new GridData(4));
        buttonPanel.setLayout((Layout)new GridLayout(1, false));
        Button add = new Button(buttonPanel, 2056);
        add.setText("Add");
        add.setLayoutData((Object)new GridData(64));
        final Button edit = new Button(buttonPanel, 2056);
        edit.setText("Edit");
        edit.setLayoutData((Object)new GridData(64));
        final Button delete = new Button(buttonPanel, 2056);
        delete.setText("Delete");
        delete.setLayoutData((Object)new GridData(64));
        control.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.stateMask == 0 && e.keyCode == 8 || e.stateMask == 0 && e.keyCode == 127) {
                    deleteAction.run();
                }
            }
        });
        edit.setEnabled(false);
        delete.setEnabled(false);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enabled = !event.getSelection().isEmpty();
                edit.setEnabled(enabled);
                delete.setEnabled(enabled);
            }
        });
        edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                editAction.run();
            }
        });
        delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                deleteAction.run();
            }
        });
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                addAction.run();
            }
        });
        toolkit.adapt(control, true, true);
        return control;
    }

    public static SetHeaderDefinition toSetHeaderDefinition(Object element) {
        if (element instanceof SetHeaderDefinition) {
            return (SetHeaderDefinition)element;
        }
        if (element instanceof TableItem) {
            TableItem ti = (TableItem)element;
            return DetailsSection.toSetHeaderDefinition(ti.getData());
        }
        return null;
    }

    protected void zeroMargins(GridLayout layout) {
        layout.marginLeft = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
    }

    protected Object[] getEnumValues(Class<? extends Enum> enumType) {
        try {
            Method method = enumType.getMethod("values", new Class[0]);
            Object result = method.invoke(null, new Object[0]);
            if (result instanceof Object[]) {
                return (Object[])result;
            }
        }
        catch (Exception e) {
            Activator.getLogger().warning("Failed to get enum values from " + enumType, (Throwable)e);
        }
        return EMPTY_STRING_ARRAY;
    }

    protected String[] getBeanRefs(Class refType) {
        RouteContainer routeContainer = this.getNodeContainer();
        if (routeContainer != null) {
            return Sorts.toSortedStringArray(routeContainer.getBeans().keySet());
        }
        return EMPTY_STRING_ARRAY;
    }

    protected String[] getEndpointUris() {
        RouteContainer routeContainer = this.getNodeContainer();
        if (routeContainer != null) {
            return routeContainer.getEndpointUris();
        }
        return EMPTY_STRING_ARRAY;
    }

    protected String getPropertyName(Object id) {
        String propertyName = id.toString();
        int idx = propertyName.indexOf(46);
        if (idx > 0) {
            propertyName = propertyName.substring(idx + 1);
        }
        propertyName = String.valueOf(propertyName.substring(0, 1).toLowerCase()) + propertyName.substring(1);
        return propertyName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isMandatory(Object bean, String propertyName) {
        AbstractNode node;
        Class camelClass;
        if (bean instanceof AbstractNode && (camelClass = (node = (AbstractNode)bean).getCamelDefinitionClass()) != null) {
            XmlAccessorType accessorType = camelClass.getAnnotation(XmlAccessorType.class);
            boolean useMethods = true;
            if (accessorType != null && accessorType.value().equals((Object)XmlAccessType.FIELD)) {
                useMethods = false;
            }
            try {
                XmlAttribute attribute;
                XmlElement element;
                Required annotation;
                int n;
                BeanInfo beanInfo = Introspector.getBeanInfo(camelClass);
                PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
                if (propertyDescriptors != null) {
                    PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors;
                    n = propertyDescriptors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
                        if (propertyName.equals(propertyDescriptor.getName())) {
                            Method writeMethod = propertyDescriptor.getWriteMethod();
                            if (writeMethod == null) break;
                            annotation = writeMethod.getAnnotation(Required.class);
                            if (annotation != null) {
                                return true;
                            }
                            if (!useMethods) break;
                            element = writeMethod.getAnnotation(XmlElement.class);
                            if (element != null && element.required()) {
                                return true;
                            }
                            attribute = writeMethod.getAnnotation(XmlAttribute.class);
                            if (attribute == null || !attribute.required()) break;
                            return true;
                        }
                        ++n2;
                    }
                }
                if (!useMethods) {
                    Field[] fields;
                    Field[] fieldArray = fields = camelClass.getDeclaredFields();
                    int n3 = fields.length;
                    n = 0;
                    while (n < n3) {
                        Field field = fieldArray[n];
                        if (propertyName.equals(field.getName())) {
                            annotation = field.getAnnotation(Required.class);
                            if (annotation != null) {
                                return true;
                            }
                            element = field.getAnnotation(XmlElement.class);
                            if (element != null && element.required()) {
                                return true;
                            }
                            attribute = field.getAnnotation(XmlAttribute.class);
                            if (attribute != null && attribute.required()) {
                                return true;
                            }
                        }
                        ++n;
                    }
                }
            }
            catch (IntrospectionException introspectionException) {}
        }
        if (this.node instanceof Resequence && "expression".equals(propertyName)) {
            return true;
        }
        if ("uri".equals(propertyName)) return true;
        if (propertyName.endsWith("Uri")) return true;
        if (bean instanceof Aggregate) {
            if ("strategyRef".equals(propertyName)) return true;
        }
        if (bean instanceof ConvertBody) {
            if ("type".equals(propertyName)) return true;
        }
        if (bean instanceof ExpressionDefinition) {
            if (this.isMandatoryExpression()) return true;
        }
        if (bean instanceof Log) {
            if ("message".equals(propertyName)) return true;
        }
        if (bean instanceof Process) {
            if ("ref".equals(propertyName)) return true;
        }
        if (bean instanceof RemoveHeader) {
            if ("headerName".equals(propertyName)) return true;
        }
        if (bean instanceof RemoveProperty) {
            if ("propertyName".equals(propertyName)) return true;
        }
        if (bean instanceof SetHeader) {
            if ("headerName".equals(propertyName)) return true;
        }
        if (bean instanceof SetOutHeader) {
            if ("headerName".equals(propertyName)) return true;
        }
        if (!(bean instanceof SetProperty)) return false;
        if ("propertyName".equals(propertyName)) return true;
        return false;
    }

    protected boolean isMandatoryExpression() {
        Class camelClass = this.node.getCamelDefinitionClass();
        return ExpressionNode.class.isAssignableFrom(camelClass);
    }

    protected Class isBeanRef(Object bean, String propertyName) {
        if (propertyName.matches("(ref)|(.+Ref)")) {
            return Object.class;
        }
        return null;
    }

    protected boolean isEndpointUri(Object bean, String propertyName) {
        return propertyName.matches("(uri)|(.+Uri)");
    }

    protected void fireNodePropertyChangedEvent(Object id) {
        if (id != null) {
            Object newValue = this.node.getPropertyValue(id);
            this.node.firePropertyChange(id.toString(), null, newValue);
        }
    }
}

