/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.custom;

import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.swt.widgets.Display;
import org.fusesource.ide.camel.editor.editor.ConditionalBreakpointEditorDialog;
import org.fusesource.ide.camel.editor.features.custom.SetConditionalBreakpointFeature;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.launcher.debug.model.CamelConditionalBreakpoint;
import org.fusesource.ide.launcher.debug.util.CamelDebugUtils;

public class EditConditionalBreakpoint
extends SetConditionalBreakpointFeature {
    public EditConditionalBreakpoint(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public void execute(ICustomContext context) {
        Object _pe = context.getPictogramElements()[0] instanceof Connection ? ((Connection)context.getPictogramElements()[0]).getStart().getParent() : context.getPictogramElements()[0];
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)_pe);
        if (bo instanceof AbstractNode) {
            AbstractNode _ep = (AbstractNode)bo;
            IFile contextFile = this.getContextFile();
            String fileName = contextFile.getName();
            String projectName = contextFile.getProject().getName();
            IBreakpoint bp = CamelDebugUtils.getBreakpointForSelection((String)_ep.getId(), (String)fileName, (String)projectName);
            if (bp != null && bp instanceof CamelConditionalBreakpoint) {
                CamelConditionalBreakpoint ccb = (CamelConditionalBreakpoint)bp;
                ConditionalBreakpointEditorDialog dlg = new ConditionalBreakpointEditorDialog(Display.getDefault().getActiveShell(), _ep);
                dlg.setLanguage(ccb.getLanguage());
                dlg.setCondition(ccb.getConditionPredicate());
                dlg.setBlockOnOpen(true);
                if (dlg.open() == 0) {
                    String language = dlg.getLanguage();
                    String condition = dlg.getCondition();
                    ccb.setConditionPredicate(condition);
                    ccb.setLanguage(language);
                    DebugPlugin.getDefault().getBreakpointManager().fireBreakpointChanged((IBreakpoint)ccb);
                }
            }
        }
        this.getDiagramBehavior().refreshRenderingDecorators(_pe);
    }

    @Override
    public String getName() {
        return "Edit Conditional Breakpoint";
    }

    @Override
    public String getDescription() {
        return "Modifies a conditional breakpoint on the selected endpoint node";
    }

    @Override
    public String getImageId() {
        return "org.fusesource.demo.icons.properties_bp";
    }

    @Override
    public boolean isAvailable(IContext context) {
        ICustomContext cc = (ICustomContext)context;
        Object _pe = cc.getPictogramElements()[0] instanceof Connection ? ((Connection)cc.getPictogramElements()[0]).getStart().getParent() : cc.getPictogramElements()[0];
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)_pe);
        if (bo instanceof AbstractNode) {
            AbstractNode _ep = (AbstractNode)bo;
            IFile contextFile = this.getContextFile();
            String fileName = contextFile.getName();
            String projectName = contextFile.getProject().getName();
            IBreakpoint bp = CamelDebugUtils.getBreakpointForSelection((String)_ep.getId(), (String)fileName, (String)projectName);
            return bp != null && bp instanceof CamelConditionalBreakpoint;
        }
        return false;
    }

    @Override
    public boolean canExecute(ICustomContext context) {
        return this.isAvailable((IContext)context);
    }
}

