/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.custom;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramContainer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.editor.editor.RiderDesignEditor;
import org.fusesource.ide.camel.editor.features.custom.SetEndpointBreakpointFeature;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.launcher.debug.util.CamelDebugUtils;

public class DisableCamelBreakpointFeature
extends SetEndpointBreakpointFeature {
    public DisableCamelBreakpointFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public void execute(ICustomContext context) {
        Object _pe = context.getPictogramElements()[0] instanceof Connection ? ((Connection)context.getPictogramElements()[0]).getStart().getParent() : context.getPictogramElements()[0];
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)_pe);
        if (bo instanceof AbstractNode) {
            AbstractNode _ep = (AbstractNode)bo;
            try {
                IFile contextFile = this.getContextFile();
                String fileName = contextFile.getName();
                String projectName = contextFile.getProject().getName();
                IBreakpoint bp = CamelDebugUtils.getBreakpointForSelection((String)_ep.getId(), (String)fileName, (String)projectName);
                if (bp != null && bp.isEnabled()) {
                    bp.setEnabled(false);
                }
            }
            catch (CoreException e) {
                IDiagramContainer container = this.getDiagramBehavior().getDiagramContainer();
                Shell shell = container instanceof RiderDesignEditor ? ((RiderDesignEditor)container).getEditorSite().getShell() : Display.getCurrent().getActiveShell();
                MessageDialog.openError((Shell)shell, (String)"Error on enabling breakpoint", (String)e.getStatus().getMessage());
                return;
            }
        }
        this.getDiagramBehavior().refreshRenderingDecorators(_pe);
    }

    @Override
    public String getName() {
        return "Disable Breakpoint";
    }

    @Override
    public String getDescription() {
        return "Disables the breakpoint on the selected endpoint node";
    }

    @Override
    public String getImageId() {
        return "org.fusesource.demo.icons.graydot";
    }

    @Override
    public boolean isAvailable(IContext context) {
        ICustomContext cc = (ICustomContext)context;
        Object _pe = cc.getPictogramElements()[0] instanceof Connection ? ((Connection)cc.getPictogramElements()[0]).getStart().getParent() : cc.getPictogramElements()[0];
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)_pe);
        if (bo instanceof AbstractNode) {
            AbstractNode _ep = (AbstractNode)bo;
            IFile contextFile = this.getContextFile();
            String fileName = contextFile.getName();
            String projectName = contextFile.getProject().getName();
            if (_ep.supportsBreakpoint()) {
                IBreakpoint bp = CamelDebugUtils.getBreakpointForSelection((String)_ep.getId(), (String)fileName, (String)projectName);
                try {
                    return bp != null && bp.isEnabled();
                }
                catch (CoreException ex) {
                    Activator.getLogger().error((Throwable)ex);
                }
            }
        }
        return false;
    }

    @Override
    public boolean canExecute(ICustomContext context) {
        return this.isAvailable((IContext)context);
    }

    @Override
    public boolean hasDoneChanges() {
        return false;
    }
}

