/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.features.create;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.impl.AbstractCreateFeature;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.editor.provider.ImageProvider;
import org.fusesource.ide.camel.editor.provider.PaletteCategoryItemProvider;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.RouteSupport;

public class CreateFigureFeature<E>
extends AbstractCreateFeature
implements PaletteCategoryItemProvider {
    private Class<E> clazz;
    private AbstractNode exemplar;

    public CreateFigureFeature(IFeatureProvider fp, String name, String description, Class<E> clazz) {
        super(fp, name, description);
        this.clazz = clazz;
    }

    @Override
    public PaletteCategoryItemProvider.CATEGORY_TYPE getCategoryType() {
        String name = this.getCategoryName();
        return PaletteCategoryItemProvider.CATEGORY_TYPE.getCategoryType(name);
    }

    @Override
    public String getCategoryName() {
        AbstractNode node = this.getExemplar();
        if (node != null) {
            return node.getCategoryName();
        }
        return null;
    }

    public boolean canCreate(ICreateContext context) {
        return context.getTargetContainer() instanceof Diagram;
    }

    public String getCreateImageId() {
        String iconName = this.getIconName();
        if (iconName != null) {
            iconName = ImageProvider.getKeyForSmallIcon(iconName);
        }
        return iconName;
    }

    public String getCreateLargeImageId() {
        String iconName = this.getIconName();
        if (iconName != null) {
            iconName = String.format("%s_large", iconName);
        }
        return iconName;
    }

    private String getIconName() {
        AbstractNode node = this.getExemplar();
        if (node != null) {
            return node.getIconName();
        }
        return null;
    }

    protected AbstractNode getExemplar() {
        if (this.exemplar == null) {
            try {
                this.exemplar = (AbstractNode)this.clazz.newInstance();
            }
            catch (Exception e) {
                Activator.getLogger().warning("Failed to create instance of " + this.clazz + ". " + e, (Throwable)e);
            }
        }
        return this.exemplar;
    }

    protected void setExemplar(AbstractNode exemplar) {
        this.exemplar = exemplar;
    }

    public Object[] create(ICreateContext context) {
        AbstractNode node = this.createNode();
        RouteSupport selectedRoute = Activator.getDiagramEditor().getSelectedRoute();
        this.getDiagram();
        if (selectedRoute != null) {
            selectedRoute.addChild(node);
        } else {
            Activator.getLogger().warning("Warning! Could not find currently selectedNode, so can't associate this node with the route!: " + node);
        }
        PictogramElement pe = this.addGraphicalRepresentation((IAreaContext)context, node);
        this.getFeatureProvider().link(pe, (Object)node);
        this.getFeatureProvider().getDirectEditingInfo().setActive(true);
        return new Object[]{node};
    }

    protected AbstractNode createNode() {
        AbstractNode node = null;
        try {
            node = (AbstractNode)this.clazz.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return node;
    }
}

