/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.editor;

import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.fusesource.ide.camel.editor.editor.INodeViewer;
import org.fusesource.ide.camel.editor.editor.RiderDesignEditor;
import org.fusesource.ide.camel.editor.handlers.AutoLayoutAction;
import org.fusesource.ide.camel.editor.handlers.DeleteNodeAction;
import org.fusesource.ide.camel.editor.handlers.DeleteRouteAction;
import org.fusesource.ide.camel.editor.provider.generated.AddNodeMenuFactory;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.RouteSupport;
import org.fusesource.ide.camel.model.generated.Route;

public class RiderEditorContextMenuProvider
extends ContextMenuProvider {
    private ActionRegistry actionRegistry;
    private final RiderDesignEditor editor;
    private final INodeViewer nodeViewer;

    public RiderEditorContextMenuProvider(RiderDesignEditor editor, INodeViewer nodeViewer, EditPartViewer viewer, ActionRegistry registry) {
        super(viewer);
        this.editor = editor;
        this.nodeViewer = nodeViewer;
        if (registry == null) {
            throw new IllegalArgumentException();
        }
        this.actionRegistry = registry;
    }

    public ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    public RiderDesignEditor getEditor() {
        return this.editor;
    }

    public INodeViewer getNodeViewer() {
        return this.nodeViewer;
    }

    public void buildContextMenu(IMenuManager menu) {
        AbstractNode node = this.nodeViewer.getSelectedNode();
        if (node == null) {
            node = this.editor.getModel();
        }
        if (node != null && node instanceof Route) {
            DeleteRouteAction deleteRouteAction = new DeleteRouteAction();
            deleteRouteAction.setSelectedRoute((RouteSupport)node);
            menu.add((IAction)deleteRouteAction);
        }
        menu.add((IContributionItem)new Separator());
        final AddNodeMenuFactory factory = new AddNodeMenuFactory();
        final MenuManager subMenu = new MenuManager("Add", factory.getImageDescriptor("add.png"), "org.fusesource.ide.actions.add");
        menu.add((IContributionItem)subMenu);
        subMenu.setRemoveAllWhenShown(true);
        subMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AbstractNode node = RiderEditorContextMenuProvider.this.nodeViewer.getSelectedNode();
                if (node == null) {
                    node = RiderEditorContextMenuProvider.this.editor.getModel();
                }
                boolean enabled = node != null;
                subMenu.setVisible(enabled);
                factory.fillMenu(RiderEditorContextMenuProvider.this.editor, subMenu, node);
            }
        });
        if (node != null && !(node instanceof Route)) {
            DeleteNodeAction deleteNodeAction = new DeleteNodeAction();
            deleteNodeAction.setSelectedNode(node);
            menu.add((IAction)deleteNodeAction);
        }
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)new AutoLayoutAction());
    }

    private IAction getAction(String actionId) {
        return this.actionRegistry.getAction((Object)actionId);
    }
}

