/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.editor;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.fusesource.ide.camel.editor.AbstractNodes;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.RouteContainer;

public class NodeSelectionSupport
implements ISelectionListener {
    protected AbstractNode selectedNode;
    private RouteContainer nodeContainer;

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        AbstractNode lastNode = this.selectedNode;
        this.selectedNode = AbstractNodes.getSelectedNode(selection);
        if (this.selectedNode != null) {
            if (this.selectedNode instanceof RouteContainer) {
                this.nodeContainer = (RouteContainer)this.selectedNode;
            } else {
                RouteContainer parent = this.selectedNode.getParent();
                if (parent != null) {
                    this.nodeContainer = parent;
                }
            }
            if (lastNode == this.selectedNode) {
                return;
            }
            this.onNodeChanged(this.selectedNode);
        }
    }

    protected void onNodeChanged(AbstractNode node) {
    }

    public AbstractNode getSelectedNode() {
        return this.selectedNode;
    }

    public RouteContainer getNodeContainer() {
        if (this.nodeContainer == null && this.selectedNode != null) {
            this.nodeContainer = this.selectedNode.getParent();
        }
        return this.nodeContainer;
    }
}

