/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.editor;

import org.apache.camel.impl.DefaultCamelContext;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.fusesource.camel.tooling.util.Languages;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.commons.util.Strings;
import org.fusesource.ide.preferences.PreferenceManager;

public class ConditionalBreakpointEditorDialog
extends TitleAreaDialog {
    private static final String[] SUPPORTED_LANGUAGES = new Languages().languageArray();
    private static final String PATTERN_SIMPLE = "${%s}";
    private static final String[] SIMPLE_VARS = new String[]{"camelId", "camelContext.OGNL", "exchangeId", "id", "body", "in.body", "body.OGNL", "in.body.OGNL", "bodyAs(type)", "mandatoryBodyAs(type)", "out.body", "header.foo", "header[foo]", "headers.foo", "headers[foo]", "in.header.foo", "in.header[foo]", "in.headers.foo", "in.headers[foo]", "header.foo[bar]", "in.header.foo[bar]", "in.headers.foo[bar]", "header.foo.OGNL", "in.header.foo.OGNL", "in.headers.foo.OGNL", "out.header.foo", "out.header[foo]", "out.headers.foo", "out.headers[foo]", "headerAs(key,type)", "headers", "in.headers", "property.foo", "property[foo]", "property.foo.OGNL", "sys.foo", "sysenv.foo", "exception", "exception.OGNL", "exception.message", "exception.stacktrace", "date:command:pattern", "bean:bean expression", "properties:locations:key", "routeId", "threadName", "ref:xxx", "type:name.field"};
    private static final String PATTERN_SCRIPTING = "%s";
    private static final String[] SCRIPTING_VARS = new String[]{"context", "camelContext", "exchange", "request", "response", "properties", "request.headers.get('foo')", "response.headers.get('foo')"};
    private static final String PATTERN_SPEL = "#{%s}";
    private static final String[] SPEL_VARS = new String[]{"this", "exchange", "exception", "exchangeId", "fault", "body", "request", "request.headers['foo']", "request.body", "response", "response.headers['foo']", "response.body", "properties", "property(foo)", "property(foo, type)"};
    private String language;
    private String condition;
    private AbstractNode node;
    private Group grp_language;
    private Group grp_condition;
    private Combo combo_language;
    private StyledText text_condition;
    private Button btn_variables;
    private Menu textMenu;
    private Menu variablesContextSubMenu;
    private MenuItem mVarItem;

    public ConditionalBreakpointEditorDialog(Shell parentShell, AbstractNode node) {
        super(parentShell);
        this.node = node;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(String.format("Edit Conditional Breakpoint on %s ...", this.node.getDisplayText()));
    }

    public void create() {
        super.create();
        this.setTitle("Edit the condition and language of your breakpoint...");
        this.setMessage("Please choose a language and define a condition for the breakpoint...", 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, true);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        this.createLanguageControls(container);
        this.createConditionControls(container);
        container.pack();
        this.prepareContextMenu();
        return area;
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        this.validate();
        return c;
    }

    protected void okPressed() {
        if (this.validate()) {
            this.saveInputs();
            super.okPressed();
        }
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean isHelpAvailable() {
        return true;
    }

    private void createLanguageControls(Composite container) {
        int idx;
        FillLayout grpLayout = new FillLayout(512);
        grpLayout.marginHeight = 10;
        grpLayout.marginWidth = 10;
        this.grp_language = new Group(container, 2048);
        this.grp_language.setText("Language");
        this.grp_language.setToolTipText("Please select a language from the drop down box...");
        this.grp_language.setLayout((Layout)grpLayout);
        this.grp_language.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.combo_language = new Combo((Composite)this.grp_language, 2060);
        this.combo_language.setToolTipText("Please select a language from the drop down box...");
        this.combo_language.setItems(SUPPORTED_LANGUAGES);
        this.combo_language.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ConditionalBreakpointEditorDialog.this.validate();
                ConditionalBreakpointEditorDialog.this.prepareContextMenu();
            }
        });
        if (this.language != null && (idx = this.combo_language.indexOf(this.language)) != -1) {
            this.combo_language.select(idx);
            return;
        }
        String defaultLanguage = PreferenceManager.getInstance().loadPreferenceAsString("defaultLanguagePreference");
        int idx2 = this.combo_language.indexOf(defaultLanguage);
        if (idx2 != -1) {
            this.combo_language.select(idx2);
            return;
        }
        if (this.combo_language.getItemCount() > 0) {
            this.combo_language.select(0);
        }
    }

    private void createConditionControls(Composite container) {
        GridLayout grpLayout = new GridLayout(1, true);
        grpLayout.verticalSpacing = 10;
        grpLayout.marginHeight = 10;
        grpLayout.marginWidth = 10;
        this.grp_condition = new Group(container, 2048);
        this.grp_condition.setText("Condition");
        this.grp_condition.setToolTipText("Please define your condition...");
        this.grp_condition.setLayout((Layout)grpLayout);
        this.grp_condition.setLayoutData((Object)new GridData(4, 4, true, true));
        GridData data_text_condition = new GridData(4, 4, true, true);
        data_text_condition.verticalSpan = 4;
        this.text_condition = new StyledText((Composite)this.grp_condition, 68418);
        this.text_condition.setEditable(true);
        this.text_condition.setEnabled(true);
        this.text_condition.setToolTipText("Please specify your condition...");
        this.text_condition.setLayoutData((Object)data_text_condition);
        this.text_condition.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConditionalBreakpointEditorDialog.this.validate();
            }
        });
        GridData data_btn_variables = new GridData(131072, 128, true, false);
        this.btn_variables = new Button((Composite)this.grp_condition, 2056);
        this.btn_variables.setText("Variables");
        this.btn_variables.setToolTipText("Select a predefined variable...");
        this.btn_variables.setLayoutData((Object)data_btn_variables);
        this.btn_variables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConditionalBreakpointEditorDialog.this.onVariablesButtonPressed(e);
            }
        });
        if (this.condition != null) {
            this.text_condition.setText(this.condition);
        }
    }

    private void onVariablesButtonPressed(SelectionEvent e) {
        Point point = this.btn_variables.toDisplay(new Point(e.x, e.y));
        Menu varsSubMenu = this.createVariablesMenu((Control)this.btn_variables);
        this.createVariableSubmenu(varsSubMenu);
        varsSubMenu.setLocation(point.x, point.y);
        varsSubMenu.setVisible(true);
    }

    private void prepareContextMenu() {
        if (this.textMenu == null) {
            this.textMenu = this.createVariablesMenu((Control)this.text_condition);
            this.mVarItem = new MenuItem(this.textMenu, 64, 0);
            this.mVarItem.setText("Variables");
            this.variablesContextSubMenu = new Menu(this.textMenu);
            this.createVariableSubmenu(this.variablesContextSubMenu);
            this.mVarItem.setMenu(this.variablesContextSubMenu);
            new MenuItem(this.textMenu, 2, 1);
            MenuItem cutItem = new MenuItem(this.textMenu, 8, 2);
            cutItem.setText("Cut");
            cutItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConditionalBreakpointEditorDialog.this.text_condition.invokeAction(131199);
                }
            });
            MenuItem copyItem = new MenuItem(this.textMenu, 8, 3);
            copyItem.setText("Copy");
            copyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConditionalBreakpointEditorDialog.this.text_condition.invokeAction(17039369);
                }
            });
            MenuItem pasteItem = new MenuItem(this.textMenu, 8, 4);
            pasteItem.setText("Paste");
            pasteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConditionalBreakpointEditorDialog.this.text_condition.invokeAction(16908297);
                }
            });
            new MenuItem(this.textMenu, 2, 5);
            MenuItem markAllItem = new MenuItem(this.textMenu, 8, 6);
            markAllItem.setText("Select all");
            markAllItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConditionalBreakpointEditorDialog.this.text_condition.invokeAction(262209);
                }
            });
        } else {
            this.variablesContextSubMenu = new Menu(this.textMenu);
            this.createVariableSubmenu(this.variablesContextSubMenu);
            this.mVarItem.setMenu(this.variablesContextSubMenu);
        }
    }

    private Menu createVariablesMenu(Control parent) {
        Menu variablesMenu = new Menu(parent);
        parent.setMenu(variablesMenu);
        return variablesMenu;
    }

    private void createVariableSubmenu(Menu parentItem) {
        String lang = this.combo_language.getText().trim();
        if (lang.equalsIgnoreCase("simple")) {
            this.createVariables(parentItem, SIMPLE_VARS, PATTERN_SIMPLE);
        } else if (lang.equalsIgnoreCase("spel")) {
            this.createVariables(parentItem, SPEL_VARS, PATTERN_SPEL);
        } else if (lang.equalsIgnoreCase("groovy") || lang.equalsIgnoreCase("ruby") || lang.equalsIgnoreCase("php") || lang.equalsIgnoreCase("ruby") || lang.equalsIgnoreCase("el") || lang.equalsIgnoreCase("sql") || lang.equalsIgnoreCase("jxpath") || lang.equalsIgnoreCase("mvel") || lang.equalsIgnoreCase("ognl") || lang.equalsIgnoreCase("python") || lang.equalsIgnoreCase("xpath") || lang.equalsIgnoreCase("xquery") || lang.equalsIgnoreCase("javascript")) {
            this.createVariables(parentItem, SCRIPTING_VARS, PATTERN_SCRIPTING);
        }
        if (parentItem.getItemCount() == 0) {
            MenuItem dummyItem = new MenuItem(parentItem, 8);
            dummyItem.setText("<nothing available>");
            dummyItem.setEnabled(false);
        }
    }

    private void createVariables(Menu parentItem, String[] commands, final String pattern) {
        String[] stringArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            String cmd;
            final String command = cmd = stringArray[n2];
            MenuItem item = new MenuItem(parentItem, 8);
            item.setText(cmd);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    if (ConditionalBreakpointEditorDialog.this.text_condition.getSelectionText().length() > 0 && command.indexOf("foo") != -1) {
                        String selectedText = ConditionalBreakpointEditorDialog.this.text_condition.getSelectionText();
                        String newCommand = command.replaceFirst("foo", selectedText);
                        String insertText = String.format(pattern, newCommand);
                        Point p = ConditionalBreakpointEditorDialog.this.text_condition.getSelectionRange();
                        ConditionalBreakpointEditorDialog.this.text_condition.replaceTextRange(p.x, selectedText.length(), insertText);
                    } else {
                        String insertText = String.format(ConditionalBreakpointEditorDialog.PATTERN_SIMPLE, command);
                        ConditionalBreakpointEditorDialog.this.text_condition.insert(insertText);
                    }
                }
            });
            ++n2;
        }
    }

    private void saveInputs() {
        this.language = this.combo_language.getText();
        this.condition = this.text_condition.getText().replaceAll("\n", "").replaceAll("\r", "").trim();
    }

    private boolean validate() {
        block12: {
            if (Strings.isBlank((String)this.combo_language.getText())) {
                this.setErrorMessage("You must select a language from the language combo box.");
                if (this.getButton(0) != null) {
                    this.getButton(0).setEnabled(false);
                }
                return false;
            }
            if (Strings.isBlank((String)this.text_condition.getText().replaceAll("\n", "").replaceAll("\r", "").trim())) {
                this.setErrorMessage("You must enter a valid condition using the selected language.");
                if (this.getButton(0) != null) {
                    this.getButton(0).setEnabled(false);
                }
                return false;
            }
            DefaultCamelContext ctx = new DefaultCamelContext();
            try {
                try {
                    ctx.resolveLanguage(this.combo_language.getText().trim()).createPredicate(this.text_condition.getText().replaceAll("\n", "").replaceAll("\r", "").trim());
                    ctx.shutdown();
                }
                catch (Exception ex) {
                    if (!ex.getMessage().contains("No language could be found for:")) {
                        this.setErrorMessage("Condition Error: " + ex.getMessage());
                        if (this.getButton(0) != null) {
                            this.getButton(0).setEnabled(false);
                        }
                        ctx = null;
                        return false;
                    }
                    ctx = null;
                    break block12;
                }
            }
            catch (Throwable throwable) {
                ctx = null;
                throw throwable;
            }
            ctx = null;
        }
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(true);
        }
        this.setErrorMessage(null);
        return true;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }
}

