/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.commands;

import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.editor.editor.RiderDesignEditor;
import org.fusesource.ide.camel.editor.utils.StyleUtil;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.RouteSupport;

public class HighlightNodeCommand
extends RecordingCommand {
    private final RiderDesignEditor designEditor;
    private AbstractNode node;
    private boolean highlight;

    public HighlightNodeCommand(RiderDesignEditor designEditor, TransactionalEditingDomain editingDomain, AbstractNode node, boolean highlight) {
        super(editingDomain);
        this.designEditor = designEditor;
        this.node = node;
        this.highlight = highlight;
    }

    protected void doExecute() {
        PictogramElement pe;
        if (this.node == null) {
            return;
        }
        if (this.designEditor.getMultiPageEditor().getActivePage() == 1) {
            this.designEditor.getMultiPageEditor().switchToDesignEditor();
        }
        if (this.node != null && this.highlight && this.node.getParent() != null && this.node.getParent() instanceof RouteSupport) {
            this.designEditor.setSelectedRoute((RouteSupport)this.node.getParent());
        }
        if ((pe = this.designEditor.getFeatureProvider().getPictogramElementForBusinessObject((Object)this.node)) == null) {
            Activator.getLogger().debug("Warning could not find PictogramElement for highlight node: " + this.node);
            return;
        }
        IGaService gaService = Graphiti.getGaService();
        try {
            if (pe instanceof ContainerShape) {
                ContainerShape cs = (ContainerShape)pe;
                if (this.highlight) {
                    cs.getGraphicsAlgorithm().setLineVisible(Boolean.valueOf(true));
                    cs.getGraphicsAlgorithm().setLineStyle(LineStyle.DASH);
                    cs.getGraphicsAlgorithm().setLineWidth(Integer.valueOf(cs.getGraphicsAlgorithm().getLineWidth() + 3));
                    cs.getGraphicsAlgorithm().setForeground(gaService.manageColor(this.designEditor.getDiagram(), StyleUtil.getColorConstant("255,0,0")));
                } else {
                    cs.getGraphicsAlgorithm().setLineVisible(Boolean.valueOf(false));
                    cs.getGraphicsAlgorithm().setLineStyle(LineStyle.SOLID);
                    cs.getGraphicsAlgorithm().setLineWidth(Integer.valueOf(cs.getGraphicsAlgorithm().getLineWidth() - 3));
                    cs.getGraphicsAlgorithm().setForeground(gaService.manageColor(this.designEditor.getDiagram(), StyleUtil.E_CLASS_FOREGROUND));
                }
                for (Shape shape : cs.getChildren()) {
                    if (!(shape.getGraphicsAlgorithm() instanceof Text)) continue;
                    Text text = (Text)shape.getGraphicsAlgorithm();
                    if (this.highlight) {
                        text.setForeground(gaService.manageColor(this.designEditor.getDiagram(), StyleUtil.getColorConstant("255,0,0")));
                        continue;
                    }
                    text.setForeground(gaService.manageColor(this.designEditor.getDiagram(), StyleUtil.E_CLASS_TEXT_FOREGROUND));
                }
            }
        }
        catch (Exception exception) {}
    }
}

