/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.commands;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.swt.widgets.Display;
import org.fusesource.ide.camel.editor.commands.AddNewRouteCommand;
import org.fusesource.ide.camel.editor.commands.AddNodeCommand;
import org.fusesource.ide.camel.editor.commands.ChangeGridColorCommand;
import org.fusesource.ide.camel.editor.commands.DeleteNodeCommand;
import org.fusesource.ide.camel.editor.commands.DeleteRouteCommand;
import org.fusesource.ide.camel.editor.commands.HighlightNodeCommand;
import org.fusesource.ide.camel.editor.commands.LayoutCommand;
import org.fusesource.ide.camel.editor.commands.UpdateCommand;
import org.fusesource.ide.camel.editor.editor.RiderDesignEditor;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.RouteSupport;

public class DiagramOperations {
    public static LayoutCommand layoutDiagram(RiderDesignEditor designEditor) {
        TransactionalEditingDomain editingDomain = DiagramOperations.createEditingDomain(designEditor);
        LayoutCommand operation = new LayoutCommand(designEditor, editingDomain);
        DiagramOperations.execute(editingDomain, operation, false);
        return operation;
    }

    public static UpdateCommand updateSelectedNode(RiderDesignEditor designEditor) {
        TransactionalEditingDomain editingDomain = DiagramOperations.createEditingDomain(designEditor);
        UpdateCommand operation = new UpdateCommand(designEditor, editingDomain, designEditor.getSelectedNode());
        DiagramOperations.execute(editingDomain, operation, true);
        return operation;
    }

    public static UpdateCommand updateDiagram(RiderDesignEditor designEditor) {
        TransactionalEditingDomain editingDomain = DiagramOperations.createEditingDomain(designEditor);
        UpdateCommand operation = new UpdateCommand(designEditor, editingDomain, (AbstractNode)designEditor.getSelectedRoute());
        DiagramOperations.execute(editingDomain, operation, true);
        return operation;
    }

    public static AddNodeCommand addNode(RiderDesignEditor designEditor, Class<? extends AbstractNode> aClass, AbstractNode selectedNode) {
        TransactionalEditingDomain editingDomain = DiagramOperations.createEditingDomain(designEditor);
        AddNodeCommand operation = new AddNodeCommand(designEditor, editingDomain, aClass, selectedNode);
        DiagramOperations.execute(editingDomain, operation, true);
        return operation;
    }

    public static AddNewRouteCommand addNewRoute(RiderDesignEditor designEditor) {
        TransactionalEditingDomain editingDomain = DiagramOperations.createEditingDomain(designEditor);
        AddNewRouteCommand operation = new AddNewRouteCommand(designEditor, editingDomain);
        DiagramOperations.execute(editingDomain, operation, true);
        return operation;
    }

    public static DeleteRouteCommand deleteRoute(RiderDesignEditor designEditor, RouteSupport selectedRoute) {
        TransactionalEditingDomain editingDomain = DiagramOperations.createEditingDomain(designEditor);
        DeleteRouteCommand operation = new DeleteRouteCommand(designEditor, editingDomain, selectedRoute);
        DiagramOperations.execute(editingDomain, operation, true);
        return operation;
    }

    public static DeleteNodeCommand deleteNode(RiderDesignEditor designEditor, AbstractNode selectedNode) {
        TransactionalEditingDomain editingDomain = DiagramOperations.createEditingDomain(designEditor);
        DeleteNodeCommand operation = new DeleteNodeCommand(designEditor, editingDomain, selectedNode);
        DiagramOperations.execute(editingDomain, operation, true);
        return operation;
    }

    public static void execute(TransactionalEditingDomain editingDomain, RecordingCommand operation, boolean modelChanged) {
        editingDomain.getCommandStack().execute((Command)operation);
        if (!modelChanged) {
            editingDomain.getCommandStack().flush();
        }
    }

    protected static synchronized TransactionalEditingDomain createEditingDomain(RiderDesignEditor designEditor) {
        IDiagramBehavior diagramBehavior;
        TransactionalEditingDomain editingDomain = designEditor.getEditingDomain();
        Diagram diagram = designEditor.getDiagram();
        if (diagram == null) {
            return null;
        }
        if (editingDomain == null && (diagramBehavior = designEditor.getDiagramTypeProvider().getDiagramBehavior()) != null) {
            editingDomain = diagramBehavior.getEditingDomain();
        }
        if (editingDomain == null) {
            ResourceSet resourceSet = null;
            Resource eResource = diagram.eResource();
            if (eResource != null) {
                resourceSet = eResource.getResourceSet();
            }
            if (resourceSet == null) {
                resourceSet = new ResourceSetImpl();
            }
            if ((editingDomain = TransactionUtil.getEditingDomain((ResourceSet)resourceSet)) == null) {
                editingDomain = GraphitiUi.getEmfService().createResourceSetAndEditingDomain();
            }
        }
        if (designEditor.getEditingDomain() == null) {
            designEditor.setEditingDomain(editingDomain);
        }
        return editingDomain;
    }

    public static ChangeGridColorCommand updateGridColor(RiderDesignEditor designEditor) {
        TransactionalEditingDomain editingDomain = DiagramOperations.createEditingDomain(designEditor);
        ChangeGridColorCommand operation = new ChangeGridColorCommand(designEditor, editingDomain);
        DiagramOperations.execute(editingDomain, operation, false);
        return operation;
    }

    public static void highlightNode(final RiderDesignEditor designEditor, final AbstractNode node, final boolean highlight) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TransactionalEditingDomain editingDomain = DiagramOperations.createEditingDomain(designEditor);
                if (editingDomain != null) {
                    HighlightNodeCommand operation = new HighlightNodeCommand(designEditor, editingDomain, node, highlight);
                    DiagramOperations.execute(editingDomain, operation, false);
                }
            }
        });
    }
}

