/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.commands;

import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fusesource.ide.camel.editor.EditorMessages;
import org.fusesource.ide.camel.editor.editor.RiderDesignEditor;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.RouteSupport;

public class DeleteRouteCommand
extends RecordingCommand {
    private final RiderDesignEditor designEditor;
    private final RouteSupport selectedRoute;

    public DeleteRouteCommand(RiderDesignEditor designEditor, TransactionalEditingDomain editingDomain, RouteSupport selectedRoute) {
        super(editingDomain);
        this.designEditor = designEditor;
        this.selectedRoute = selectedRoute;
    }

    protected void doExecute() {
        boolean deleteIt;
        if (this.selectedRoute != null && (deleteIt = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)EditorMessages.deleteRouteCommandLabel, (String)EditorMessages.deleteRouteCommandDescription))) {
            RouteContainer model = this.designEditor.getModel();
            model.removeChild((AbstractNode)this.selectedRoute);
            RouteSupport newRoute = null;
            if (model.getChildren().size() < 1) {
                this.designEditor.addNewRoute();
            }
            newRoute = (RouteSupport)model.getChildren().get(0);
            this.designEditor.clearSelectedRouteCache();
            this.designEditor.setSelectedRoute(newRoute);
        }
    }
}

