/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.commands;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.graphiti.util.IColorConstant;
import org.fusesource.ide.camel.editor.editor.RiderDesignEditor;
import org.fusesource.ide.camel.editor.utils.StyleUtil;
import org.fusesource.ide.preferences.PreferenceManager;

public class ChangeGridColorCommand
extends RecordingCommand {
    private final RiderDesignEditor designEditor;

    public ChangeGridColorCommand(RiderDesignEditor designEditor, TransactionalEditingDomain editingDomain) {
        super(editingDomain);
        this.designEditor = designEditor;
    }

    protected void doExecute() {
        GraphicalViewer graphicalViewer;
        if (this.designEditor != null && (graphicalViewer = this.designEditor.getGraphicalViewer()) != null && graphicalViewer.getEditPartRegistry() != null) {
            GraphicsAlgorithm ga;
            ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)graphicalViewer.getEditPartRegistry().get(LayerManager.ID);
            IFigure gridFigure = rootEditPart.getLayer((Object)"Grid Layer");
            IColorConstant cc = StyleUtil.getColorConstant(PreferenceManager.getInstance().loadPreferenceAsString("diagramGridColorPreference"));
            Diagram diagram = this.designEditor.getDiagram();
            if (cc != null && diagram != null && (ga = diagram.getGraphicsAlgorithm()) != null) {
                ga.setForeground(GraphitiUi.getGaService().manageColor(diagram, cc));
                gridFigure.repaint();
                gridFigure.revalidate();
                this.designEditor.getDiagramBehavior().refreshContent();
            }
        }
    }
}

