/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.core.persistence;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.ICDIElement;
import org.jboss.tools.cdi.core.IProducer;
import org.jboss.tools.cdi.core.extension.ICDIExtension;
import org.jboss.tools.cdi.core.extension.IDefinitionContextExtension;
import org.jboss.tools.cdi.core.extension.feature.IBuildParticipantFeature;
import org.jboss.tools.cdi.internal.core.impl.BeanMember;
import org.jboss.tools.cdi.internal.core.impl.CDIProject;
import org.jboss.tools.cdi.internal.core.impl.ClassBean;
import org.jboss.tools.cdi.internal.core.impl.definition.FieldDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.MethodDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.cdi.internal.core.scanner.FileSet;
import org.jboss.tools.cdi.seam.core.CDISeamCorePlugin;
import org.jboss.tools.cdi.seam.core.persistence.CDISeamPersistenceDefinitionContext;
import org.jboss.tools.common.java.IAnnotated;
import org.jboss.tools.common.java.ParametedType;
import org.jboss.tools.common.java.TypeDeclaration;
import org.jboss.tools.common.model.XModelObject;

public class CDISeamPersistenceExtension
implements ICDIExtension,
IBuildParticipantFeature {
    CDISeamPersistenceDefinitionContext context = new CDISeamPersistenceDefinitionContext();

    public IDefinitionContextExtension getContext() {
        return this.context;
    }

    public void beginVisiting() {
    }

    public void visitJar(IPath path, IPackageFragmentRoot root, XModelObject beansXML) {
    }

    public void visit(IFile file, IPath src, IPath webinf) {
    }

    public void buildDefinitions() {
    }

    public void buildDefinitions(FileSet fileSet) {
    }

    public void buildBeans(CDIProject target) {
        if (target.getNature() != this.context.getRootContext().getProject()) {
            return;
        }
        List definitions = target.getNature().getAllTypeDefinitions();
        if (definitions.isEmpty()) {
            return;
        }
        ParametedType entityManager = this.getType("javax.persistence.EntityManager", target);
        ParametedType entityManagerFactory = this.getType("javax.persistence.EntityManagerFactory", target);
        ParametedType session = this.getType("org.hibernate.Session", target);
        ParametedType sessionFactory = this.getType("org.hibernate.SessionFactory", target);
        if (entityManager == null && session == null) {
            return;
        }
        CDIProject cdi = target;
        for (TypeDefinition def : definitions) {
            if (def.isVetoed() || !this.isArtifact(def)) continue;
            ClassBean bean = new ClassBean();
            bean.setParent((ICDIElement)cdi);
            bean.setDefinition(def);
            for (IProducer p : bean.getProducers()) {
                if (!this.isArtefact((IAnnotated)p)) continue;
                BeanMember m = (BeanMember)p;
                TypeDeclaration d = m.getTypeDeclaration();
                ParametedType substitute = null;
                if (entityManagerFactory != null && entityManager != null && d.getType().equals(entityManagerFactory.getType())) {
                    substitute = entityManager;
                } else if (sessionFactory != null && session != null && d.getType().equals(sessionFactory.getType())) {
                    substitute = session;
                }
                if (substitute == null) continue;
                d = new TypeDeclaration(substitute, d.getResource(), d.getStartPosition(), d.getLength());
                m.setTypeDeclaration(d);
                cdi.addBean((IBean)p);
            }
        }
    }

    boolean isArtifact(TypeDefinition typeDefinition) {
        List fs = typeDefinition.getFields();
        for (FieldDefinition f : fs) {
            if (!this.isArtefact((IAnnotated)f)) continue;
            return true;
        }
        List ms = typeDefinition.getMethods();
        for (MethodDefinition m : ms) {
            if (!this.isArtefact((IAnnotated)m)) continue;
            return true;
        }
        return false;
    }

    boolean isArtefact(IAnnotated m) {
        return !(!(m instanceof IProducer) && !m.isAnnotationPresent("javax.enterprise.inject.Produces") || !m.isAnnotationPresent("org.jboss.solder.core.ExtensionManaged") && !m.isAnnotationPresent("org.jboss.seam.solder.core.ExtensionManaged"));
    }

    private ParametedType getType(String name, CDIProject project) {
        IType t = project.getNature().getType(name);
        if (t == null) {
            return null;
        }
        try {
            return project.getNature().getTypeFactory().getParametedType((IMember)t, "L" + name + ";");
        }
        catch (JavaModelException e) {
            CDISeamCorePlugin.getDefault().logError(e);
            return null;
        }
    }
}

