/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.core.international.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.cdi.seam.core.international.IBundleModel;
import org.jboss.tools.cdi.seam.core.international.impl.BundleImpl;
import org.jboss.tools.common.model.XModelObject;

public class BundleModel
implements IBundleModel {
    long timeStamp = 0L;
    Map<String, BundleImpl> bundles = new HashMap<String, BundleImpl>();

    @Override
    public BundleImpl getBundle(String name) {
        return this.bundles.get(name);
    }

    @Override
    public Set<String> getAllAvailableBundles() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.bundles.keySet());
        return result;
    }

    public void rebuild(Set<XModelObject> objects) {
        long t = this.computeTimeStamp(objects);
        if (t == this.timeStamp) {
            return;
        }
        this.timeStamp = t;
        this.bundles.clear();
        for (XModelObject o : objects) {
            this.addToBundle(this.getBundleName(o), o);
        }
    }

    private BundleImpl addToBundle(String name, XModelObject o) {
        BundleImpl b = this.getBundle(name);
        if (b == null) {
            b = new BundleImpl();
            b.setName(name);
            this.bundles.put(name, b);
        }
        b.addObject(o);
        return b;
    }

    private String getBundleName(XModelObject o) {
        Path p = new Path(o.getPath());
        p = p.removeFirstSegments(2);
        String n = p.toString();
        if ((n = n.substring(0, n.lastIndexOf(46))).indexOf(95) != -1) {
            n = n.substring(0, n.indexOf(95));
        }
        return n.replace('/', '.');
    }

    long computeTimeStamp(Set<XModelObject> objects) {
        long t = 0L;
        for (XModelObject o : objects) {
            t += (long)o.hashCode() + 713L * o.getTimeStamp();
        }
        return t;
    }
}

