/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.ui.wizard;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Settings;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.maven.core.IArtifactResolutionService;
import org.jboss.tools.maven.core.MavenCoreActivator;
import org.jboss.tools.maven.ui.Activator;
import org.jboss.tools.maven.ui.wizard.ConfigureMavenRepositoriesWizardPage;
import org.jboss.tools.maven.ui.wizard.RepositoryWrapper;

public class AddRepositoryDialog
extends TitleAreaDialog {
    private static final String URL_ALREADY_EXISTS = "URL already exists";
    private static final String URL_IS_NOT_VALID = "URL isn't valid.";
    private static final String REPOSITORY_NAME_IS_EMPTY = "The use of an empty repository name is discouraged.";
    private static final String REPOSITORY_URL_IS_REQUIRED = "Repository URL is required.";
    private static final String REPOSITORY_ID_IS_REQUIRED = "Repository ID is required.";
    private static final String PROFILE_ID_IS_REQUIRED = "Profile ID is required.";
    private static final String ADD_MAVEN_REPOSITORY_TITLE = "Add Maven Repository";
    private static final String EDIT_MAVEN_REPOSITORY_TITLE = "Edit Maven Repository";
    private static final String EMPTY_STRING = "";
    private static final String CONFIGURE_MAVEN_REPOSITORIES = "ConfigureMavenRepositories";
    private static final String LASTPATH = "lastPath";
    private static final String JSF_IMPL = "com" + File.separator + "sun" + File.separator + "faces" + File.separator + "jsf-impl";
    private static final String WFK_BOMS = "com" + File.separator + "redhat" + File.separator + "jboss" + File.separator + "wfk" + File.separator + "boms";
    private static final String JBOSS_EAP_MAVEN_REPOSITORY = "JBoss EAP Maven Repository";
    private static final String JBOSS_EAP_MAVEN_REPOSITORY_ID = "jboss-eap-maven-repository";
    private static final String JBOSS_WFK_MAVEN_REPOSITORY_ID = "jboss-wfk-maven-repository";
    private Set<RepositoryWrapper> availableRepositories;
    private Set<RepositoryWrapper> includedRepositories;
    private IMaven maven;
    private Combo profileCombo;
    private Button activeByDefaultButton;
    private boolean activeByDefault;
    private Text idText;
    private Text urlText;
    private Text nameText;
    private Image jbossImage;
    private Image resolvedImage;
    private Image unresolvedImage;
    private IDialogSettings dialogSettings;
    private String localRepository;
    private ControlDecoration profileComboDecoration;
    private ControlDecoration idTextDecoration;
    private ControlDecoration nameTextDecoration;
    private ControlDecoration urlTextDecoration;
    private ControlDecoration urlValidTextDecoration;
    private ControlDecoration urlExistsTextDecoration;
    private RepositoryWrapper repositoryWrapper;
    private ArtifactKey artifactKey;
    private Label artifactLabel;
    private String coords;
    private Label artifactImageLabel;
    private String preSelectedProfile;
    private RepositoryWrapper editWrapper;
    private boolean isEditing;
    private boolean isActive;

    public AddRepositoryDialog(Shell parentShell, Set<RepositoryWrapper> availableRepositories, Set<RepositoryWrapper> includedRepositories, IMaven maven, ArtifactKey artifactKey) {
        this(parentShell, availableRepositories, includedRepositories, maven, artifactKey, null, false);
    }

    public AddRepositoryDialog(Shell parentShell, Set<RepositoryWrapper> availableRepositories, Set<RepositoryWrapper> includedRepositories, IMaven maven, ArtifactKey artifactKey, RepositoryWrapper editWrapper, boolean isActive) {
        super(parentShell);
        this.setShellStyle(0xC70 | AddRepositoryDialog.getDefaultOrientation());
        this.availableRepositories = availableRepositories;
        this.includedRepositories = includedRepositories;
        this.maven = maven;
        this.artifactKey = artifactKey;
        this.editWrapper = editWrapper;
        this.isEditing = editWrapper != null;
        this.isActive = isActive;
        ImageDescriptor desc = Activator.imageDescriptorFromPlugin((String)"org.jboss.tools.maven.ui", (String)"icons/MavenRepositoryWizBan.png");
        this.setTitleImage(desc.createImage());
    }

    protected Control createDialogArea(Composite parent) {
        if (!this.isEditing) {
            this.getShell().setText(ADD_MAVEN_REPOSITORY_TITLE);
            this.setTitle(ADD_MAVEN_REPOSITORY_TITLE);
            this.setMessage("Enter a new repository");
        } else {
            this.getShell().setText(EDIT_MAVEN_REPOSITORY_TITLE);
            this.setTitle(EDIT_MAVEN_REPOSITORY_TITLE);
        }
        Composite area = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(area, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 300;
        gd.widthHint = 500;
        contents.setLayoutData((Object)gd);
        contents.setLayout((Layout)new GridLayout(1, false));
        AddRepositoryDialog.applyDialogFont((Control)contents);
        this.initializeDialogUnits((Control)area);
        Group profileGroup = new Group(contents, 0);
        profileGroup.setText("Profile");
        profileGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        profileGroup.setLayout((Layout)new GridLayout(3, false));
        this.createLabel((Composite)profileGroup, "Profile ID:");
        this.profileCombo = new Combo((Composite)profileGroup, 0);
        this.profileCombo.setLayoutData((Object)new GridData(768));
        String[] profileIDs = this.getProfileIds();
        this.profileCombo.setItems(profileIDs);
        this.profileCombo.setText(EMPTY_STRING);
        this.profileCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddRepositoryDialog.this.validate();
            }
        });
        this.profileCombo.setEnabled(!this.isEditing);
        this.profileComboDecoration = this.addDecoration((Control)this.profileCombo, "DEC_REQUIRED", PROFILE_ID_IS_REQUIRED);
        this.activeByDefaultButton = new Button((Composite)profileGroup, 32);
        this.activeByDefaultButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.activeByDefaultButton.setText("Active by default");
        this.profileCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddRepositoryDialog.this.selectProfile();
            }
        });
        Group repositoryGroup = new Group(contents, 0);
        repositoryGroup.setText("Repository");
        repositoryGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        repositoryGroup.setLayout((Layout)new GridLayout(2, false));
        this.createLabel((Composite)repositoryGroup, "ID:");
        this.idText = this.createText((Composite)repositoryGroup);
        this.idTextDecoration = this.addDecoration((Control)this.idText, "DEC_REQUIRED", REPOSITORY_ID_IS_REQUIRED);
        this.createLabel((Composite)repositoryGroup, "Name:");
        this.nameText = this.createText((Composite)repositoryGroup);
        this.nameTextDecoration = this.addDecoration((Control)this.nameText, "DEC_WARNING", REPOSITORY_NAME_IS_EMPTY);
        this.createLabel((Composite)repositoryGroup, "URL:");
        this.urlText = this.createText((Composite)repositoryGroup);
        this.urlTextDecoration = this.addDecoration((Control)this.urlText, "DEC_REQUIRED", REPOSITORY_URL_IS_REQUIRED);
        this.urlValidTextDecoration = this.addDecoration((Control)this.urlText, "DEC_ERROR", URL_IS_NOT_VALID);
        this.urlExistsTextDecoration = this.addDecoration((Control)this.urlText, "DEC_ERROR", URL_ALREADY_EXISTS);
        if (!this.isEditing) {
            this.createRecognizeButton(contents);
        }
        if (this.artifactKey != null) {
            String message = "The '" + this.getCoords() + "' artifact";
            final String unresolvedMessage = String.valueOf(message) + " is not resolved.";
            final String resolvedMessage = String.valueOf(message) + " is resolved.";
            Composite labelComposite = new Composite(contents, 0);
            labelComposite.setLayout((Layout)new GridLayout(2, false));
            labelComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            this.artifactImageLabel = this.createLabel(labelComposite, EMPTY_STRING);
            this.artifactLabel = this.createLabel(labelComposite, unresolvedMessage);
            this.artifactImageLabel.setImage(this.getUnresolvedImage());
            this.urlText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (AddRepositoryDialog.this.getErrorMessage() != null) {
                        return;
                    }
                    final String id = AddRepositoryDialog.this.idText.getText().trim();
                    final String url = AddRepositoryDialog.this.urlText.getText().trim();
                    Job job = new Job("Resolving artifact ..."){

                        protected IStatus run(IProgressMonitor monitor) {
                            final boolean resolved = AddRepositoryDialog.this.resolveArtifact(id, url);
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (resolved) {
                                        AddRepositoryDialog.this.artifactImageLabel.setImage(AddRepositoryDialog.this.getResolvedImage());
                                        AddRepositoryDialog.this.artifactLabel.setText(resolvedMessage);
                                    } else {
                                        AddRepositoryDialog.this.artifactImageLabel.setImage(AddRepositoryDialog.this.getUnresolvedImage());
                                        AddRepositoryDialog.this.artifactLabel.setText(unresolvedMessage);
                                    }
                                }
                            });
                            return Status.OK_STATUS;
                        }
                    };
                    job.setUser(true);
                    job.schedule();
                }
            });
        }
        if (this.preSelectedProfile != null) {
            int i = 0;
            while (i < profileIDs.length) {
                if (this.preSelectedProfile.equals(profileIDs[i])) {
                    this.profileCombo.select(i);
                    this.selectProfile();
                    break;
                }
                ++i;
            }
        }
        return area;
    }

    public void createRecognizeButton(Composite contents) {
        Button recognizeButton = new Button(contents, 8);
        recognizeButton.setLayoutData((Object)new GridData(1, 4, true, false));
        recognizeButton.setText("Recognize JBoss Maven Enterprise Repositories...");
        recognizeButton.setImage(this.getJBossImage());
        recognizeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String pathStr;
                String filterPath;
                DirectoryDialog directoryDialog = new DirectoryDialog(AddRepositoryDialog.this.getShell());
                directoryDialog.setMessage("Select the directory in which to search for JBoss Maven Enterprise Repositories:");
                directoryDialog.setText("Search for JBoss Maven Enterprise Repositories");
                AddRepositoryDialog.this.dialogSettings = Activator.getDefault().getDialogSettings();
                IDialogSettings configureMavenRepositories = AddRepositoryDialog.this.dialogSettings.getSection(AddRepositoryDialog.CONFIGURE_MAVEN_REPOSITORIES);
                if (configureMavenRepositories == null) {
                    configureMavenRepositories = AddRepositoryDialog.this.dialogSettings.addNewSection(AddRepositoryDialog.CONFIGURE_MAVEN_REPOSITORIES);
                }
                if ((filterPath = configureMavenRepositories.get(AddRepositoryDialog.LASTPATH)) != null) {
                    directoryDialog.setFilterPath(filterPath);
                }
                if ((pathStr = directoryDialog.open()) == null) {
                    return;
                }
                configureMavenRepositories.put(AddRepositoryDialog.LASTPATH, pathStr);
                Path path = new Path(pathStr);
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(AddRepositoryDialog.this.getShell());
                dialog.setBlockOnOpen(false);
                dialog.setCancelable(true);
                dialog.open();
                IProgressMonitor monitor = dialog.getProgressMonitor();
                monitor.beginTask("Searching...", 110);
                HashSet<RepositoryWrapper> repos = new HashSet<RepositoryWrapper>();
                IRunnableWithProgress runnable = new IRunnableWithProgress((IPath)path, repos){
                    private final /* synthetic */ IPath val$path;
                    private final /* synthetic */ Set val$repos;
                    {
                        this.val$path = iPath;
                        this.val$repos = set;
                    }

                    public void run(IProgressMonitor monitor2) {
                        AddRepositoryDialog.this.searchForRepositories(this.val$path, this.val$repos, monitor2);
                    }
                };
                try {
                    dialog.run(true, true, runnable);
                }
                catch (Exception e1) {
                    Activator.log(e1);
                }
                if (monitor.isCanceled()) {
                    return;
                }
                if (repos.size() == 0) {
                    String url = new File(pathStr).toURI().toString();
                    if (!(url = url.trim()).endsWith("/")) {
                        url = String.valueOf(url) + "/";
                    }
                    HashSet allRepositories = new HashSet();
                    allRepositories.addAll(AddRepositoryDialog.this.includedRepositories);
                    allRepositories.addAll(AddRepositoryDialog.this.availableRepositories);
                    boolean found = false;
                    Iterator iterator = allRepositories.iterator();
                    while (iterator.hasNext()) {
                        RepositoryWrapper wrapper = (RepositoryWrapper)iterator.next();
                        if (!url.equals(wrapper.getRepository().getUrl())) continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        MessageDialog.openInformation((Shell)AddRepositoryDialog.this.getShell(), (String)"Information", (String)"No new repository found.");
                        return;
                    }
                    boolean ok = MessageDialog.openQuestion((Shell)AddRepositoryDialog.this.getShell(), (String)"Confirm Add Repository", (String)("No new repository found. Would you like me to add the '" + url + "' repository."));
                    if (ok) {
                        Repository repository = ConfigureMavenRepositoriesWizardPage.getDefaultRepository();
                        repository.setId(AddRepositoryDialog.this.getUniqueId(new File(pathStr), "id", allRepositories));
                        repository.setName(new File(pathStr).getName());
                        repository.setUrl(url);
                        RepositoryWrapper wrapper = new RepositoryWrapper(repository, repository.getId());
                        repos.add(wrapper);
                    }
                }
                for (RepositoryWrapper wrapper : repos) {
                    if (AddRepositoryDialog.this.includedRepositories.contains(wrapper)) continue;
                    AddRepositoryDialog.this.availableRepositories.add(wrapper);
                }
                if (repos.size() > 0) {
                    String[] profileIDs = AddRepositoryDialog.this.getProfileIds();
                    AddRepositoryDialog.this.profileCombo.setItems(profileIDs);
                    RepositoryWrapper wrapper = (RepositoryWrapper)repos.iterator().next();
                    AddRepositoryDialog.this.profileCombo.setText(wrapper.getProfileId());
                    if (wrapper.getRepository() != null) {
                        AddRepositoryDialog.this.updateRepository(wrapper.getRepository());
                        AddRepositoryDialog.this.activeByDefaultButton.setSelection(true);
                    }
                }
            }
        });
    }

    private String getCoords() {
        if (this.coords == null && this.artifactKey != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.artifactKey.getGroupId());
            builder.append(":");
            builder.append(this.artifactKey.getArtifactId());
            builder.append(":");
            if (this.artifactKey.getClassifier() != null) {
                builder.append(this.artifactKey.getClassifier());
                builder.append(":");
            }
            builder.append(this.artifactKey.getVersion());
            this.coords = builder.toString();
        }
        return this.coords;
    }

    private boolean resolveArtifact(String id, String url) {
        try {
            ArrayList<ArtifactRepository> repos = new ArrayList<ArtifactRepository>();
            repos.add(MavenPlugin.getMaven().createArtifactRepository(id, url));
            repos.addAll(MavenPlugin.getMaven().getArtifactRepositories());
            IArtifactResolutionService artifactResolutionService = MavenCoreActivator.getDefault().getArtifactResolutionService();
            return artifactResolutionService.isResolved(this.coords, repos, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.log(e);
            return false;
        }
    }

    private Text createText(Composite parent) {
        Text text = new Text(parent, 2052);
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddRepositoryDialog.this.validate();
            }
        });
        return text;
    }

    protected void validate() {
        String urlString;
        this.idTextDecoration.hide();
        this.urlTextDecoration.hide();
        this.nameTextDecoration.hide();
        this.profileComboDecoration.hide();
        this.urlValidTextDecoration.hide();
        this.urlExistsTextDecoration.hide();
        this.enableOkButton(true);
        this.setMessage(null);
        if (this.profileCombo.getText().trim().isEmpty()) {
            this.setMessage(PROFILE_ID_IS_REQUIRED, 3);
            this.enableOkButton(false);
            this.showDecoration();
            return;
        }
        if (this.idText.getText().trim().isEmpty()) {
            this.setMessage(REPOSITORY_ID_IS_REQUIRED, 3);
            this.enableOkButton(false);
            this.showDecoration();
            return;
        }
        if (this.urlText.getText().trim().isEmpty()) {
            this.setMessage(REPOSITORY_URL_IS_REQUIRED, 3);
            this.enableOkButton(false);
            this.showDecoration();
            return;
        }
        try {
            urlString = new URL(this.urlText.getText().trim()).toString();
        }
        catch (MalformedURLException malformedURLException) {
            this.setMessage(URL_IS_NOT_VALID, 3);
            this.enableOkButton(false);
            this.showDecoration();
            return;
        }
        if (!urlString.endsWith("/")) {
            urlString = String.valueOf(urlString) + "/";
        }
        if (!this.isEditing) {
            for (RepositoryWrapper wrapper : this.includedRepositories) {
                if (!urlString.equals(wrapper.getRepository().getUrl())) continue;
                this.setMessage(URL_ALREADY_EXISTS, 3);
                this.enableOkButton(false);
                this.showDecoration();
                return;
            }
        }
        if (this.nameText.getText().trim().isEmpty()) {
            this.setMessage(REPOSITORY_NAME_IS_EMPTY, 2);
            this.showDecoration();
            return;
        }
    }

    private void enableOkButton(boolean enabled) {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(enabled);
        }
    }

    private void showDecoration() {
        if (this.profileCombo.getText().trim().isEmpty()) {
            this.profileComboDecoration.show();
        }
        if (this.idText.getText().trim().isEmpty()) {
            this.idTextDecoration.show();
        }
        if (this.urlText.getText().trim().isEmpty()) {
            this.urlTextDecoration.show();
        } else {
            try {
                String urlString = new URL(this.urlText.getText().trim()).toString();
                if (!urlString.endsWith("/")) {
                    urlString = String.valueOf(urlString) + "/";
                }
                for (RepositoryWrapper wrapper : this.includedRepositories) {
                    if (!urlString.equals(wrapper.getRepository().getUrl()) || this.editWrapper == null || wrapper.getRepository().equals((Object)this.editWrapper.getRepository())) continue;
                    this.urlExistsTextDecoration.show();
                }
            }
            catch (MalformedURLException malformedURLException) {
                this.urlValidTextDecoration.show();
            }
        }
        if (this.nameText.getText().trim().isEmpty()) {
            this.nameTextDecoration.show();
        }
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        label.setText(text);
        return label;
    }

    private String[] getProfileIds() {
        TreeSet<String> ids = new TreeSet<String>();
        if (!this.isEditing) {
            ids.add(EMPTY_STRING);
            for (RepositoryWrapper wrapper : this.availableRepositories) {
                if (wrapper.getProfileId() == null || wrapper.getProfileId().isEmpty()) continue;
                ids.add(wrapper.getProfileId());
            }
        } else {
            ids.add(this.preSelectedProfile);
        }
        return ids.toArray(new String[0]);
    }

    protected void updateRepository(Repository repository) {
        this.idText.setText(repository.getId() == null ? EMPTY_STRING : repository.getId());
        this.nameText.setText(repository.getName() == null ? EMPTY_STRING : repository.getName());
        this.urlText.setText(repository.getUrl() == null ? EMPTY_STRING : repository.getUrl());
    }

    private Image getJBossImage() {
        if (this.jbossImage == null) {
            ImageDescriptor desc = Activator.imageDescriptorFromPlugin((String)"org.jboss.tools.maven.ui", (String)"icons/jboss.png");
            this.jbossImage = desc.createImage();
        }
        return this.jbossImage;
    }

    private Image getResolvedImage() {
        if (this.resolvedImage == null) {
            ImageDescriptor desc = Activator.imageDescriptorFromPlugin((String)"org.jboss.tools.maven.ui", (String)"icons/resolved.gif");
            this.resolvedImage = desc.createImage();
        }
        return this.resolvedImage;
    }

    private Image getUnresolvedImage() {
        if (this.unresolvedImage == null) {
            ImageDescriptor desc = Activator.imageDescriptorFromPlugin((String)"org.jboss.tools.maven.ui", (String)"icons/unresolved.gif");
            this.unresolvedImage = desc.createImage();
        }
        return this.unresolvedImage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void searchForRepositories(IPath path, Set<RepositoryWrapper> repos, IProgressMonitor monitor) {
        File[] files = null;
        if (path != null) {
            File f = path.toFile();
            if (!f.isDirectory()) return;
            files = new File[]{f};
        } else {
            files = File.listRoots();
        }
        if (files != null) {
            int size = files.length;
            int work = 100 / size;
            int workLeft = 100 - work * size;
            int i = 0;
            while (i < size) {
                if (monitor.isCanceled()) {
                    return;
                }
                if (files[i] != null && files[i].isDirectory()) {
                    this.searchDir(repos, files[i], 4, monitor);
                }
                monitor.worked(work);
                ++i;
            }
            monitor.worked(workLeft);
            return;
        } else {
            monitor.worked(100);
        }
    }

    private void searchDir(Set<RepositoryWrapper> repos, File directory, int depth, IProgressMonitor monitor) {
        String localRepository = this.getLocalRepository();
        if (localRepository != null && localRepository.trim().equals(directory.getAbsolutePath())) {
            return;
        }
        monitor.setTaskName("Searching " + directory.getAbsolutePath());
        File comFile = new File(directory, "com");
        if (comFile.isDirectory() && this.getRepositoryFromDir(directory, repos, monitor)) {
            return;
        }
        if (depth == 0) {
            return;
        }
        File[] files = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (files != null) {
            int size = files.length;
            int i = 0;
            while (i < size) {
                if (monitor.isCanceled()) {
                    return;
                }
                this.searchDir(repos, files[i], depth - 1, monitor);
                ++i;
            }
        }
    }

    private boolean getRepositoryFromDir(File directory, Set<RepositoryWrapper> repos, IProgressMonitor monitor) {
        File[] list;
        if (monitor.isCanceled()) {
            return false;
        }
        File file = new File(directory, JSF_IMPL);
        if (file.isDirectory() && (list = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname != null && pathname.getName() != null && pathname.getName().contains("redhat");
            }
        })) != null && list.length >= 1) {
            RepositoryWrapper wrapper2;
            Repository repository = ConfigureMavenRepositoriesWizardPage.getDefaultRepository();
            HashSet<RepositoryWrapper> allRepositories = new HashSet<RepositoryWrapper>();
            allRepositories.addAll(repos);
            allRepositories.addAll(this.includedRepositories);
            allRepositories.addAll(this.availableRepositories);
            String url = this.getUrl(directory);
            if (url == null) {
                return false;
            }
            for (RepositoryWrapper wrapper2 : allRepositories) {
                if (!url.equals(wrapper2.getRepository().getUrl())) continue;
                return true;
            }
            repository.setId(this.getUniqueId(directory, JBOSS_EAP_MAVEN_REPOSITORY_ID, allRepositories));
            repository.setName(JBOSS_EAP_MAVEN_REPOSITORY);
            repository.setUrl(url);
            wrapper2 = new RepositoryWrapper(repository, repository.getId());
            repos.add(wrapper2);
            return true;
        }
        file = new File(directory, WFK_BOMS);
        if (file.isDirectory()) {
            RepositoryWrapper wrapper3;
            Repository repository = ConfigureMavenRepositoriesWizardPage.getDefaultRepository();
            HashSet<RepositoryWrapper> allRepositories = new HashSet<RepositoryWrapper>();
            allRepositories.addAll(repos);
            allRepositories.addAll(this.includedRepositories);
            allRepositories.addAll(this.availableRepositories);
            String url = this.getUrl(directory);
            if (url == null) {
                return false;
            }
            for (RepositoryWrapper wrapper3 : allRepositories) {
                if (!url.equals(wrapper3.getRepository().getUrl())) continue;
                return true;
            }
            repository.setId(this.getUniqueId(directory, JBOSS_WFK_MAVEN_REPOSITORY_ID, allRepositories));
            repository.setName("JBoss WFK Maven Repository");
            repository.setUrl(url);
            wrapper3 = new RepositoryWrapper(repository, repository.getId());
            repos.add(wrapper3);
            return true;
        }
        return false;
    }

    protected String getUrl(File directory) {
        String url;
        try {
            url = directory.toURI().toURL().toString();
        }
        catch (MalformedURLException e1) {
            Activator.log(e1);
            return null;
        }
        url = url.trim();
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        return url;
    }

    private String getUniqueId(File directory, String simpleId, Set<RepositoryWrapper> allRepositories) {
        boolean found;
        int i = 0;
        String id = simpleId;
        try {
            id = directory.toURI().toURL().toString();
        }
        catch (MalformedURLException e1) {
            Activator.log(e1);
        }
        id = new Path(id).lastSegment();
        id = id.replace(" ", "-");
        id = id.replace("_", "-");
        String startId = id = id.replace(".", "-");
        block2: do {
            found = false;
            for (RepositoryWrapper wrapper : allRepositories) {
                if (!id.equals(wrapper.getRepository().getId())) continue;
                id = String.valueOf(startId) + "-" + i++;
                found = true;
                continue block2;
            }
        } while (found);
        return id;
    }

    private String getLocalRepository() {
        if (this.localRepository == null) {
            String userSettings = ConfigureMavenRepositoriesWizardPage.getUserSettings();
            String globalSettings = MavenPlugin.getMavenRuntimeManager().getGlobalSettingsFile();
            try {
                Settings settings = this.maven.buildSettings(globalSettings, userSettings);
                this.localRepository = settings.getLocalRepository();
                if (this.localRepository == null) {
                    this.localRepository = RepositorySystem.defaultUserLocalRepository.getAbsolutePath();
                }
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
        return this.localRepository;
    }

    public boolean close() {
        if (this.jbossImage != null) {
            this.jbossImage.dispose();
        }
        if (this.resolvedImage != null) {
            this.resolvedImage.dispose();
        }
        if (this.unresolvedImage != null) {
            this.unresolvedImage.dispose();
        }
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.validate();
    }

    protected ControlDecoration addDecoration(Control control, String id, String description) {
        ControlDecoration decPath = new ControlDecoration(control, 16512);
        FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
        FieldDecoration fd = registry.getFieldDecoration(id);
        decPath.setImage(fd.getImage());
        fd.setDescription(description);
        decPath.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration(id).getImage());
        decPath.setShowOnlyOnFocus(false);
        decPath.setShowHover(true);
        decPath.setDescriptionText(description);
        return decPath;
    }

    public RepositoryWrapper getRepositoryWrapper() {
        return this.repositoryWrapper;
    }

    protected void okPressed() {
        if (this.editWrapper != null) {
            this.repositoryWrapper = this.editWrapper;
            this.populateRepository(this.repositoryWrapper.getRepository());
        } else {
            Repository repository = ConfigureMavenRepositoriesWizardPage.getDefaultRepository();
            this.populateRepository(repository);
            this.repositoryWrapper = new RepositoryWrapper(repository, this.profileCombo.getText().trim());
        }
        this.activeByDefault = this.activeByDefaultButton.getSelection();
        super.okPressed();
    }

    private void populateRepository(Repository repository) {
        repository.setId(this.idText.getText().trim());
        repository.setName(this.nameText.getText().trim());
        repository.setUrl(this.urlText.getText().trim());
    }

    public boolean isActiveByDefault() {
        return this.activeByDefault;
    }

    public void setPreSelectedProfile(String profileId) {
        this.preSelectedProfile = profileId;
    }

    private void selectProfile() {
        String id = this.profileCombo.getText();
        if (id == null || id.trim().isEmpty()) {
            return;
        }
        if (!this.isEditing) {
            for (RepositoryWrapper wrapper : this.availableRepositories) {
                if (wrapper.getProfileId() == null || wrapper.getRepository() == null || !id.equals(wrapper.getProfileId())) continue;
                this.updateRepository(wrapper.getRepository());
                this.activeByDefaultButton.setSelection(true);
                return;
            }
        } else {
            this.updateRepository(this.editWrapper.getRepository());
            this.activeByDefaultButton.setSelection(this.isActive);
            return;
        }
        try {
            Settings settings = this.maven.getSettings();
            for (Profile profile : settings.getProfiles()) {
                List repositories;
                if (!id.equals(profile.getId())) continue;
                if (profile.getActivation() == null) {
                    this.activeByDefaultButton.setSelection(false);
                }
                if (profile.getActivation() != null) {
                    this.activeByDefaultButton.setSelection(profile.getActivation().isActiveByDefault());
                }
                if ((repositories = profile.getRepositories()) != null && repositories.size() == 1) {
                    Repository repository = (Repository)repositories.get(0);
                    this.updateRepository(repository);
                }
                break;
            }
        }
        catch (CoreException e1) {
            Activator.log(e1);
        }
    }
}

