/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.ui.internal.repositories;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.maven.core.repositories.NexusRepository;
import org.jboss.tools.maven.ui.Activator;

public class EditNexusRepositoryDialog
extends TitleAreaDialog {
    private NexusRepository nexusRepository;
    private String title;

    public EditNexusRepositoryDialog(Shell parentShell, NexusRepository repository) {
        super(parentShell);
        this.setShellStyle(0xC70 | EditNexusRepositoryDialog.getDefaultOrientation());
        this.nexusRepository = repository;
        if (this.nexusRepository == null) {
            this.nexusRepository = new NexusRepository("", "", true);
            this.title = "New Repository";
        } else {
            this.title = "Edit Repository";
        }
        ImageDescriptor desc = Activator.imageDescriptorFromPlugin((String)"org.jboss.tools.maven.ui", (String)"icons/NewRepositoryWizBan.png");
        this.setTitleImage(desc.createImage());
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(area, 0);
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        gd.widthHint = 400;
        contents.setLayoutData((Object)gd);
        contents.setLayout((Layout)new GridLayout(2, false));
        EditNexusRepositoryDialog.applyDialogFont((Control)contents);
        this.initializeDialogUnits((Control)area);
        Label nameLabel = new Label(contents, 0);
        nameLabel.setText("Name:");
        final Text nameText = new Text(contents, 2048);
        gd = new GridData(4, 4, true, false);
        nameText.setLayoutData((Object)gd);
        nameText.setText(this.nexusRepository.getName());
        nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditNexusRepositoryDialog.this.nexusRepository.setName(nameText.getText());
            }
        });
        Label urlLabel = new Label(contents, 0);
        urlLabel.setText("URL:");
        final Text urlText = new Text(contents, 2048);
        gd = new GridData(4, 4, true, false);
        urlText.setLayoutData((Object)gd);
        urlText.setText(this.nexusRepository.getUrl());
        urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditNexusRepositoryDialog.this.nexusRepository.setUrl(urlText.getText());
            }
        });
        final Button enabledButton = new Button(contents, 32);
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        enabledButton.setLayoutData((Object)gd);
        enabledButton.setText("Enabled");
        enabledButton.setSelection(this.nexusRepository.isEnabled());
        enabledButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditNexusRepositoryDialog.this.nexusRepository.setEnabled(enabledButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return area;
    }

    public NexusRepository getNexusRepository() {
        return this.nexusRepository;
    }
}

