/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.jface.contentassist;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import tern.eclipse.jface.TernImagesRegistry;
import tern.server.protocol.completions.TernCompletionItem;

public class TernCompletionProposal
extends TernCompletionItem
implements ICompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2 {
    private String fDisplayString;
    private String fReplacementString;
    private int fReplacementOffset;
    private int fReplacementLength;
    private int fCursorPosition;
    private Image fImage;
    private IContextInformation fContextInformation;
    private String fAdditionalProposalInfo;
    private boolean fUpdateLengthOnValidate;
    private String fAlternateMatch;
    private char[] fTriggers;

    public TernCompletionProposal(String name, String type, String origin, Object doc, int pos, int startOffset) {
        super(name, type, origin);
        String text;
        this.fReplacementString = text = super.getSignature();
        this.fReplacementOffset = startOffset - pos;
        this.fReplacementLength = pos;
        this.fCursorPosition = text.length();
        this.fImage = this.getDefaultImage();
        this.fDisplayString = super.getText();
        this.fContextInformation = null;
        this.fAdditionalProposalInfo = doc != null ? doc.toString() : null;
    }

    protected Image getDefaultImage() {
        return TernImagesRegistry.getImage(this, false);
    }

    public void apply(IDocument document) {
        CompletionProposal proposal = new CompletionProposal(this.getReplacementString(), this.getReplacementOffset(), this.getReplacementLength(), this.getCursorPosition(), this.getImage(), this.getDisplayString(), this.getContextInformation(), this.getAdditionalProposalInfo());
        proposal.apply(document);
    }

    private int getCursorPosition() {
        return this.fCursorPosition;
    }

    protected int getReplacementLength() {
        return this.fReplacementLength;
    }

    protected int getReplacementOffset() {
        return this.fReplacementOffset;
    }

    protected String getReplacementString() {
        return this.fReplacementString;
    }

    public void apply(IDocument document, char trigger, int offset) {
        CompletionProposal proposal = new CompletionProposal(this.getReplacementString(), this.getReplacementOffset(), this.getReplacementLength(), this.getCursorPosition(), this.getImage(), this.getDisplayString(), this.getContextInformation(), this.getAdditionalProposalInfo());
        proposal.apply(document);
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        int caretOffset = viewer.getTextWidget().getCaretOffset();
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            caretOffset = extension.widgetOffset2ModelOffset(caretOffset);
        } else {
            caretOffset = viewer.getTextWidget().getCaretOffset() + viewer.getVisibleRegion().getOffset();
        }
        if (caretOffset == this.getReplacementOffset()) {
            this.apply(document);
        } else {
            try {
                int endOffsetOfChanges = this.getReplacementString().length() + this.getReplacementOffset();
                if (endOffsetOfChanges >= caretOffset) {
                    int postCaretReplacementLength = this.getReplacementOffset() + this.getReplacementLength() - caretOffset;
                    int preCaretReplacementLength = this.getReplacementString().length() - (endOffsetOfChanges - caretOffset);
                    if (postCaretReplacementLength < 0) {
                        postCaretReplacementLength = 0;
                    }
                    document.replace(caretOffset, postCaretReplacementLength, this.getReplacementString().substring(preCaretReplacementLength));
                }
                if (caretOffset > this.getReplacementOffset()) {
                    int preCaretTextLength = caretOffset - this.getReplacementOffset();
                    document.replace(this.getReplacementOffset(), preCaretTextLength, this.getReplacementString().substring(0, preCaretTextLength));
                }
            }
            catch (BadLocationException badLocationException) {
                this.apply(document);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                this.apply(document);
            }
        }
    }

    public Point getSelection(IDocument document) {
        CompletionProposal proposal = new CompletionProposal(this.getReplacementString(), this.getReplacementOffset(), this.getReplacementLength(), this.getCursorPosition(), this.getImage(), this.getDisplayString(), this.getContextInformation(), this.getAdditionalProposalInfo());
        return proposal.getSelection(document);
    }

    public Image getImage() {
        return this.fImage;
    }

    public void setImage(Image fImage) {
        this.fImage = fImage;
    }

    public String getDisplayString() {
        if (this.fDisplayString != null) {
            return this.fDisplayString;
        }
        return this.fReplacementString;
    }

    public String getAdditionalProposalInfo() {
        return this.fAdditionalProposalInfo;
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public void setContextInformation(IContextInformation contextInfo) {
        this.fContextInformation = contextInfo;
    }

    public int getContextInformationPosition() {
        if (this.getContextInformation() == null) {
            return this.getReplacementOffset() - 1;
        }
        return this.getReplacementOffset() + this.getCursorPosition();
    }

    public void setCursorPosition(int pos) {
        this.fCursorPosition = pos;
    }

    public void setDisplayString(String newDisplayString) {
        this.fDisplayString = newDisplayString;
    }

    public void setReplacementLength(int newReplacementLength) {
        this.fReplacementLength = newReplacementLength;
    }

    public char[] getTriggerCharacters() {
        return this.fTriggers;
    }

    public void setTriggerCharacters(char[] triggers) {
        this.fTriggers = triggers;
    }

    public boolean isValidFor(IDocument document, int offset) {
        return this.validate(document, offset, null);
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    protected boolean startsWith(IDocument document, int offset, String word) {
        int wordLength;
        int n = wordLength = word == null ? 0 : word.length();
        if (offset > this.fReplacementOffset + wordLength) {
            return false;
        }
        try {
            int length = offset - this.fReplacementOffset;
            String start = document.get(this.fReplacementOffset, length);
            return word != null && word.substring(0, length).equalsIgnoreCase(start) || this.fAlternateMatch != null && length <= this.fAlternateMatch.length() && this.fAlternateMatch.substring(0, length).equalsIgnoreCase(start);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        if (offset < this.fReplacementOffset) {
            return false;
        }
        boolean validated = this.startsWith(document, offset, this.fDisplayString);
        if (this.fUpdateLengthOnValidate && event != null) {
            this.fReplacementLength += event.fText.length() - event.fLength;
        }
        return validated;
    }

    public void setReplacementOffset(int replacementOffset) {
        this.fReplacementOffset = replacementOffset;
    }

    public void setReplacementString(String replacementString) {
        this.fReplacementString = replacementString;
    }
}

