/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.model.variables;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.fusesource.ide.commons.util.Strings;
import org.fusesource.ide.launcher.Activator;
import org.fusesource.ide.launcher.debug.model.CamelDebugFacade;
import org.fusesource.ide.launcher.debug.model.CamelDebugTarget;
import org.fusesource.ide.launcher.debug.model.values.BaseCamelValue;
import org.fusesource.ide.launcher.debug.model.variables.BaseCamelVariable;
import org.fusesource.ide.launcher.debug.model.variables.CamelMessageVariable;

public class CamelBodyVariable
extends BaseCamelVariable {
    private CamelMessageVariable parent;

    public CamelBodyVariable(CamelDebugTarget debugTarget, String name, Class type, CamelMessageVariable parent) {
        super(debugTarget, name, type);
        this.parent = parent;
    }

    @Override
    public boolean supportsValueModification() {
        return true;
    }

    @Override
    public void setValue(String expression) throws DebugException {
        super.setValue(new BaseCamelValue(this.fTarget, expression, String.class));
        this.markChanged();
        this.fireChangeEvent(512);
        this.updateValueOnRuntime(((CamelDebugTarget)this.getDebugTarget()).getDebugger());
    }

    @Override
    public boolean verifyValue(IValue value) throws DebugException {
        return true;
    }

    @Override
    public boolean verifyValue(String expression) throws DebugException {
        return true;
    }

    @Override
    protected void updateValueOnRuntime(CamelDebugFacade debugger) throws DebugException {
        if (Strings.isBlank((String)this.getValue().getValueString())) {
            this.delete();
        } else {
            debugger.setMessageBodyOnBreakpoint(this.getCurrentEndpointNodeId(), this.getValue().getValueString());
        }
    }

    public void delete() {
        try {
            try {
                CamelDebugFacade debugger = ((CamelDebugTarget)this.getDebugTarget()).getDebugger();
                debugger.removeMessageBodyOnBreakpoint(this.getCurrentEndpointNodeId());
                if (!Strings.isBlank((String)this.getValue().getValueString())) {
                    super.setValue(new BaseCamelValue(this.fTarget, "[Body is null]", String.class));
                    this.markChanged();
                }
            }
            catch (DebugException ex) {
                Activator.getLogger().error((Throwable)ex);
                this.fireChangeEvent(512);
            }
        }
        finally {
            this.fireChangeEvent(512);
        }
    }
}

