/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.model.values;

import java.util.ArrayList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.fusesource.ide.launcher.Activator;
import org.fusesource.ide.launcher.debug.model.CamelDebugTarget;
import org.fusesource.ide.launcher.debug.model.exchange.Message;
import org.fusesource.ide.launcher.debug.model.values.BaseCamelValue;
import org.fusesource.ide.launcher.debug.model.values.CamelHeadersValue;
import org.fusesource.ide.launcher.debug.model.variables.BaseCamelVariable;
import org.fusesource.ide.launcher.debug.model.variables.CamelBodyVariable;
import org.fusesource.ide.launcher.debug.model.variables.CamelHeadersVariable;
import org.fusesource.ide.launcher.debug.model.variables.CamelMessageVariable;

public class CamelMessageValue
extends BaseCamelValue {
    private CamelMessageVariable parent;
    private Message message;
    private ArrayList<IVariable> fVariables = new ArrayList();
    private CamelDebugTarget debugTarget;

    public CamelMessageValue(CamelDebugTarget target, Message message, Class type, CamelMessageVariable parent) {
        super(target, message.getExchangeId(), type);
        this.parent = parent;
        this.debugTarget = target;
        this.message = message;
        try {
            this.initMessage();
        }
        catch (DebugException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    private void initMessage() throws DebugException {
        BaseCamelVariable var = null;
        BaseCamelValue val = null;
        var = new CamelBodyVariable(this.debugTarget, "MessageBody", String.class, this.parent);
        val = new BaseCamelValue(this.fTarget, this.message.getBody(), var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
        var = new CamelHeadersVariable(this.debugTarget, "MessageHeaders", ArrayList.class);
        val = new CamelHeadersValue(this.fTarget, this.message.getHeaders(), var.getReferenceType(), (CamelHeadersVariable)var);
        var.setValue(val);
        this.fVariables.add(var);
        var = new BaseCamelVariable(this.debugTarget, "MessageId", String.class);
        val = new BaseCamelValue(this.fTarget, this.message.getExchangeId(), var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
    }

    @Override
    public boolean hasVariables() throws DebugException {
        return this.fVariables.size() > 0;
    }

    @Override
    public IVariable[] getVariables() throws DebugException {
        return this.fVariables.toArray(new IVariable[this.fVariables.size()]);
    }

    @Override
    protected String getVariableDisplayString() {
        return "CamelMessage";
    }
}

