/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.model;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.Breakpoint;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.launcher.debug.util.CamelDebugRegistry;
import org.fusesource.ide.launcher.debug.util.CamelDebugRegistryEntry;
import org.fusesource.ide.launcher.debug.util.CamelDebugUtils;

public class CamelEndpointBreakpoint
extends Breakpoint {
    protected String projectName;
    protected String fileName;
    protected String endpointNodeId;
    protected String contextId;
    protected IResource resource;

    public CamelEndpointBreakpoint() {
    }

    public CamelEndpointBreakpoint(IResource resource, AbstractNode endpoint, String projectName, String fileName) throws CoreException {
        this.endpointNodeId = endpoint.getId();
        this.contextId = endpoint.getCamelContextId();
        this.projectName = projectName;
        this.fileName = fileName;
        if (resource.getLocation().toFile().getPath().indexOf(String.format("%s%s%starget%s", Character.valueOf(File.separatorChar), projectName, Character.valueOf(File.separatorChar), Character.valueOf(File.separatorChar))) != -1) {
            for (ILaunchConfiguration lc : CamelDebugRegistry.getInstance().getEntries().keySet()) {
                CamelDebugRegistryEntry entry = CamelDebugRegistry.getInstance().getEntry(lc);
                if (!((IFile)entry.getEditorInput().getAdapter(IFile.class)).getFullPath().toFile().getPath().equals(resource.getFullPath().toFile().getPath())) continue;
                this.resource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(Path.fromOSString((String)CamelDebugUtils.getRawCamelContextFilePathFromLaunchConfig(lc)));
            }
        } else {
            this.resource = resource;
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = CamelEndpointBreakpoint.this.resource.createMarker("org.fusesource.ide.launcher.debug.camel.breakpoint.marker");
                marker.setAttribute("org.eclipse.debug.core.enabled", (Object)Boolean.TRUE);
                marker.setAttribute("org.eclipse.debug.core.persisted", (Object)Boolean.TRUE);
                marker.setAttribute("org.eclipse.debug.core.id", (Object)CamelEndpointBreakpoint.this.getModelIdentifier());
                marker.setAttribute("org.fusesource.ide.launcher.debug.marker.contextid", (Object)CamelEndpointBreakpoint.this.contextId);
                marker.setAttribute("org.fusesource.ide.launcher.debug.marker.endpointid", (Object)CamelEndpointBreakpoint.this.endpointNodeId);
                marker.setAttribute("org.fusesource.ide.launcher.debug.marker.projectname", (Object)CamelEndpointBreakpoint.this.projectName);
                marker.setAttribute("org.fusesource.ide.launcher.debug.marker.filename", (Object)CamelEndpointBreakpoint.this.fileName);
                marker.setAttribute("message", (Object)("Camel Breakpoint: " + CamelEndpointBreakpoint.this.resource.getName() + " [Endpoint: " + CamelEndpointBreakpoint.this.endpointNodeId + "]"));
                CamelEndpointBreakpoint.this.setMarker(marker);
            }
        };
        this.run(this.getMarkerRule(this.resource), runnable);
        this.setPersisted(true);
    }

    public void setMarker(IMarker marker) throws CoreException {
        super.setMarker(marker);
        this.projectName = marker.getAttribute("org.fusesource.ide.launcher.debug.marker.projectname", this.projectName);
        this.endpointNodeId = marker.getAttribute("org.fusesource.ide.launcher.debug.marker.endpointid", this.endpointNodeId);
        this.fileName = marker.getAttribute("org.fusesource.ide.launcher.debug.marker.filename", this.fileName);
        this.contextId = marker.getAttribute("org.fusesource.ide.launcher.debug.marker.contextid", this.contextId);
        this.resource = marker.getResource();
    }

    public String getModelIdentifier() {
        return "org.fusesource.ide.launcher.debug.camel";
    }

    public void setEndpointNodeId(String endpointNodeId) {
        this.endpointNodeId = endpointNodeId;
    }

    public String getEndpointNodeId() {
        return this.endpointNodeId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public IResource getResource() {
        return this.resource;
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public String toString() {
        return String.format("Camel Breakpoint [project=%s, fileName=%s, contextId=%s, endpointId=%s]", this.getProjectName(), this.getFileName(), this.getContextId(), this.getEndpointNodeId());
    }
}

