/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.model;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.io.XmlContainerMarshaller;
import org.fusesource.ide.commons.util.CamelUtils;
import org.fusesource.ide.commons.util.Strings;
import org.fusesource.ide.launcher.Activator;
import org.fusesource.ide.launcher.debug.model.CamelDebugElement;
import org.fusesource.ide.launcher.debug.model.CamelDebugFacade;
import org.fusesource.ide.launcher.debug.model.CamelEndpointBreakpoint;
import org.fusesource.ide.launcher.debug.model.CamelStackFrame;
import org.fusesource.ide.launcher.debug.model.CamelThread;
import org.fusesource.ide.launcher.debug.model.exchange.BacklogTracerEventMessage;
import org.fusesource.ide.launcher.debug.model.exchange.Header;
import org.fusesource.ide.launcher.debug.util.CamelDebugRegistry;
import org.fusesource.ide.launcher.debug.util.CamelDebugRegistryEntry;
import org.fusesource.ide.launcher.debug.util.CamelDebugUtils;
import org.fusesource.ide.launcher.util.CamelDebugContextEditorInput;

public class CamelDebugTarget
extends CamelDebugElement
implements IDebugTarget {
    private IProcess fProcess;
    private ILaunch fLaunch;
    private String jmxUri;
    private String jmxUser;
    private String jmxPass;
    private JMXServiceURL url;
    private JMXConnector jmxc;
    private MBeanServerConnection mbsc;
    private boolean fTerminated = false;
    private boolean fProcessingActive = true;
    private String fName;
    private String camelContextId;
    private String contentType;
    private String suspendedNodeId;
    private HashMap<String, CamelThread> threads = new HashMap();
    private EventDispatchJob dispatcher;
    private ThreadGarbageCollector garbageCollector;
    private CamelDebugFacade debugger;

    public CamelDebugTarget(ILaunch launch, IProcess process, String jmxUri, String jmxUser, String jmxPass) throws CoreException {
        super(null);
        this.fLaunch = launch;
        this.fTarget = this;
        this.fProcess = process;
        this.jmxUri = jmxUri;
        this.jmxUser = jmxUser;
        this.jmxPass = jmxPass;
        this.initCamelContextId();
        JMXConnectJob conJob = new JMXConnectJob();
        conJob.schedule();
        this.dispatcher = new EventDispatchJob();
        this.dispatcher.schedule();
        this.garbageCollector = new ThreadGarbageCollector();
        this.garbageCollector.schedule();
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
    }

    public CamelThread getThreadForId(String uniqueId) {
        CamelThread t = null;
        if (this.threads.containsKey(uniqueId)) {
            t = this.threads.get(uniqueId);
        } else {
            t = new CamelThread(this, uniqueId);
            this.threads.put(uniqueId, t);
        }
        return t;
    }

    public String getSuspendedNodeId() {
        return this.suspendedNodeId;
    }

    public String generateKey(BacklogTracerEventMessage msg) {
        if (msg == null) {
            return null;
        }
        if (msg.getMessage().getHeaders().size() > 0) {
            for (Header h : msg.getMessage().getHeaders()) {
                if (!h.getKey().equalsIgnoreCase("breadcrumbid")) continue;
                return h.getValue();
            }
        }
        return msg.getExchangeId();
    }

    private void initCamelContextId() {
        File f;
        this.camelContextId = null;
        String filePath = CamelDebugUtils.getRawCamelContextFilePathFromLaunchConfig(this.getLaunch().getLaunchConfiguration());
        if (filePath != null && (f = new File(filePath)).exists() && f.isFile() && CamelUtils.isCamelContextFile((String)filePath)) {
            XmlContainerMarshaller m = new XmlContainerMarshaller();
            RouteContainer c = m.loadRoutes(f);
            if (c != null) {
                this.camelContextId = c.getCamelContextId();
            }
            if (CamelUtils.isBlueprintFile((String)filePath)) {
                this.contentType = "blueprint";
            } else if (CamelUtils.isSpringFile((String)filePath)) {
                this.contentType = "spring";
            }
        }
    }

    private boolean connectToVM() {
        try {
            if (this.url == null) {
                this.url = new JMXServiceURL(this.jmxUri);
            }
            if (!Strings.isBlank((String)this.jmxUser)) {
                HashMap<String, String[]> envMap = new HashMap<String, String[]>();
                envMap.put("jmx.remote.credentials", new String[]{this.jmxUser, this.jmxPass});
                this.jmxc = JMXConnectorFactory.connect(this.url, envMap);
            } else {
                this.jmxc = JMXConnectorFactory.connect(this.url);
            }
            this.mbsc = this.jmxc.getMBeanServerConnection();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public IProcess getProcess() {
        return this.fProcess;
    }

    public IThread[] getThreads() throws DebugException {
        return this.threads.values().toArray(new IThread[this.threads.size()]);
    }

    public boolean hasThreads() throws DebugException {
        return true;
    }

    public String getName() throws DebugException {
        if (this.fName == null) {
            this.fName = String.format("Camel Context at %s", this.jmxUri);
        }
        return this.fName;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        String file;
        if (breakpoint.getModelIdentifier().equals("org.fusesource.ide.launcher.debug.camel") && (file = CamelDebugUtils.getRawCamelContextFilePathFromLaunchConfig(this.getLaunch().getLaunchConfiguration())) != null) {
            File f = new File(file);
            IMarker marker = breakpoint.getMarker();
            if (marker != null && marker.getResource() != null) {
                return f.getPath().equals(marker.getResource().getLocation().toFile().getPath());
            }
        }
        return false;
    }

    @Override
    public IDebugTarget getDebugTarget() {
        return this;
    }

    @Override
    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public boolean canTerminate() {
        return this.getProcess() != null && this.getProcess().canTerminate();
    }

    public boolean isTerminated() {
        return this.fTerminated || this.getProcess() != null && this.getProcess().isTerminated();
    }

    public void terminate() throws DebugException {
        this.fTerminated = true;
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        try {
            if (this.fProcess != null && !this.fProcess.isTerminated()) {
                this.disconnect();
                this.fProcess.terminate();
            }
        }
        catch (DebugException debugException) {}
        this.closeRemoteContextEditor();
        this.fireTerminateEvent();
        this.dispatcher.cancel();
        this.garbageCollector.cancel();
    }

    public boolean canResume() {
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isTerminated() && !this.isSuspended();
    }

    public boolean isSuspended() {
        return !this.fProcessingActive;
    }

    public void resume() throws DebugException {
        this.fProcessingActive = true;
        this.fireResumeEvent(32);
    }

    public void suspend() throws DebugException {
        this.fProcessingActive = false;
        this.fireSuspendEvent(32);
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                if (breakpoint.isEnabled() && this.debugger != null) {
                    if (breakpoint.getMarker().getType().equals("org.fusesource.ide.launcher.debug.camel.conditionalbreakpoint.marker")) {
                        this.debugger.addConditionalBreakpoint(CamelDebugUtils.getEndpointNodeId(breakpoint), CamelDebugUtils.getLanguage(breakpoint), CamelDebugUtils.getCondition(breakpoint));
                    } else if (breakpoint.getMarker().getType().equals("org.fusesource.ide.launcher.debug.camel.breakpoint.marker")) {
                        this.debugger.addBreakpoint(CamelDebugUtils.getEndpointNodeId(breakpoint));
                    }
                }
            }
            catch (CoreException coreException) {}
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            this.debugger.removeBreakpoint(CamelDebugUtils.getEndpointNodeId(breakpoint));
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                if (breakpoint.isEnabled()) {
                    this.breakpointAdded(breakpoint);
                } else {
                    this.breakpointRemoved(breakpoint, null);
                }
            }
            catch (CoreException coreException) {}
        }
    }

    public boolean canDisconnect() {
        return true;
    }

    public void disconnect() throws DebugException {
        if (this.debugger != null) {
            this.debugger.disableDebugger();
            this.debugger.resumeAll();
            for (CamelThread t : this.threads.values()) {
                t.terminate();
            }
            this.debugger = null;
        }
    }

    public boolean isDisconnected() {
        return this.debugger == null;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public void started(boolean createEditorInput) {
        this.fireCreationEvent();
        this.installDeferredBreakpoints();
        if (createEditorInput) {
            this.createRemoteDebugContextEditorInput();
        }
        try {
            this.resume();
        }
        catch (DebugException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    public void resumeAllThreads() {
        try {
            for (CamelThread t : this.threads.values()) {
                t.resume();
            }
            this.resume();
        }
        catch (DebugException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    private void installDeferredBreakpoints() {
        IBreakpoint[] breakpoints;
        IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.fusesource.ide.launcher.debug.camel");
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint bp = iBreakpointArray[n2];
            if (bp instanceof CamelEndpointBreakpoint) {
                CamelEndpointBreakpoint ceb = (CamelEndpointBreakpoint)bp;
                String fileUnderDebug = CamelDebugUtils.getRawCamelContextFilePathFromLaunchConfig(this.getLaunch().getLaunchConfiguration());
                IProject p = CamelDebugUtils.getProjectForFilePath(fileUnderDebug);
                if (p.getName().equals(ceb.getProjectName())) {
                    this.breakpointAdded(bp);
                }
            }
            ++n2;
        }
    }

    public CamelDebugFacade getDebugger() {
        return this.debugger;
    }

    public String getMessagesForNode(String endpointNodeId) {
        return this.debugger.dumpTracedMessagesAsXml(endpointNodeId);
    }

    private void breakpointHit(String nodeId, BacklogTracerEventMessage msg) {
        boolean bpFound = false;
        String id = this.generateKey(msg);
        CamelThread t = this.getThreadForId(id);
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.fusesource.ide.launcher.debug.camel");
        int i = 0;
        while (i < breakpoints.length) {
            CamelEndpointBreakpoint bp;
            IBreakpoint breakpoint = breakpoints[i];
            if (this.supportsBreakpoint(breakpoint) && breakpoint instanceof CamelEndpointBreakpoint && (bp = (CamelEndpointBreakpoint)breakpoint).getEndpointNodeId().equals(nodeId)) {
                t.setBreakpoints(new IBreakpoint[]{breakpoint});
                t.breakpointHit(nodeId, msg);
                this.suspendedNodeId = nodeId;
                bpFound = true;
                break;
            }
            ++i;
        }
        if (!bpFound && this.getThreadForId(this.generateKey(msg)).isStepping()) {
            t.setBreakpoints(new IBreakpoint[0]);
            t.breakpointHit(nodeId, msg);
        }
    }

    private void closeRemoteContextEditor() {
        IEditorPart ep;
        IWorkbenchPage page;
        IWorkbenchWindow[] wbw;
        if (this.getLaunch() == null || this.getLaunch().getLaunchConfiguration() == null) {
            return;
        }
        CamelDebugRegistryEntry entry = CamelDebugRegistry.getInstance().getEntry(this.getLaunch().getLaunchConfiguration());
        if (entry == null) {
            return;
        }
        CamelDebugContextEditorInput input = entry.getEditorInput();
        CamelDebugRegistry.getInstance().removeEntry(this.getLaunch().getLaunchConfiguration());
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb != null && (wbw = wb.getWorkbenchWindows()).length > 0 && (page = wbw[0].getActivePage()) != null && (ep = page.getActiveEditor()) != null && ep.getEditorInput() instanceof CamelDebugContextEditorInput) {
            CamelDebugContextEditorInput ip = (CamelDebugContextEditorInput)ep.getEditorInput();
            IFile f = (IFile)input.getAdapter(IFile.class);
            IFile fIp = (IFile)ip.getAdapter(IFile.class);
            if (fIp.getFullPath().toFile().getPath().equals(f.getFullPath().toFile().getPath())) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        page.closeEditor(ep, false);
                    }
                });
            }
        }
    }

    private void createRemoteDebugContextEditorInput() {
        try {
            CamelDebugContextEditorInput input = new CamelDebugContextEditorInput(this.debugger, this.getLaunch().getLaunchConfiguration());
            CamelDebugRegistry.getInstance().createEntry(this, this.camelContextId, input, this.getLaunch().getLaunchConfiguration());
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    public void updateEditorInput() {
        CamelDebugRegistryEntry entry = CamelDebugRegistry.getInstance().getEntry(this.getLaunch().getLaunchConfiguration());
        if (entry != null) {
            CamelDebugContextEditorInput input = entry.getEditorInput();
            input.refresh();
        }
    }

    class EventDispatchJob
    extends Job {
        public EventDispatchJob() {
            super("Camel Debug Event Dispatch");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            while (!CamelDebugTarget.this.isTerminated() && !monitor.isCanceled()) {
                if (CamelDebugTarget.this.debugger == null || CamelDebugTarget.this.isSuspended()) continue;
                try {
                    Set<String> suspendedBreakpoints = CamelDebugTarget.this.debugger.getSuspendedBreakpointNodeIds();
                    if (suspendedBreakpoints != null && !suspendedBreakpoints.isEmpty()) {
                        CamelDebugTarget.this.suspend();
                        for (String nodeId : suspendedBreakpoints) {
                            String endpointId;
                            BacklogTracerEventMessage evMsg = CamelDebugUtils.getBacklogTracerEventMessage(CamelDebugTarget.this.getMessagesForNode(nodeId));
                            String id = CamelDebugTarget.this.generateKey(evMsg);
                            CamelThread t = CamelDebugTarget.this.getThreadForId(id);
                            String string = endpointId = t.getTopStackFrame() != null ? ((CamelStackFrame)t.getTopStackFrame()).getEndpointId() : null;
                            if (nodeId.equals(endpointId) || t.isSuspended()) continue;
                            CamelDebugTarget.this.breakpointHit(nodeId, evMsg);
                            CamelDebugTarget.this.resume();
                        }
                    }
                    Thread.sleep(2000L);
                }
                catch (Exception ex) {
                    Activator.getLogger().error((Throwable)ex);
                }
            }
            return Status.OK_STATUS;
        }
    }

    class JMXConnectJob
    extends Job {
        private static final long CONNECTION_TIMEOUT = 60000L;

        public JMXConnectJob() {
            super("Connect to Camel Debugger...");
            this.setSystem(false);
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Connect to Camel VM...", 1);
            long startTime = System.currentTimeMillis();
            boolean connected = false;
            while (!connected && System.currentTimeMillis() - startTime <= 60000L && !monitor.isCanceled()) {
                try {
                    if (!CamelDebugTarget.this.connectToVM()) continue;
                    CamelDebugTarget.this.debugger = new CamelDebugFacade(CamelDebugTarget.this, CamelDebugTarget.this.mbsc, CamelDebugTarget.this.camelContextId, CamelDebugTarget.this.contentType);
                    connected = true;
                    CamelDebugTarget.this.started(true);
                    if (CamelDebugTarget.this.debugger.isEnabled()) continue;
                    CamelDebugTarget.this.debugger.enableDebugger();
                }
                catch (Exception ex) {
                    Activator.getLogger().error((Throwable)ex);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        monitor.setCanceled(true);
                    }
                }
            }
            if (!connected) {
                try {
                    CamelDebugTarget.this.abort("Unable to connect to Camel VM", new Exception("Unable to connect to Camel Debugger"));
                }
                catch (DebugException ex) {
                    Activator.getLogger().error((Throwable)ex);
                }
            }
            monitor.done();
            return connected ? Status.OK_STATUS : Status.CANCEL_STATUS;
        }
    }

    class ThreadGarbageCollector
    extends Job {
        private final long THREAD_LIFE_DURATION = 150000L;

        public ThreadGarbageCollector() {
            super("Thread CleanUp Service");
            this.THREAD_LIFE_DURATION = 150000L;
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            while (!CamelDebugTarget.this.isTerminated() && !monitor.isCanceled()) {
                try {
                    for (CamelThread t : CamelDebugTarget.this.threads.values()) {
                        if (t.isSuspended() || System.currentTimeMillis() - t.getLastSuspended() <= 150000L) continue;
                        t.terminate();
                    }
                    Thread.sleep(60000L);
                }
                catch (InterruptedException ex) {
                    Activator.getLogger().error((Throwable)ex);
                }
                catch (DebugException de) {
                    Activator.getLogger().error((Throwable)de);
                }
            }
            return Status.OK_STATUS;
        }
    }
}

