/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.model;

import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.fusesource.ide.launcher.Activator;
import org.fusesource.ide.launcher.debug.model.CamelDebugTarget;
import org.fusesource.ide.launcher.debug.model.ICamelDebuggerMBeanFacade;

public class CamelDebugFacade
implements ICamelDebuggerMBeanFacade {
    private static final boolean DEVELOPER_MODE = false;
    private static final String CAMEL_PROCESSOR_MBEAN = "org.apache.camel:type=processors,name=\"%s\",*";
    private static final String CAMEL_DEBUGGER_MBEAN_DEFAULT = "org.apache.camel:type=tracer,name=BacklogDebugger,*";
    private static final String CAMEL_CONTEXT_MBEAN = "org.apache.camel:type=context,name=\"%s\",*";
    private static final long TIMEOUT_MBEAN_REGISTRATION = 30000L;
    private ObjectName objectNameDebugger = null;
    private ObjectName objectNameContext = null;
    private CamelDebugTarget debugTarget;
    private String contextId;
    private String contentType;
    private MBeanServerConnection mbsc;

    public CamelDebugFacade(CamelDebugTarget debugTarget, MBeanServerConnection mbsc, String contextId, String contextType) throws Exception {
        this.mbsc = mbsc;
        this.debugTarget = debugTarget;
        this.contextId = contextId;
        this.contentType = contextType;
        long startTime = System.currentTimeMillis();
        while (this.objectNameDebugger == null && System.currentTimeMillis() - startTime <= 30000L) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            this.initializeDebuggerMBean();
        }
    }

    private void initializeDebuggerMBean() throws Exception {
        ObjectInstance oMbean;
        Set<ObjectInstance> mbeans = this.mbsc.queryMBeans(new ObjectName(CAMEL_DEBUGGER_MBEAN_DEFAULT), null);
        if (mbeans.size() == 1 && (oMbean = mbeans.iterator().next()) instanceof ObjectInstance) {
            ObjectInstance oi = oMbean;
            this.objectNameDebugger = oi.getObjectName();
        }
    }

    private void initializeContextMBean() throws Exception {
        ObjectInstance oMbean;
        Set<ObjectInstance> mbeans = this.mbsc.queryMBeans(new ObjectName(String.format(CAMEL_CONTEXT_MBEAN, this.contextId)), null);
        if (mbeans.size() == 1 && (oMbean = mbeans.iterator().next()) instanceof ObjectInstance) {
            ObjectInstance oi = oMbean;
            this.objectNameContext = oi.getObjectName();
        }
    }

    private ObjectName initializeProcessorMBean(String processorId) throws Exception {
        ObjectInstance oMbean;
        Set<ObjectInstance> mbeans = this.mbsc.queryMBeans(new ObjectName(String.format(CAMEL_PROCESSOR_MBEAN, processorId)), null);
        if (mbeans.size() == 1 && (oMbean = mbeans.iterator().next()) instanceof ObjectInstance) {
            ObjectInstance oi = oMbean;
            return oi.getObjectName();
        }
        return null;
    }

    @Override
    public String getContextId() {
        return this.contextId;
    }

    @Override
    public void updateContext(String xmlDump) {
        CamelDebugFacade.log("updateContext(" + xmlDump + ")");
        try {
            try {
                this.disableDebugger();
                this.resumeAll();
                this.debugTarget.resumeAllThreads();
                this.mbsc.invoke(this.objectNameContext, "addOrUpdateRoutesFromXml", new Object[]{xmlDump}, new String[]{String.class.getName()});
            }
            catch (Exception ex) {
                Activator.getLogger().error((Throwable)ex);
                this.enableDebugger();
                this.debugTarget.started(false);
            }
        }
        finally {
            this.enableDebugger();
            this.debugTarget.started(false);
        }
    }

    @Override
    public String getLoggingLevel() {
        CamelDebugFacade.log("getLoggingLevel()");
        try {
            String logLevel = (String)this.mbsc.invoke(this.objectNameDebugger, "getLoggingLevel", new Object[0], new String[0]);
            return logLevel;
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
            return null;
        }
    }

    @Override
    public void setLoggingLevel(String level) {
        CamelDebugFacade.log("setLoggingLevel(" + level + ")");
        try {
            this.mbsc.invoke(this.objectNameDebugger, "setLoggingLevel", new Object[]{level}, new String[]{String.class.getName()});
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public boolean isEnabled() {
        CamelDebugFacade.log("isEnabled()");
        try {
            boolean b = (Boolean)this.mbsc.invoke(this.objectNameDebugger, "isEnabled", new Object[0], new String[0]);
            return b;
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
            return false;
        }
    }

    @Override
    public void enableDebugger() {
        CamelDebugFacade.log("enableDebugger()");
        try {
            this.mbsc.invoke(this.objectNameDebugger, "enableDebugger", new Object[0], new String[0]);
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public void disableDebugger() {
        CamelDebugFacade.log("disableDebugger()");
        try {
            this.mbsc.invoke(this.objectNameDebugger, "disableDebugger", new Object[0], new String[0]);
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public void addBreakpoint(String nodeId) {
        CamelDebugFacade.log("addBreakpoint(" + nodeId + ")");
        try {
            this.mbsc.invoke(this.objectNameDebugger, "addBreakpoint", new Object[]{nodeId}, new String[]{String.class.getName()});
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public void addConditionalBreakpoint(String nodeId, String language, String predicate) {
        CamelDebugFacade.log("addConditionalBreakpoint(" + nodeId + ", " + language + ", " + predicate + ")");
        try {
            this.mbsc.invoke(this.objectNameDebugger, "addConditionalBreakpoint", new Object[]{nodeId, language, predicate}, new String[]{String.class.getName(), String.class.getName(), String.class.getName()});
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public void removeBreakpoint(String nodeId) {
        CamelDebugFacade.log("removeBreakpoint(" + nodeId + ")");
        try {
            this.mbsc.invoke(this.objectNameDebugger, "removeBreakpoint", new Object[]{nodeId}, new String[]{String.class.getName()});
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public void removeAllBreakpoints() {
        CamelDebugFacade.log("removeAllBreakpoints()");
        try {
            this.mbsc.invoke(this.objectNameDebugger, "removeAllBreakpoints", new Object[0], new String[0]);
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public void resumeBreakpoint(String nodeId) {
        CamelDebugFacade.log("resumeBreakpoint(" + nodeId + ")");
        try {
            this.mbsc.invoke(this.objectNameDebugger, "resumeBreakpoint", new Object[]{nodeId}, new String[]{String.class.getName()});
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public void setMessageBodyOnBreakpoint(String nodeId, Object body) {
        CamelDebugFacade.log("setMessageBodyOnBreakpoint(" + nodeId + ", " + body + ")");
        try {
            this.mbsc.invoke(this.objectNameDebugger, "setMessageBodyOnBreakpoint", new Object[]{nodeId, body}, new String[]{String.class.getName(), Object.class.getName()});
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public void setMessageBodyOnBreakpoint(String nodeId, Object body, String type) {
        CamelDebugFacade.log("setMessageBodyOnBreakpoint(" + nodeId + ", " + body + ", " + type + ")");
        try {
            this.mbsc.invoke(this.objectNameDebugger, "setMessageBodyOnBreakpoint", new Object[]{nodeId, body, type}, new String[]{String.class.getName(), Object.class.getName(), String.class.getName()});
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public void removeMessageBodyOnBreakpoint(String nodeId) {
        CamelDebugFacade.log("removeMessageBodyOnBreakpoint(" + nodeId + ")");
        try {
            this.mbsc.invoke(this.objectNameDebugger, "removeMessageBodyOnBreakpoint", new Object[]{nodeId}, new String[]{String.class.getName()});
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public void setMessageHeaderOnBreakpoint(String nodeId, String headerName, Object value) {
        CamelDebugFacade.log("setMessageHeaderOnBreakpoint(" + nodeId + ", " + headerName + ", " + value + ")");
        try {
            this.mbsc.invoke(this.objectNameDebugger, "setMessageHeaderOnBreakpoint", new Object[]{nodeId, headerName, value}, new String[]{String.class.getName(), String.class.getName(), Object.class.getName()});
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public void removeMessageHeaderOnBreakpoint(String nodeId, String headerName) {
        CamelDebugFacade.log("removeMessageHeaderOnBreakpoint(" + nodeId + ", " + headerName + ")");
        try {
            this.mbsc.invoke(this.objectNameDebugger, "removeMessageHeaderOnBreakpoint", new Object[]{nodeId, headerName}, new String[]{String.class.getName(), String.class.getName()});
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public void setMessageHeaderOnBreakpoint(String nodeId, String headerName, Object value, String type) {
        CamelDebugFacade.log("setMessageHeaderOnBreakpoint(" + nodeId + ", " + headerName + ", " + value + ", " + type + ")");
        try {
            this.mbsc.invoke(this.objectNameDebugger, "setMessageHeaderOnBreakpoint", new Object[]{nodeId, headerName, value, type}, new String[]{String.class.getName(), String.class.getName(), Object.class.getName(), String.class.getName()});
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public void resumeAll() {
        CamelDebugFacade.log("resumeAll()");
        try {
            this.mbsc.invoke(this.objectNameDebugger, "resumeAll", new Object[0], new String[0]);
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public void stepBreakpoint(String nodeId) {
        CamelDebugFacade.log("stepBreakpoint(" + nodeId + ")");
        try {
            this.mbsc.invoke(this.objectNameDebugger, "stepBreakpoint", new Object[]{nodeId}, new String[]{String.class.getName()});
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public boolean isSingleStepMode() {
        CamelDebugFacade.log("isSingleStepMode()");
        try {
            boolean b = (Boolean)this.mbsc.invoke(this.objectNameDebugger, "isSingleStepMode", new Object[0], new String[0]);
            return b;
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
            return false;
        }
    }

    @Override
    public void step() {
        CamelDebugFacade.log("step()");
        try {
            this.mbsc.invoke(this.objectNameDebugger, "step", new Object[0], new String[0]);
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public Set<String> getBreakpoints() {
        CamelDebugFacade.log("getBreakpoints()");
        try {
            return (HashSet)this.mbsc.invoke(this.objectNameDebugger, "getBreakpoints", new Object[0], new String[0]);
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
            return new HashSet<String>();
        }
    }

    @Override
    public Set<String> getSuspendedBreakpointNodeIds() throws Exception {
        CamelDebugFacade.log("getSuspendedBreakpointsNodeIds()");
        return (HashSet)this.mbsc.invoke(this.objectNameDebugger, "getSuspendedBreakpointNodeIds", new Object[0], new String[0]);
    }

    @Override
    public void disableBreakpoint(String nodeId) {
        CamelDebugFacade.log("disableBreakpoint(" + nodeId + ")");
        try {
            this.mbsc.invoke(this.objectNameDebugger, "disableBreakpoint", new Object[]{nodeId}, new String[]{String.class.getName()});
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public void enableBreakpoint(String nodeId) {
        CamelDebugFacade.log("enableBreakpoint(" + nodeId + ")");
        try {
            this.mbsc.invoke(this.objectNameDebugger, "enableBreakpoint", new Object[]{nodeId}, new String[]{String.class.getName()});
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public int getBodyMaxChars() {
        CamelDebugFacade.log("getBodyMaxChars()");
        try {
            int i = (Integer)this.mbsc.invoke(this.objectNameDebugger, "getBodyMaxChars", new Object[0], new String[0]);
            return i;
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
            return 0;
        }
    }

    @Override
    public void setBodyMaxChars(int bodyMaxChars) {
        CamelDebugFacade.log("setBodyMaxChars(" + bodyMaxChars + ")");
        try {
            this.mbsc.invoke(this.objectNameDebugger, "setBodyMaxChars", new Object[]{bodyMaxChars}, new String[]{"int"});
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public boolean isBodyIncludeStreams() {
        CamelDebugFacade.log("isBodyIncludeStreams()");
        try {
            boolean b = (Boolean)this.mbsc.invoke(this.objectNameDebugger, "isBodyIncludeStreams", new Object[0], new String[0]);
            return b;
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
            return false;
        }
    }

    @Override
    public void setBodyIncludeStreams(boolean bodyIncludeStreams) {
        CamelDebugFacade.log("setBodyIncludeStreams(" + bodyIncludeStreams + ")");
        try {
            this.mbsc.invoke(this.objectNameDebugger, "setBodyIncludeStreams", new Object[]{bodyIncludeStreams}, new String[]{"boolean"});
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public boolean isBodyIncludeFiles() {
        CamelDebugFacade.log("isBodyIncludeFiles()");
        try {
            boolean b = (Boolean)this.mbsc.invoke(this.objectNameDebugger, "isBodyIncludeFiles", new Object[0], new String[0]);
            return b;
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
            return false;
        }
    }

    @Override
    public void setBodyIncludeFiles(boolean bodyIncludeFiles) {
        CamelDebugFacade.log("setBodyIncludeFiles(" + bodyIncludeFiles + ")");
        try {
            this.mbsc.invoke(this.objectNameDebugger, "setBodyIncludeFiles", new Object[]{bodyIncludeFiles}, new String[]{"boolean"});
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public String dumpTracedMessagesAsXml(String nodeId) {
        CamelDebugFacade.log("dumpTracedMessagesAsXml()");
        try {
            String dump = (String)this.mbsc.invoke(this.objectNameDebugger, "dumpTracedMessagesAsXml", new Object[]{nodeId}, new String[]{String.class.getName()});
            CamelDebugFacade.log(">>>>>>>>>>>>> DUMP:\n" + dump);
            return dump;
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
            return null;
        }
    }

    @Override
    public long getDebugCounter() {
        CamelDebugFacade.log("getDebugCounter()");
        try {
            long l = (Long)this.mbsc.invoke(this.objectNameDebugger, "getDebugCounter", new Object[0], new String[0]);
            return l;
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
            return 0L;
        }
    }

    @Override
    public void resetDebugCounter() {
        CamelDebugFacade.log("resetDebugCounter()");
        try {
            this.mbsc.invoke(this.objectNameDebugger, "resetDebugCounter", new Object[0], new String[0]);
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public String getContextXmlDump() {
        CamelDebugFacade.log("getContextXmlDump(" + this.contextId + ")");
        if (this.objectNameContext == null) {
            try {
                this.initializeContextMBean();
            }
            catch (Exception ex) {
                Activator.getLogger().error((Throwable)ex);
                return null;
            }
        }
        try {
            String xmlDump = (String)this.mbsc.invoke(this.objectNameContext, "dumpRoutesAsXml", new Object[0], new String[0]);
            String contextDump = xmlDump.replaceFirst("<routes ", "<routes id=\"" + this.contextId + "\" ");
            return contextDump;
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
            return null;
        }
    }

    @Override
    public String getRouteId(String processorId) {
        CamelDebugFacade.log("getRouteId(" + processorId + ")");
        ObjectName objName = null;
        try {
            objName = this.initializeProcessorMBean(processorId);
            if (objName != null) {
                return (String)this.mbsc.getAttribute(objName, "RouteId");
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return null;
    }

    @Override
    public String getCamelId(String processorId) {
        CamelDebugFacade.log("getCamelId(" + processorId + ")");
        ObjectName objName = null;
        try {
            objName = this.initializeProcessorMBean(processorId);
            if (objName != null) {
                return (String)this.mbsc.getAttribute(objName, "CamelId");
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return null;
    }

    @Override
    public long getCompletedExchanges(String processorId) {
        CamelDebugFacade.log("getCompletedExchanges(" + processorId + ")");
        ObjectName objName = null;
        try {
            objName = this.initializeProcessorMBean(processorId);
            if (objName != null) {
                return (Long)this.mbsc.getAttribute(objName, "ExchangesCompleted");
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return -1L;
    }

    @Override
    public long getFailedExchanges(String processorId) {
        CamelDebugFacade.log("getFailedExchanges(" + processorId + ")");
        ObjectName objName = null;
        try {
            objName = this.initializeProcessorMBean(processorId);
            if (objName != null) {
                return (Long)this.mbsc.getAttribute(objName, "ExchangesFailed");
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return -1L;
    }

    @Override
    public long getTotalExchanges(String processorId) {
        CamelDebugFacade.log("getTotalExchanges(" + processorId + ")");
        ObjectName objName = null;
        try {
            objName = this.initializeProcessorMBean(processorId);
            if (objName != null) {
                return (Long)this.mbsc.getAttribute(objName, "ExchangesTotal");
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return -1L;
    }

    @Override
    public long getRedeliveries(String processorId) {
        CamelDebugFacade.log("getRedeliveries(" + processorId + ")");
        ObjectName objName = null;
        try {
            objName = this.initializeProcessorMBean(processorId);
            if (objName != null) {
                return (Long)this.mbsc.getAttribute(objName, "Redeliveries");
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return -1L;
    }

    @Override
    public long getExternalRedeliveries(String processorId) {
        CamelDebugFacade.log("getExternalRedeliveries(" + processorId + ")");
        ObjectName objName = null;
        try {
            objName = this.initializeProcessorMBean(processorId);
            if (objName != null) {
                return (Long)this.mbsc.getAttribute(objName, "ExternalRedeliveries");
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return -1L;
    }

    @Override
    public long getHandledFailures(String processorId) {
        CamelDebugFacade.log("getHandledFailures(" + processorId + ")");
        ObjectName objName = null;
        try {
            objName = this.initializeProcessorMBean(processorId);
            if (objName != null) {
                return (Long)this.mbsc.getAttribute(objName, "FailuresHandled");
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return -1L;
    }

    @Override
    public long getLastProcessingTime(String processorId) {
        CamelDebugFacade.log("getLastProcessingTime(" + processorId + ")");
        ObjectName objName = null;
        try {
            objName = this.initializeProcessorMBean(processorId);
            if (objName != null) {
                return (Long)this.mbsc.getAttribute(objName, "LastProcessingTime");
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return -1L;
    }

    @Override
    public long getMinProcessingTime(String processorId) {
        CamelDebugFacade.log("getMinProcessingTime(" + processorId + ")");
        ObjectName objName = null;
        try {
            objName = this.initializeProcessorMBean(processorId);
            if (objName != null) {
                return (Long)this.mbsc.getAttribute(objName, "MinProcessingTime");
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return -1L;
    }

    @Override
    public long getMaxProcessingTime(String processorId) {
        CamelDebugFacade.log("getMaxProcessingTime(" + processorId + ")");
        ObjectName objName = null;
        try {
            objName = this.initializeProcessorMBean(processorId);
            if (objName != null) {
                return (Long)this.mbsc.getAttribute(objName, "MaxProcessingTime");
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return -1L;
    }

    @Override
    public long getAverageProcessingTime(String processorId) {
        CamelDebugFacade.log("getAverageProcessingTime(" + processorId + ")");
        ObjectName objName = null;
        try {
            objName = this.initializeProcessorMBean(processorId);
            if (objName != null) {
                return (Long)this.mbsc.getAttribute(objName, "MeanProcessingTime");
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return -1L;
    }

    @Override
    public long getTotalProcessingTime(String processorId) {
        CamelDebugFacade.log("getTotalProcessingTime(" + processorId + ")");
        ObjectName objName = null;
        try {
            objName = this.initializeProcessorMBean(processorId);
            if (objName != null) {
                return (Long)this.mbsc.getAttribute(objName, "TotalProcessingTime");
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return -1L;
    }

    private static void log(String logString) {
    }
}

