/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.launching;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputerDelegate;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.WorkspaceSourceContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.fusesource.ide.launcher.debug.util.CamelDebugRegistry;
import org.fusesource.ide.launcher.util.CamelDebugContextEditorInput;

public class CamelSourcePathComputerDelegate
implements ISourcePathComputerDelegate {
    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        CamelDebugContextEditorInput input = CamelDebugRegistry.getInstance().getEntry(configuration).getEditorInput();
        IFile file = (IFile)input.getAdapter(IFile.class);
        WorkspaceSourceContainer sourceContainer = null;
        if (file != null) {
            sourceContainer = new DirectorySourceContainer(file.getLocation().toFile().getParentFile(), true);
        }
        if (sourceContainer == null) {
            sourceContainer = new WorkspaceSourceContainer();
        }
        ISourceContainer[] javaSourceContainers = this.computeJavaSourceContainers(configuration, monitor);
        ISourceContainer[] wsSourceContainers = this.computeWorkspaceSourceContainers(configuration, monitor);
        ISourceContainer[] sourceContainers = new ISourceContainer[javaSourceContainers.length + wsSourceContainers.length + 1];
        System.arraycopy(javaSourceContainers, 0, sourceContainers, 0, javaSourceContainers.length);
        System.arraycopy(wsSourceContainers, 0, sourceContainers, javaSourceContainers.length, wsSourceContainers.length);
        sourceContainers[sourceContainers.length - 1] = sourceContainer;
        return sourceContainers;
    }

    private ISourceContainer[] computeWorkspaceSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ISourceContainer[] containers = new ISourceContainer[projects.length];
        int i = 0;
        while (i < projects.length) {
            ProjectSourceContainer container = new ProjectSourceContainer(projects[i], false);
            containers[i] = container;
            ++i;
        }
        return containers;
    }

    private ISourceContainer[] computeJavaSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IRuntimeClasspathEntry[] unresolvedEntries = JavaRuntime.computeUnresolvedSourceLookupPath((ILaunchConfiguration)configuration);
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = wsRoot.getProjects();
        ArrayList<IJavaProject> javaProjectList = new ArrayList<IJavaProject>();
        this.processProjects(projects, javaProjectList, monitor);
        IRuntimeClasspathEntry[] projectEntries = new IRuntimeClasspathEntry[javaProjectList.size()];
        int i = 0;
        while (i < javaProjectList.size()) {
            projectEntries[i] = JavaRuntime.newProjectRuntimeClasspathEntry((IJavaProject)((IJavaProject)javaProjectList.get(i)));
            ++i;
        }
        IRuntimeClasspathEntry[] entries = new IRuntimeClasspathEntry[projectEntries.length + unresolvedEntries.length];
        System.arraycopy(unresolvedEntries, 0, entries, 0, unresolvedEntries.length);
        System.arraycopy(projectEntries, 0, entries, unresolvedEntries.length, projectEntries.length);
        IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveSourceLookupPath((IRuntimeClasspathEntry[])entries, (ILaunchConfiguration)configuration);
        ISourceContainer[] javaSourceContainers = JavaRuntime.getSourceContainers((IRuntimeClasspathEntry[])resolved);
        return javaSourceContainers;
    }

    private void processProjects(IProject[] projects, List<IJavaProject> javaProjectList, IProgressMonitor monitor) {
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (project != null && project.isAccessible()) {
                try {
                    IJavaProject javaProject;
                    if (project.hasNature("org.eclipse.jdt.core.javanature") && !javaProjectList.contains(javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature"))) {
                        javaProjectList.add(javaProject);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }
}

