/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.launching;

import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.ui.ISourcePresentation;
import org.eclipse.jdt.launching.sourcelookup.containers.JavaSourceLookupParticipant;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.fusesource.ide.launcher.debug.launching.CamelSourceLookupParticipant;
import org.fusesource.ide.launcher.debug.util.CamelDebugRegistry;
import org.fusesource.ide.launcher.debug.util.CamelDebugRegistryEntry;
import org.fusesource.ide.launcher.util.CamelDebugContextEditorInput;

public class CamelSourceLookupDirector
extends AbstractSourceLookupDirector
implements ISourcePresentation {
    public void initializeParticipants() {
        ISourceLookupParticipant[] participants = new ISourceLookupParticipant[]{new CamelSourceLookupParticipant(), new JavaSourceLookupParticipant()};
        this.addParticipants(participants);
    }

    public IEditorInput getEditorInput(Object element) {
        CamelDebugContextEditorInput input = null;
        if (element instanceof LocalFileStorage) {
            LocalFileStorage lfs = (LocalFileStorage)element;
            for (CamelDebugRegistryEntry entry : CamelDebugRegistry.getInstance().getEntries().values()) {
                IFile f = (IFile)entry.getEditorInput().getAdapter(IFile.class);
                if (!f.getLocation().toFile().getPath().equals(lfs.getFile().getPath())) continue;
                input = entry.getEditorInput();
                break;
            }
            return input;
        }
        if (element instanceof IFile) {
            IFile sourceFile = (IFile)element;
            if (sourceFile.getFileExtension().contentEquals("java")) {
                return new FileEditorInput(sourceFile);
            }
            for (CamelDebugRegistryEntry entry : CamelDebugRegistry.getInstance().getEntries().values()) {
                IFile f = (IFile)entry.getEditorInput().getAdapter(IFile.class);
                if (!f.getLocation().toFile().getName().equals(sourceFile.getName())) continue;
                input = entry.getEditorInput();
                break;
            }
            return input;
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        if (input instanceof FileEditorInput) {
            return "org.eclipse.jdt.ui.CompilationUnitEditor";
        }
        return "org.fusesource.ide.camel.editor";
    }
}

