/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorPart;
import org.jboss.tools.common.text.ext.hyperlink.XModelBasedHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jsf.text.ext.JSFExtensionsPlugin;
import org.jboss.tools.jst.web.tld.TaglibData;
import org.jboss.tools.jst.web.tld.VpeTaglibManager;
import org.jboss.tools.jst.web.tld.VpeTaglibManagerProvider;
import org.jboss.tools.jst.web.ui.internal.text.ext.util.TaglibManagerWrapper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LoadBundleHyperlink
extends XModelBasedHyperlink {
    private static final String VIEW_TAGNAME = "view";
    private static final String LOCALE_ATTRNAME = "locale";
    private static final String PREFIX_SEPARATOR = ":";

    protected String getRequestMethod() {
        return "jsf.open.bundle";
    }

    protected Properties getRequestProperties(IRegion region) {
        Properties p = new Properties();
        String value = this.getBundleBasename(region);
        value = value == null ? "" : value;
        p.setProperty("bundle", value);
        value = this.getPageLocale(region);
        if (value != null) {
            p.setProperty(LOCALE_ATTRNAME, value);
        }
        return p;
    }

    private String getBundleBasename(IRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (!(n instanceof Attr)) {
                return null;
            }
            Element lbTag = ((Attr)n).getOwnerElement();
            Attr lbTagBasename = lbTag.getAttributeNode("basename");
            if (lbTagBasename == null || lbTagBasename.getNodeValue() == null || lbTagBasename.getNodeValue().trim().length() == 0) {
                return null;
            }
            String string = lbTagBasename.getNodeValue();
            return string;
        }
        finally {
            smw.dispose();
        }
    }

    private String getPageLocale(IRegion region) {
        if (this.getDocument() == null || region == null) {
            return null;
        }
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(this.getDocument());
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            String[] prefixes = this.getLoadBundleTagPrefixes(region);
            if (prefixes == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (!(n instanceof Attr)) {
                return null;
            }
            Element el = ((Attr)n).getOwnerElement();
            Element jsfCoreViewTag = null;
            String[] stringArray = prefixes;
            int n2 = prefixes.length;
            int n3 = 0;
            while (n3 < n2) {
                String prefix = stringArray[n3];
                String nodeToFind = String.valueOf(prefix) + PREFIX_SEPARATOR + VIEW_TAGNAME;
                while (el != null) {
                    if (nodeToFind.equals(el.getNodeName())) {
                        jsfCoreViewTag = el;
                        break;
                    }
                    Node parent = el.getParentNode();
                    Element element = el = parent instanceof Element ? (Element)parent : null;
                }
                ++n3;
            }
            if (jsfCoreViewTag == null || !jsfCoreViewTag.hasAttribute(LOCALE_ATTRNAME)) {
                return null;
            }
            String locale = Utils.trimQuotes((String)jsfCoreViewTag.getAttributeNode(LOCALE_ATTRNAME).getValue());
            if (locale == null || locale.length() == 0) {
                return null;
            }
            String string = locale;
            return string;
        }
        finally {
            smw.dispose();
        }
    }

    public String getHyperlinkText() {
        String baseName = this.getBundleBasename(this.getHyperlinkRegion());
        if (baseName == null) {
            return MessageFormat.format(Messages.OpenA, Messages.Bundle);
        }
        return MessageFormat.format(Messages.OpenBundle, baseName);
    }

    protected String[] getLoadBundleTagPrefixes(IRegion region) {
        TaglibManagerWrapper tmw = new TaglibManagerWrapper();
        tmw.init(this.getDocument(), region.getOffset());
        if (tmw.exists()) {
            return new String[]{tmw.getCorePrefix()};
        }
        VpeTaglibManager taglibManager = this.getTaglibManager();
        if (taglibManager == null) {
            return null;
        }
        TaglibData[] data = taglibManager.getTagLibs().toArray(new TaglibData[0]);
        ArrayList<String> prefixes = new ArrayList<String>();
        int i = 0;
        while (i < data.length) {
            if ("http://java.sun.com/jsf/core".equals(data[i].getUri())) {
                prefixes.add(data[i].getPrefix());
            }
            ++i;
        }
        return null;
    }

    private VpeTaglibManager getTaglibManager() {
        IEditorPart editor = JSFExtensionsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor instanceof VpeTaglibManagerProvider) {
            return ((VpeTaglibManagerProvider)editor).getTaglibManager();
        }
        return null;
    }
}

