/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.ocl.AbstractEvaluationEnvironment;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.LazyExtentMap;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.uml.UMLEnvironmentFactory;
import org.eclipse.ocl.uml.internal.OCLStandardLibraryImpl;
import org.eclipse.ocl.uml.options.EvaluationMode;
import org.eclipse.ocl.uml.options.UMLEvaluationOptions;
import org.eclipse.ocl.uml.util.OCLUMLUtil;
import org.eclipse.ocl.util.CollectionUtil;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.ocl.util.Tuple;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralNull;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLSwitch;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLEvaluationEnvironment
extends AbstractEvaluationEnvironment<Classifier, Operation, Property, Class, EObject>
implements EvaluationEnvironment.Enumerations<EnumerationLiteral> {
    private static final EPackage CACHE_MISS = EcoreFactory.eINSTANCE.createEPackage();
    private final EPackage.Registry registry;
    private final Map<Package, EPackage> packageMap = new HashMap<Package, EPackage>();
    private final Map<Feature, String> featureNameMap = new HashMap<Feature, String>();
    private final UMLEnvironmentFactory factory;
    private ValueExtractor valueExtractor;

    public UMLEvaluationEnvironment(UMLEnvironmentFactory factory) {
        this.factory = factory;
        this.registry = factory.getEPackageRegistry();
    }

    public UMLEvaluationEnvironment(EvaluationEnvironment<Classifier, Operation, Property, Class, EObject> parent) {
        super(parent);
        UMLEvaluationEnvironment umlParent = (UMLEvaluationEnvironment)this.getParent();
        this.factory = umlParent.factory;
        this.registry = umlParent.getEPackageRegistry();
    }

    protected final EPackage.Registry getEPackageRegistry() {
        return this.registry;
    }

    protected EvaluationMode getEffectiveEvaluationMode() {
        return this.getEffectiveEvaluationMode(this.getValueOf("self"));
    }

    protected EvaluationMode getEffectiveEvaluationMode(Object context) {
        EvaluationMode result = (EvaluationMode)((Object)this.getValue(UMLEvaluationOptions.EVALUATION_MODE));
        if (result == EvaluationMode.ADAPTIVE) {
            result = context instanceof InstanceSpecification ? EvaluationMode.INSTANCE_MODEL : EvaluationMode.RUNTIME_OBJECTS;
        }
        return result;
    }

    public Object callOperation(Operation operation, int opcode, Object source, Object[] args) throws IllegalArgumentException {
        return this.coerceValue((Feature)operation, super.callOperation((Object)operation, opcode, source, args), true);
    }

    protected Method getJavaMethodFor(Operation operation, Object receiver) {
        Method result = null;
        String operName = this.getEcoreOperationName(operation);
        int opcode = OCLStandardLibraryUtil.getOperationCode((String)operName);
        switch (opcode) {
            case 1: {
                operName = "plus";
                break;
            }
            case 2: {
                operName = "minus";
                break;
            }
            case 3: {
                operName = "times";
                break;
            }
            case 4: {
                operName = "divide";
                break;
            }
            case 67: {
                operName = "lessThan";
                break;
            }
            case 69: {
                operName = "lessThanEqual";
                break;
            }
            case 68: {
                operName = "greaterThan";
                break;
            }
            case 70: {
                operName = "greaterThanEqual";
            }
        }
        Classifier container = (Classifier)operation.getOwner();
        EClassifier eclassifier = this.getEClassifier(container, receiver);
        java.lang.Class containerClass = eclassifier.getInstanceClass();
        EList parms = operation.getOwnedParameters();
        BasicEList javaParms = new BasicEList(parms.size());
        int i = 0;
        int n = parms.size();
        while (i < n) {
            Parameter parm = (Parameter)parms.get(i);
            if (parm.getDirection() != ParameterDirectionKind.RETURN_LITERAL) {
                if (parm.isMultivalued()) {
                    javaParms.add(EList.class);
                } else {
                    eclassifier = this.getEClassifier((Classifier)parm.getType(), receiver);
                    javaParms.add((Object)eclassifier.getInstanceClass());
                }
            }
            ++i;
        }
        try {
            result = containerClass.getMethod(operName, (java.lang.Class[])javaParms.toArray((Object[])new java.lang.Class[javaParms.size()]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return result;
    }

    private String getEcoreOperationName(Operation operation) {
        String result = this.featureNameMap.get(operation);
        if (result == null) {
            String alias;
            result = operation.getName();
            Stereotype stereo = this.getAppliedEcoreStereotype((Element)operation, "EOperation");
            if (stereo != null && (alias = (String)operation.getValue(stereo, "operationName")) != null && alias.length() > 0) {
                result = alias;
            }
            this.featureNameMap.put((Feature)operation, result);
        }
        return result;
    }

    private Stereotype getAppliedEcoreStereotype(Element element, String name) {
        return element.getAppliedStereotype("Ecore::" + name);
    }

    protected Object getInvalidResult() {
        return OCLStandardLibraryImpl.INVALID;
    }

    public Object navigateProperty(Property property, List<?> qualifiers, Object source) throws IllegalArgumentException {
        switch (this.getEffectiveEvaluationMode()) {
            case INSTANCE_MODEL: {
                InstanceSpecification instance = (InstanceSpecification)source;
                Association association = property.getOwningAssociation();
                if (association != null && !this.isInstance((Classifier)association, instance)) {
                    return this.navigateNonNavigableProperty(property, association, instance);
                }
                for (Slot slot : instance.getSlots()) {
                    if (slot.getDefiningFeature() != property) continue;
                    if (!qualifiers.isEmpty()) {
                        return this.findValueQualifiedBy(instance, property, qualifiers);
                    }
                    return this.getValue(slot);
                }
                for (Slot slot : instance.getSlots()) {
                    if (!this.redefines(slot.getDefiningFeature(), property)) continue;
                    if (!qualifiers.isEmpty()) {
                        return this.findValueQualifiedBy(instance, property, qualifiers);
                    }
                    return this.getValue(slot);
                }
                return this.isMultivaluedSlot(instance, property) ? CollectionUtil.createNewCollection((CollectionKind)UMLEvaluationEnvironment.getCollectionKind((Feature)property)) : null;
            }
            case RUNTIME_OBJECTS: {
                Tuple tuple;
                if (source instanceof EObject) {
                    EStructuralFeature eEnd;
                    EObject esource = (EObject)source;
                    EStructuralFeature feature = esource.eClass().getEStructuralFeature(this.getEcoreAttributeName(property));
                    if (feature != null) {
                        Object result = esource.eGet(feature);
                        return this.coerceValue((Feature)property, result, true);
                    }
                    Property otherEnd = property.getOtherEnd();
                    if (otherEnd == null) break;
                    EClass eclass = null;
                    Element owner = otherEnd.getOwner();
                    if (owner instanceof Classifier && owner != otherEnd.getAssociation()) {
                        eclass = (EClass)OCLUMLUtil.getEClassifier((Classifier)owner, source, this.registry);
                    }
                    if (eclass == null || (eEnd = eclass.getEStructuralFeature(this.getEcoreAttributeName(otherEnd))) == null) break;
                    Collection<Object> result = this.createCollection((Feature)property);
                    if (esource.eContainmentFeature() == eEnd) {
                        result.add(esource.eContainer());
                    } else {
                        for (EStructuralFeature.Setting setting : UML2Util.getNonNavigableInverseReferences((EObject)esource)) {
                            if (setting.getEStructuralFeature() != eEnd) continue;
                            result.add(setting.getEObject());
                        }
                    }
                    return this.coerceValue((Feature)property, result, false);
                }
                if (!(source instanceof Tuple) || !(tuple = (Tuple)source).getTupleType().oclProperties().contains((Object)property)) break;
                return tuple.getValue((Object)property);
            }
        }
        throw new IllegalArgumentException("no such property: " + property.getName());
    }

    private String getEcoreAttributeName(Property attribute) {
        String result = this.featureNameMap.get(attribute);
        if (result == null) {
            String alias;
            Stereotype stereo = this.getAppliedEcoreStereotype((Element)attribute, "EAttribute");
            String aliasAttribute = "attributeName";
            if (stereo == null) {
                stereo = this.getAppliedEcoreStereotype((Element)attribute, "EReference");
                aliasAttribute = "referenceName";
            }
            if (stereo != null && (alias = (String)attribute.getValue(stereo, aliasAttribute)) != null && alias.length() > 0) {
                result = alias;
            }
            if (result == null) {
                result = UMLUtil.getValidJavaIdentifier((String)attribute.getName());
            }
            this.featureNameMap.put((Feature)attribute, result);
        }
        return result;
    }

    private static CollectionKind getCollectionKind(Feature feature) {
        MultiplicityElement element = null;
        if (feature instanceof MultiplicityElement) {
            element = (MultiplicityElement)feature;
        } else if (feature instanceof Operation) {
            element = ((Operation)feature).getReturnResult();
        }
        if (element != null) {
            return element.isMultivalued() ? CollectionKind.getKind((boolean)element.isOrdered(), (boolean)element.isUnique()) : null;
        }
        return null;
    }

    private Collection<Object> createCollection(Feature feature) {
        CollectionKind kind = UMLEvaluationEnvironment.getCollectionKind(feature);
        if (kind != null) {
            return CollectionUtil.createNewCollection((CollectionKind)kind);
        }
        return new BasicEList.FastCompare();
    }

    private Object coerceValue(Feature feature, Object value, boolean copy) {
        CollectionKind kind = UMLEvaluationEnvironment.getCollectionKind(feature);
        if (kind != null) {
            if (value instanceof Collection) {
                return copy ? CollectionUtil.createNewCollection((CollectionKind)kind, (Collection)((Collection)value)) : value;
            }
            Collection result = CollectionUtil.createNewCollection((CollectionKind)kind);
            result.add(value);
            return result;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.isEmpty() ? null : collection.iterator().next();
        }
        return value;
    }

    private Object navigateNonNavigableProperty(Property property, Association association, InstanceSpecification instance) {
        Set result = CollectionUtil.createNewSet();
        Property otherEnd = property.getOtherEnd();
        for (Slot slot : this.getSlotsReferencing(instance)) {
            InstanceSpecification referencer;
            if (slot.getDefiningFeature() != otherEnd || (referencer = slot.getOwningInstance()) == null) continue;
            if (this.isInstance((Classifier)association, referencer)) {
                ValueSpecification value;
                Slot otherSlot = this.getSlot(referencer, property);
                if (otherSlot == null) continue;
                ValueSpecification valueSpecification = value = otherSlot.getValues().isEmpty() ? null : (ValueSpecification)otherSlot.getValues().get(0);
                if (value == null || !(value instanceof InstanceValue)) continue;
                result.add(((InstanceValue)value).getInstance());
                continue;
            }
            result.add(referencer);
        }
        return this.coerceValue((Feature)property, result, true);
    }

    private boolean redefines(StructuralFeature feature, Property redefined) {
        if (feature == redefined) {
            return true;
        }
        if (feature instanceof Property) {
            Property property = (Property)feature;
            for (Property next : property.getRedefinedProperties()) {
                if (!this.redefines((StructuralFeature)next, redefined)) continue;
                return true;
            }
        }
        return false;
    }

    private Object getValue(Slot slot) {
        EList values = slot.getValues();
        if (this.isMultivaluedSlot(slot)) {
            StructuralFeature feature = slot.getDefiningFeature();
            return this.getValueExtractor().extractValues((Collection<? extends ValueSpecification>)values, CollectionKind.getKind((boolean)feature.isOrdered(), (boolean)feature.isUnique()));
        }
        return values.isEmpty() ? null : this.getValueExtractor().extractValue((ValueSpecification)values.get(0));
    }

    private boolean isMultivaluedSlot(Slot slot) {
        return this.isMultivaluedSlot(slot.getOwningInstance(), (Property)slot.getDefiningFeature());
    }

    private boolean isMultivaluedSlot(InstanceSpecification owner, Property property) {
        Classifier classifier;
        Classifier classifier2 = classifier = owner.getClassifiers().isEmpty() ? null : (Classifier)owner.getClassifiers().get(0);
        if (classifier instanceof Association) {
            return property.getAssociation() != classifier && property.isMultivalued();
        }
        return property.isMultivalued();
    }

    private ValueExtractor getValueExtractor() {
        if (this.valueExtractor == null) {
            this.valueExtractor = new ValueExtractor();
        }
        return this.valueExtractor;
    }

    Object findValueQualifiedBy(InstanceSpecification source, Property property, List<?> qualifiers) {
        Association association = property.getAssociation();
        Property otherEnd = property.getOtherEnd();
        for (EStructuralFeature.Setting setting : UML2Util.getNonNavigableInverseReferences((EObject)source)) {
            Slot slot;
            InstanceValue value;
            if (setting.getEStructuralFeature() != UMLPackage.Literals.INSTANCE_VALUE__INSTANCE || !((value = (InstanceValue)setting.getEObject()).getOwner() instanceof Slot) || (slot = (Slot)value.getOwner()).getDefiningFeature() != otherEnd) continue;
            InstanceSpecification link = slot.getOwningInstance();
            for (Classifier c : link.getClassifiers()) {
                if (!c.conformsTo((Type)association) || !this.match(link, (List<Property>)property.getQualifiers(), qualifiers)) continue;
                return this.navigateProperty(property, Collections.emptyList(), (Object)link);
            }
        }
        return null;
    }

    private boolean match(InstanceSpecification instance, List<Property> properties, List<?> values) {
        int found = 0;
        for (Slot slot : instance.getSlots()) {
            Object actualValue;
            int index = properties.indexOf(slot.getDefiningFeature());
            if (index < 0 || !UML2Util.safeEquals((Object)(actualValue = this.getValue(slot)), values.get(index))) continue;
            ++found;
        }
        return found == properties.size();
    }

    public Object navigateAssociationClass(Classifier associationClass, Property navigationSource, Object source) throws IllegalArgumentException {
        switch (this.getEffectiveEvaluationMode()) {
            case INSTANCE_MODEL: {
                InstanceSpecification sourceInstance = (InstanceSpecification)source;
                EList ends = navigationSource != null ? Collections.singleton(navigationSource.getOtherEnd()) : ((AssociationClass)associationClass).getMemberEnds();
                Set links = CollectionUtil.createNewSet();
                for (Slot slot : this.getSlotsReferencing(sourceInstance)) {
                    InstanceSpecification link;
                    if (!ends.contains(slot.getDefiningFeature()) || !this.isInstance(associationClass, link = slot.getOwningInstance())) continue;
                    links.add(link);
                }
                if (navigationSource != null && !navigationSource.isMultivalued()) {
                    return links.isEmpty() ? null : (InstanceSpecification)links.iterator().next();
                }
                return links;
            }
        }
        throw new IllegalArgumentException("no such association class: " + associationClass.getName());
    }

    private boolean isInstance(Classifier classifier, InstanceSpecification instance) {
        for (Classifier c : instance.getClassifiers()) {
            if (!c.conformsTo((Type)classifier)) continue;
            return true;
        }
        return false;
    }

    private Slot getSlot(InstanceSpecification instance, Property property) {
        for (Slot slot : instance.getSlots()) {
            if (slot.getDefiningFeature() != property) continue;
            return slot;
        }
        return null;
    }

    private Collection<Slot> getSlotsReferencing(InstanceSpecification instance) {
        Set result = CollectionUtil.createNewSet();
        for (EStructuralFeature.Setting setting : UML2Util.getNonNavigableInverseReferences((EObject)instance)) {
            InstanceValue value;
            if (setting.getEStructuralFeature() != UMLPackage.Literals.INSTANCE_VALUE__INSTANCE || !((value = (InstanceValue)setting.getEObject()).getOwner() instanceof Slot)) continue;
            result.add((Slot)value.getOwner());
        }
        return result;
    }

    public Tuple<Operation, Property> createTuple(Classifier type, Map<Property, Object> values) {
        TupleType tupleType = (TupleType)type;
        return new AbstractEvaluationEnvironment.AbstractTuple<Operation, Property>(tupleType, values){

            protected String getName(Property part) {
                return part.getName();
            }
        };
    }

    public Map<Class, Set<EObject>> createExtentMap(Object object) {
        if (object instanceof EObject) {
            switch (this.getEffectiveEvaluationMode(object)) {
                case INSTANCE_MODEL: {
                    return new LazyExtentMap<Class, EObject>((EObject)object){

                        protected boolean isInstance(Class cls, EObject element) {
                            boolean result = false;
                            if (element instanceof InstanceSpecification) {
                                EList classifiers = ((InstanceSpecification)element).getClassifiers();
                                for (Classifier c : classifiers) {
                                    if (!c.conformsTo((Type)cls)) continue;
                                    result = true;
                                    break;
                                }
                            }
                            return result;
                        }
                    };
                }
                case RUNTIME_OBJECTS: {
                    return new LazyExtentMap<Class, EObject>((EObject)object){

                        protected boolean isInstance(Class cls, EObject element) {
                            EClassifier eclass = UMLEvaluationEnvironment.this.getEClassifier((Classifier)cls, element);
                            return eclass != null && eclass.isInstance((Object)element);
                        }
                    };
                }
            }
        }
        return Collections.emptyMap();
    }

    public boolean isKindOf(Object object, Classifier classifier) {
        switch (this.getEffectiveEvaluationMode()) {
            case INSTANCE_MODEL: {
                if (object instanceof ValueSpecification) {
                    ValueSpecification value = (ValueSpecification)object;
                    if (value.getType() == null) break;
                    Classifier type = (Classifier)value.getType();
                    if (type == OCLStandardLibraryImpl.INSTANCE.getInteger() && classifier == OCLStandardLibraryImpl.INSTANCE.getReal()) {
                        return true;
                    }
                    return type.conformsTo((Type)classifier);
                }
                if (!(object instanceof InstanceSpecification)) break;
                InstanceSpecification instance = (InstanceSpecification)object;
                for (Classifier c : instance.getClassifiers()) {
                    if (!c.conformsTo((Type)classifier)) continue;
                    return true;
                }
                break;
            }
            case RUNTIME_OBJECTS: {
                if (!(object instanceof EObject)) break;
                EClassifier eclassifier = this.getEClassifier(classifier, object);
                if (eclassifier == null) {
                    return false;
                }
                if (object.getClass() == Integer.class && eclassifier.getInstanceClass() == Double.class) {
                    return Boolean.TRUE;
                }
                return eclassifier.isInstance(object);
            }
        }
        return false;
    }

    public boolean isTypeOf(Object object, Classifier classifier) {
        switch (this.getEffectiveEvaluationMode()) {
            case INSTANCE_MODEL: {
                if (object instanceof ValueSpecification) {
                    ValueSpecification value = (ValueSpecification)object;
                    return value.getType() == classifier;
                }
                if (!(object instanceof InstanceSpecification)) break;
                return ((InstanceSpecification)object).getClassifiers().contains((Object)classifier);
            }
            case RUNTIME_OBJECTS: {
                if (!(object instanceof EObject)) break;
                EClassifier eclassifier = this.getEClassifier(classifier, object);
                if (eclassifier == null) {
                    return false;
                }
                if (eclassifier instanceof EClass && object instanceof EObject) {
                    return ((EObject)object).eClass() == eclassifier;
                }
                if (object instanceof EObject || eclassifier instanceof EClass) break;
                return object.getClass() == eclassifier.getInstanceClass();
            }
        }
        return false;
    }

    public Classifier getType(Object object) {
        return this.factory.getClassifier(object);
    }

    protected EPackage getEPackage(Package pkg) {
        EPackage result = this.packageMap.get(pkg);
        if (result == null) {
            result = OCLUMLUtil.getEPackage(pkg, this.registry);
            if (result == null) {
                result = CACHE_MISS;
            }
            this.packageMap.put(pkg, result);
        }
        return result == CACHE_MISS ? null : result;
    }

    protected EClassifier getEClassifier(Classifier umlClassifier, Object element) {
        EClassifier result = null;
        Package umlPackage = umlClassifier.getPackage();
        EPackage ecorePackage = null;
        if (umlPackage instanceof Profile) {
            Profile profile = (Profile)umlPackage;
            if (element instanceof Element) {
                Element umlElement = (Element)element;
                Package nesting = umlElement.getNearestPackage();
                while (nesting != null) {
                    ProfileApplication appl = nesting.getProfileApplication(profile);
                    if (appl != null) {
                        ecorePackage = appl.getAppliedDefinition();
                        break;
                    }
                    Package package_ = nesting = nesting.getOwner() == null ? null : nesting.getOwner().getNearestPackage();
                }
            }
            if (ecorePackage == null) {
                ecorePackage = profile.getDefinition();
            }
        } else if (umlPackage != null) {
            ecorePackage = this.getEPackage(umlPackage);
        }
        if (ecorePackage != null) {
            result = ecorePackage.getEClassifier(UML2Util.getValidJavaIdentifier((String)umlClassifier.getName()));
        }
        return result;
    }

    public Object getValue(EnumerationLiteral enumerationLiteral) {
        if (this.getEffectiveEvaluationMode() == EvaluationMode.RUNTIME_OBJECTS) {
            EEnumLiteral eLiteral;
            Object context = this.getValueOf("self");
            Enumeration umlEnum = enumerationLiteral.getEnumeration();
            EClassifier eType = OCLUMLUtil.getEClassifier((Classifier)umlEnum, context, this.getEPackageRegistry());
            if (eType instanceof EEnum && (eLiteral = (EEnumLiteral)((EEnum)eType).getELiterals().get(umlEnum.getOwnedLiterals().indexOf((Object)enumerationLiteral))) != null) {
                return eLiteral.getInstance();
            }
        }
        return enumerationLiteral;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValueExtractor
    extends UMLSwitch<Object> {
        ValueExtractor() {
        }

        public Object caseLiteralBoolean(LiteralBoolean object) {
            return object.booleanValue();
        }

        public Object caseLiteralInteger(LiteralInteger object) {
            return new Integer(object.integerValue());
        }

        public Object caseLiteralNull(LiteralNull object) {
            return null;
        }

        public Object caseLiteralString(LiteralString object) {
            return object.stringValue();
        }

        public Object caseLiteralUnlimitedNatural(LiteralUnlimitedNatural object) {
            return new Integer(object.unlimitedValue());
        }

        public Object caseInstanceValue(InstanceValue object) {
            return object.getInstance();
        }

        public Object caseValueSpecification(ValueSpecification object) {
            return OCLStandardLibraryImpl.INVALID;
        }

        Collection<?> extractValues(Collection<? extends ValueSpecification> values, CollectionKind collectionKind) {
            Collection result = CollectionUtil.createNewCollection((CollectionKind)collectionKind);
            for (ValueSpecification valueSpecification : values) {
                result.add(this.extractValue(valueSpecification));
            }
            return result;
        }

        Object extractValue(ValueSpecification value) {
            return this.doSwitch((EObject)value);
        }
    }
}

