/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.tests.common;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.junit.Assert;

public class ClasspathHelpers {
    public static IClasspathEntry getClasspathEntry(IClasspathEntry[] cp, IPath path) {
        IClasspathEntry[] iClasspathEntryArray = cp;
        int n = cp.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            if (path.equals((Object)cpe.getPath())) {
                return cpe;
            }
            ++n2;
        }
        Assert.fail((String)("Missing classpath entry " + path));
        return null;
    }

    public static IClasspathEntry getClasspathEntry(IClasspathEntry[] cp, String path) {
        return ClasspathHelpers.getClasspathEntry(cp, (IPath)new Path(path));
    }

    public static void assertClasspathEntry(IClasspathEntry[] cp, String ... segments) {
        int count = 0;
        IClasspathEntry[] iClasspathEntryArray = cp;
        int n = cp.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            if (ClasspathHelpers.startsWith(cpe.getPath(), segments)) {
                ++count;
            }
            ++n2;
        }
        Assert.assertEquals((String)("Unexpected classpath with prefix " + Arrays.toString(segments)), (long)1L, (long)count);
    }

    private static boolean startsWith(IPath path, String[] segments) {
        if (path.segmentCount() < segments.length) {
            return false;
        }
        int i = 0;
        while (i < segments.length) {
            if (!segments[i].equals(path.segment(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void assertClasspathEntry(IClasspathEntry[] cp, IPath path) {
        int count = 0;
        IClasspathEntry[] iClasspathEntryArray = cp;
        int n = cp.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            if (cpe.getPath().equals((Object)path)) {
                ++count;
            }
            ++n2;
        }
        Assert.assertEquals((String)("Number of classpath entries with path " + path), (long)1L, (long)count);
    }

    public static void assertClasspath(String[] expectedPathPatterns, IClasspathEntry[] cp) {
        boolean matches = false;
        if (expectedPathPatterns.length == cp.length) {
            matches = true;
            int i = 0;
            while (i < expectedPathPatterns.length) {
                if (!Pattern.matches(expectedPathPatterns[i], cp[i].getPath().toPortableString())) {
                    matches = false;
                    break;
                }
                ++i;
            }
        }
        if (!matches) {
            StringBuilder sb_expected = new StringBuilder();
            String[] stringArray = expectedPathPatterns;
            int n = expectedPathPatterns.length;
            int n2 = 0;
            while (n2 < n) {
                String expected = stringArray[n2];
                sb_expected.append(expected).append("\n");
                ++n2;
            }
            StringBuilder sb_actual = new StringBuilder();
            IClasspathEntry[] iClasspathEntryArray = cp;
            int n3 = cp.length;
            n = 0;
            while (n < n3) {
                IClasspathEntry cpe = iClasspathEntryArray[n];
                sb_actual.append(cpe.getPath().toPortableString()).append("\n");
                ++n;
            }
            Assert.assertEquals((String)"Unexpected classpath", (Object)sb_expected.toString(), (Object)sb_actual.toString());
        }
    }

    public static IClasspathAttribute getClasspathAttribute(IClasspathEntry entry, String attributeName) {
        IClasspathAttribute[] iClasspathAttributeArray = entry.getExtraAttributes();
        int n = iClasspathAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute a = iClasspathAttributeArray[n2];
            if (attributeName.equals(a.getName())) {
                return a;
            }
            ++n2;
        }
        return null;
    }
}

