/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAccessType;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAccessorTypeAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceXmlAccessorTypeAnnotation
extends SourceAnnotation
implements XmlAccessorTypeAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.xml.bind.annotation.XmlAccessorType");
    private static final DeclarationAnnotationElementAdapter<String> VALUE_ADAPTER = SourceXmlAccessorTypeAnnotation.buildValueAdapter();
    private final AnnotationElementAdapter<String> valueAdapter;
    private XmlAccessType value;
    private TextRange valueTextRange;

    public SourceXmlAccessorTypeAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement) {
        super((JavaResourceModel)parent, annotatedElement, DECLARATION_ANNOTATION_ADAPTER);
        this.valueAdapter = new AnnotatedElementAnnotationElementAdapter(annotatedElement, VALUE_ADAPTER);
    }

    public String getAnnotationName() {
        return "javax.xml.bind.annotation.XmlAccessorType";
    }

    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.value = this.buildValue(astAnnotation);
        this.valueTextRange = this.buildValueTextRange(astAnnotation);
    }

    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncValue(this.buildValue(astAnnotation));
        this.valueTextRange = this.buildValueTextRange(astAnnotation);
    }

    public void toString(StringBuilder sb) {
        sb.append((Object)this.value);
    }

    @Override
    public XmlAccessType getValue() {
        return this.value;
    }

    @Override
    public void setValue(XmlAccessType value) {
        if (ObjectTools.notEquals((Object)((Object)this.value), (Object)((Object)value))) {
            this.value = value;
            this.valueAdapter.setValue((Object)XmlAccessType.toJavaAnnotationValue(value));
        }
    }

    private void syncValue(XmlAccessType astValue) {
        XmlAccessType old = this.value;
        this.value = astValue;
        this.firePropertyChanged("value", (Object)old, (Object)astValue);
    }

    private XmlAccessType buildValue(Annotation astAnnotation) {
        return XmlAccessType.fromJavaAnnotationValue(this.valueAdapter.getValue(astAnnotation));
    }

    @Override
    public TextRange getValueTextRange() {
        return this.valueTextRange;
    }

    private TextRange buildValueTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(VALUE_ADAPTER, astAnnotation);
    }

    private static DeclarationAnnotationElementAdapter<String> buildValueAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "value");
    }
}

