/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.jsf.template;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.tools.jsf.vpe.jsf.template.AbstractOutputJsfTemplate;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JsfOutputFormatTemplate
extends AbstractOutputJsfTemplate {
    private static final String CHOICE_NAME = "choice";
    private static final String MESSAGE_FORMAT_ELEMENTS_SEPARATOR = ",";
    private static final String CHOICES_SEPARATOR = "\\|";
    private static final String CHOICE_PAIR_SEPARATOR = "#";
    private static final String MESSAGE_FORMAT_ELEMENTS_PATTERN = "\\{(\\d+)(,.*?){0,2}?\\}";

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        Element element = (Element)sourceNode;
        nsIDOMElement span = visualDocument.createElement("span");
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)span);
        this.copyOutputJsfAttributes(span, element);
        this.processOutputAttribute(pageContext, visualDocument, element, span, creationData);
        return creationData;
    }

    public boolean recreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualNode, Object data, String name, String value) {
        return true;
    }

    @Override
    protected String prepareAttrValue(VpePageContext pageContext, Element parent, Attr attr) {
        return this.prepareAttrValueByParams(attr.getNodeValue(), this.getParams(parent));
    }

    private String prepareAttrValueByParams(String nodeValue, List<Element> paramList) {
        Matcher matcher = Pattern.compile(MESSAGE_FORMAT_ELEMENTS_PATTERN).matcher(nodeValue);
        int lastPos = 0;
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String messageFormatElement = matcher.group();
            int start = matcher.start();
            int end = matcher.end();
            String value = this.parseMessageFormatElement(messageFormatElement, paramList);
            sb.append(nodeValue.substring(lastPos, start));
            sb.append(value);
            lastPos = end;
        }
        sb.append(nodeValue.substring(lastPos));
        return sb.toString();
    }

    private String parseMessageFormatElement(String messageFormatElement, List<Element> paramList) {
        String choice;
        String format;
        String value = null;
        String[] parametres = messageFormatElement.split(MESSAGE_FORMAT_ELEMENTS_SEPARATOR);
        if (parametres.length > 2 && CHOICE_NAME.equalsIgnoreCase(format = parametres[1].trim()) && (choice = this.getChoice(parametres[2])) != null) {
            value = choice.replaceAll("[\\{\\}]", "");
        }
        if (value == null) {
            String paramNumber = parametres[0].trim();
            paramNumber = paramNumber.replaceAll("[\\{\\}]", "");
            try {
                int num = Integer.decode(paramNumber);
                if (num < paramList.size() && paramList.get(num).hasAttribute("value")) {
                    Element paramElement = paramList.get(num);
                    value = paramElement.hasAttribute("value") ? paramElement.getAttribute("value") : null;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return value != null ? value : messageFormatElement;
    }

    private String getChoice(String choiceString) {
        String[] choices = choiceString.split(CHOICES_SEPARATOR);
        String[] choice = choices[0].split(CHOICE_PAIR_SEPARATOR);
        if (choice.length > 1) {
            return choice[1];
        }
        return null;
    }

    private List<Element> getParams(Element sourcElement) {
        NodeList nodeList = sourcElement.getChildNodes();
        ArrayList<Element> params = new ArrayList<Element>();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node child = nodeList.item(i);
            if ("param".equals(child.getLocalName())) {
                params.add((Element)child);
            }
            ++i;
        }
        return params;
    }
}

