/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal.util;

import java.net.URI;
import java.net.URISyntaxException;

public class URIUtils {
    public static URIConverter convert(String path) throws URISyntaxException {
        return new URIConverter(new URI(path));
    }

    public static URIConverter convert(URI uri) {
        return new URIConverter(uri);
    }

    public static class URIConverter {
        private final URI originalURI;
        private String targetHost;

        public URIConverter(URI originalURI) {
            this.originalURI = originalURI;
        }

        public String toPort(int newPort) throws URISyntaxException {
            URI modifiedURI = new URI(this.originalURI.getScheme(), null, this.targetHost != null ? this.targetHost : this.originalURI.getHost(), newPort, this.originalURI.getPath(), this.originalURI.getQuery(), this.originalURI.getFragment());
            return modifiedURI.toString();
        }

        public URIConverter toHost(String targetHost) {
            this.targetHost = targetHost;
            return this;
        }
    }
}

