/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal.server.jetty;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.EventObject;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.livereload.core.internal.service.EventService;
import org.jboss.tools.livereload.core.internal.service.LiveReloadClientConnectedEvent;
import org.jboss.tools.livereload.core.internal.service.LiveReloadClientDisconnectedEvent;
import org.jboss.tools.livereload.core.internal.service.ServerResourcePublishedEvent;
import org.jboss.tools.livereload.core.internal.service.ServerResourcePublishedFilter;
import org.jboss.tools.livereload.core.internal.service.Subscriber;
import org.jboss.tools.livereload.core.internal.service.WorkspaceResourceChangedEvent;
import org.jboss.tools.livereload.core.internal.service.WorkspaceResourceChangedEventFallbackFilter;
import org.jboss.tools.livereload.core.internal.service.WorkspaceResourceChangedEventFilter;
import org.jboss.tools.livereload.core.internal.util.Logger;
import org.jboss.tools.livereload.core.internal.util.ProjectUtils;
import org.jboss.tools.livereload.core.internal.util.ReloadCommandGenerator;
import org.jboss.tools.livereload.core.internal.util.WSTUtils;

public class LiveReloadWebSocket
implements WebSocket.OnTextMessage,
Subscriber {
    private static final String helloServerToClientHandShakeMessage = "{\"command\":\"hello\",\"protocols\":[\"http://livereload.com/protocols/official-7\"]}";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static EventService eventService = EventService.getInstance();
    private final String clientId;
    private final String clientAddress;
    private WebSocket.Connection connection;
    private String browserLocation = null;
    private boolean fallbackMode = false;
    private final UUID id = UUID.randomUUID();

    public LiveReloadWebSocket(String userAgent, String clientAddress) {
        this.clientId = (userAgent != null ? userAgent : "unknown User-Agent") + " at " + (clientAddress != null ? clientAddress : "unknown IP Address");
        this.clientAddress = clientAddress;
    }

    public void onOpen(WebSocket.Connection connection) {
        Logger.debug("Opening connection {} -> {}", this.id, this.getId());
        this.connection = connection;
    }

    public void onClose(int closeCode, String message) {
        Logger.debug("LiveReload client connection closed (" + this.id + ") with code " + closeCode + " and message " + message);
        eventService.unsubscribe(this);
        if (this.connection != null) {
            eventService.publish(new LiveReloadClientDisconnectedEvent(this.connection));
        }
    }

    public void sendMessage(String data) throws IOException {
        if (!this.connection.isOpen()) {
            Logger.debug("Removing pending closed connection {}", this.getId());
            eventService.unsubscribe(this);
            return;
        }
        Logger.debug("Sending message from websocket#{}: '{}'", this.id, data);
        this.connection.sendMessage(data);
    }

    public void onMessage(String data) {
        Logger.debug("Received message on socket #{}: '{}'", this.id, data);
        try {
            JsonNode rootNode = mapper.readTree(data);
            String commandValue = rootNode.path("command").asText();
            if ("hello".equals(commandValue)) {
                this.sendMessage(helloServerToClientHandShakeMessage);
            } else if ("info".equals(commandValue) || "url".equals(commandValue)) {
                this.browserLocation = rootNode.path("url").asText();
                this.fallbackMode = false;
                if (this.browserLocation == null) {
                    return;
                }
                if (this.browserLocation.startsWith("file:///")) {
                    IProject project = ProjectUtils.extractProject(this.browserLocation);
                    eventService.subscribe(this, new WorkspaceResourceChangedEventFilter(project));
                    eventService.publish(new LiveReloadClientConnectedEvent(project));
                } else if (this.browserLocation.startsWith("http://")) {
                    IServer server = WSTUtils.extractServer(this.browserLocation);
                    if (server != null && WSTUtils.isLiveReloadServer(server)) {
                        IProject project = ProjectUtils.findProjectFromResourceLocation((IPath)new Path(new URL(this.browserLocation).getFile()));
                        eventService.subscribe(this, new WorkspaceResourceChangedEventFilter(project));
                        eventService.publish(new LiveReloadClientConnectedEvent(project));
                    } else if (server != null) {
                        eventService.subscribe(this, new ServerResourcePublishedFilter(server));
                        eventService.publish(new LiveReloadClientConnectedEvent(server));
                    } else {
                        this.fallbackMode = true;
                        eventService.subscribe(this, new WorkspaceResourceChangedEventFallbackFilter());
                        eventService.publish(new LiveReloadClientConnectedEvent(this.browserLocation));
                        Logger.info("Falling back to file changes notification for browser location: " + this.browserLocation);
                    }
                } else {
                    this.connection.close();
                }
            }
        }
        catch (IOException e) {
            Logger.error("Failed to reply to LivreReload client hand-shake", e);
        }
    }

    @Override
    public void inform(EventObject e) {
        try {
            if (e instanceof WorkspaceResourceChangedEvent) {
                if (this.fallbackMode) {
                    String command = ReloadCommandGenerator.generateReloadCommand(this.browserLocation);
                    this.sendMessage(command);
                } else {
                    WorkspaceResourceChangedEvent event = (WorkspaceResourceChangedEvent)e;
                    List<String> commands = ReloadCommandGenerator.generateReloadCommands(event.getChangedResources());
                    for (String command : commands) {
                        this.sendMessage(command);
                    }
                }
            } else if (e instanceof ServerResourcePublishedEvent) {
                String command = ReloadCommandGenerator.generateReloadCommand(this.browserLocation);
                this.sendMessage(command);
            } else {
                Logger.debug("Ignoring event " + e);
            }
        }
        catch (URISyntaxException ex) {
            Logger.error("Failed to generate reload command to send to browser", ex);
        }
        catch (IOException ex) {
            Logger.error("Failed to send reload command to browser from socket #" + this.id, ex);
        }
    }

    public void destroy() {
        if (this.connection != null && this.connection.isOpen()) {
            this.connection.close();
        }
        eventService.unsubscribe(this);
    }

    @Override
    public String getId() {
        return String.valueOf(this.clientId) + " at " + this.browserLocation;
    }
}

