/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal.server.jetty;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.servlets.ProxyServlet;
import org.jboss.tools.livereload.core.internal.util.Logger;
import org.jboss.tools.livereload.core.internal.util.URIUtils;

public class ApplicationsProxyServlet
extends ProxyServlet {
    private final int targetPort;
    private final String targetHost;

    public ApplicationsProxyServlet(String targetHost, int targetPort) {
        this.targetHost = targetHost;
        this.targetPort = targetPort;
    }

    protected HttpURI proxyHttpURI(HttpServletRequest request, String uri) throws MalformedURLException {
        try {
            URI requestURI = new URI(uri);
            URI originalURI = new URI(request.getScheme(), requestURI.getUserInfo(), request.getServerName(), request.getLocalPort(), requestURI.getPath(), requestURI.getQuery(), requestURI.getFragment());
            String proxiedURI = URIUtils.convert(originalURI).toHost(this.targetHost).toPort(this.targetPort);
            return new HttpURI(proxiedURI);
        }
        catch (URISyntaxException e) {
            Logger.error("Failed to parse the requested URI", e);
            return null;
        }
    }
}

