/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.core.model.handlers;

import java.util.Properties;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.plugin.ModelMessages;
import org.jboss.tools.common.model.util.FindObjectHelper;

public class OpenScheduleHandler
extends AbstractHandler {
    public boolean isEnabled(XModelObject object) {
        return object != null && object.getAttributeValue("schedule id ref") != null && object.getAttributeValue("schedule id ref").length() > 0;
    }

    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        if (!this.isEnabled(object)) {
            return;
        }
        String scheduleID = object.getAttributeValue("schedule id ref");
        XModelObject schedule = this.findSchedule(FileSystemsHelper.getFile((XModelObject)object), scheduleID);
        if (schedule != null) {
            FindObjectHelper.findModelObject((XModelObject)schedule, (int)FindObjectHelper.IN_EDITOR_ONLY);
        } else {
            String message = "Cannot find schedule " + scheduleID;
            object.getModel().getService().showDialog(ModelMessages.WARNING, message, new String[]{SpecialWizardSupport.CLOSE}, null, 2);
        }
    }

    XModelObject findSchedule(XModelObject file, String scheduleID) {
        XModelObject[] ps = file.getChildByPath("Providers").getChildren();
        int i = 0;
        while (i < ps.length) {
            XModelObject[] cs = ps[i].getChildren();
            int j = 0;
            while (j < cs.length) {
                String v;
                if (cs[j].getModelEntity().getAttribute("schedule id") != null && scheduleID.equals(v = cs[j].getAttributeValue("schedule id"))) {
                    return cs[j];
                }
                ++j;
            }
            ++i;
        }
        return null;
    }
}

